/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.calendar.DataFilterInfo;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibIfDescriptor;
import netjfwatcher.engine.socket.info.StatisticsMibInfo;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class EditorNodeSnmpStatisticsChart
extends AbstractEditorNodeChart {
    private static Logger logger;
    private ArrayList oidInstanceList = new ArrayList();
    private String startDate;
    private String endDate;

    public EditorNodeSnmpStatisticsChart() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void setPopupMenu(Composite parent) {
        this.popUpMenu = new Menu((Decorations)parent.getShell(), 8);
        this.canvas.setMenu(this.popUpMenu);
        MenuItem menuItemAll = new MenuItem(this.popUpMenu, 0);
        menuItemAll.setText("All");
        MenuItem menuItemRefresh = new MenuItem(this.popUpMenu, 0);
        menuItemRefresh.setText("Refresh");
        if (this.itemNameList != null && this.itemNameList.size() > 1) {
            MenuItem[] menuItem = new MenuItem[this.itemNameList.size()];
            int i = 0;
            while (i < this.itemNameList.size()) {
                menuItem[i] = new MenuItem(this.popUpMenu, 0);
                menuItem[i].setText((String)this.itemNameList.get(i));
                final int itemCount = i;
                menuItem[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EditorNodeSnmpStatisticsChart.access$0("");
                        EditorNodeSnmpStatisticsChart.this.selectNo = itemCount;
                        EditorNodeSnmpStatisticsChart.this.redraw();
                    }
                });
                ++i;
            }
        }
        menuItemAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeSnmpStatisticsChart.access$0("all");
                EditorNodeSnmpStatisticsChart.this.selectNo = 0;
                EditorNodeSnmpStatisticsChart.this.redraw();
            }
        });
        menuItemRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    EditorNodeSnmpStatisticsChart.this.getChartData();
                }
                catch (DatabaseConnectionException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                EditorNodeSnmpStatisticsChart.access$0("all");
                EditorNodeSnmpStatisticsChart.this.selectNo = 0;
                EditorNodeSnmpStatisticsChart.this.redraw();
            }
        });
    }

    protected void getChartData() throws DatabaseConnectionException, SQLException {
        if (this.allStatisticsDataList == null) {
            this.oidInstanceList = new ArrayList();
            this.dateList = new ArrayList();
            this.allStatisticsDataList = new ArrayList();
        } else {
            this.oidInstanceList.clear();
            this.dateList.clear();
            this.allStatisticsDataList.clear();
        }
        String ipAddress = this.targetNodeInfo.getIpaddress();
        String selectOid = this.inputOid;
        ArrayList ifDescriptorList = null;
        DBTableStatisticsMIBControl mibDBTable = null;
        String engineAddress = "";
        if (!this.isSocket) {
            mibDBTable = DBTableStatisticsMIBControl.getInstance();
            ifDescriptorList = mibDBTable.findIfDescriptor(ipAddress);
        } else {
            Shell shell;
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand("If_Desc_Get");
            control.setIpaddress(ipAddress);
            engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
            try {
                StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(control);
                ifDescriptorList = mibproperty.getMibIfDescriptorList();
            }
            catch (EngineConnectException e) {
                shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
            }
            catch (IOException e) {
                shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
            }
        }
        int i = 0;
        while (i < ifDescriptorList.size()) {
            StatisticsMibIfDescriptor statisricsMibIfDesc = (StatisticsMibIfDescriptor)ifDescriptorList.get(i);
            String workOid = statisricsMibIfDesc.getOid();
            int checkPoint = "Oid=".length();
            if (checkPoint >= 0 && workOid.substring(checkPoint).equals(selectOid)) {
                this.oidInstanceList.add(statisricsMibIfDesc.getInstance());
            }
            ++i;
        }
        if (this.maxData == null) {
            this.maxData = new String[this.oidInstanceList.size()];
            this.minData = new String[this.oidInstanceList.size()];
        }
        StatisticsMibProperty mibProperty = null;
        int k = 0;
        while (k < this.oidInstanceList.size()) {
            String oidIns = (String)this.oidInstanceList.get(k);
            if (!this.isSocket) {
                mibProperty = mibDBTable.getDataCount(ipAddress, selectOid, oidIns);
            } else {
                Shell shell;
                StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
                statisticsMibControl.setSubCommand("Statistics_Data_Get");
                statisticsMibControl.setIpaddress(ipAddress);
                statisticsMibControl.setOid(selectOid);
                statisticsMibControl.setOidInstance(oidIns);
                ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
                try {
                    mibProperty = statisticsMibGet.getStatisticsMib(statisticsMibControl);
                }
                catch (EngineConnectException e) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
                catch (IOException e) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
            }
            if (mibProperty.getTotalDataCount() == 0 || mibProperty.getStartDate() == null || mibProperty.getEndDate() == null) {
                return;
            }
            this.startDate = mibProperty.getStartDate().toString();
            this.endDate = mibProperty.getEndDate().toString();
            this.maxData[k] = mibProperty.getMaxData();
            this.minData[k] = mibProperty.getMinData();
            ++k;
        }
        String filterCheckStart = DataFilterInfo.getInstance().getStartDate();
        String filterCheckEnd = DataFilterInfo.getInstance().getEndDate();
        String filterStart = filterCheckStart == null || filterCheckStart.equals("") ? this.startDate : filterCheckStart;
        String filterEnd = filterCheckEnd == null || filterCheckEnd.equals("") ? this.endDate : filterCheckEnd;
        int limit = DataFilterInfo.getInstance().getLimit();
        int j = 0;
        while (j < this.oidInstanceList.size()) {
            String instance = (String)this.oidInstanceList.get(j);
            ArrayList<String> instanceDataList = new ArrayList<String>();
            ArrayList dataList = null;
            if (!this.isSocket) {
                dataList = mibDBTable.findInstance(ipAddress, selectOid, instance, filterStart, filterEnd);
            } else {
                Shell shell;
                StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
                statisticsMibControl.setSubCommand("Statistics_Data_Get");
                statisticsMibControl.setIpaddress(ipAddress);
                statisticsMibControl.setOid(selectOid);
                statisticsMibControl.setOidInstance(instance);
                statisticsMibControl.setPeriodStartDate(filterStart);
                statisticsMibControl.setPeriodEndDate(filterEnd);
                ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
                try {
                    StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(statisticsMibControl);
                    dataList = mibproperty.getMibInfoList();
                }
                catch (EngineConnectException e) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
                catch (IOException e) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
            }
            int i2 = 0;
            while (i2 < dataList.size()) {
                StatisticsMibInfo instanceValueList = (StatisticsMibInfo)dataList.get(i2);
                if (j == 0) {
                    this.dateList.add(instanceValueList.getDate().toString());
                }
                instanceDataList.add(instanceValueList.getStatisMibValue());
                if (limit != 0 && i2 >= limit) break;
                ++i2;
            }
            this.allStatisticsDataList.add(instanceDataList);
            ++j;
        }
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    static /* synthetic */ void access$0(String string) {
        AbstractEditorNodeChart.mode = string;
    }
}

