/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsManager;
import netjfwatcher.engine.snmpmanager.process.SnmpV3UsmStatisticsInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpV3UsmStatisticsManager;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.ConnectionSnmpStatisricsInfo;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class EditorSnmpStatisticsInfo
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = " Snmp Statistics Info View";
    public static final int TEXT_WIDTH = 100;
    public static final int COUNT_TEXT_WIDTH = 70;
    public static final int DATE_TEXT_WIDTH = 150;
    private static Logger logger;
    public static final int IP_ADDRESS_POS = 0;
    public static final int NODE_NAME_POS = 1;
    public static final int SNMP_VERSION_POS = 2;
    public static final int SOCKET_TIMEOUT_POS = 3;
    public static final int UNMUCH_REQUEST_ID_POS = 4;
    public static final int ERROR_STATUS_POS = 5;
    public static final int UNMUCH_SNMPV3_MSG_ID_POS = 6;
    public static final int USM_UNSUPPORT_LEVELS_POS = 7;
    public static final int USM_NOT_INTIME_WINDOWS = 8;
    public static final int USM_UNKNOWN_USERNAME = 9;
    public static final int USM_UNKNOWN_ENGINE_ID = 10;
    public static final int USM_WRONG_DIGESTS = 11;
    public static final int USM_DECRYPTION_ERRORS = 12;
    public static final String[] COLUMN_HEADER;
    private static final float COLUMN_RATIO0 = 0.08f;
    private static final float COLUMN_STATISTICS_RATIO = 0.1f;
    private Button refreshButton;
    private TableViewer viewer;

    static {
        COLUMN_HEADER = new String[]{"IP Address", "Node name", "SNMP Version", "Socket timeout", "Unmuch request ID", "SnmpErrorStatus", "SnmpV3 Unmuch msgID", "UsmStatsUnsupportedSecLevels", "UsmStatsNotInTimeWindows", "UsmStatsUnknownUserNames", "UsmStatsUnknownEngineIDs", "UsmStatsWrongDigests", "UsmStatsDecryptionErrors"};
    }

    public EditorSnmpStatisticsInfo() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.isSocket = nodeViewEditorInput.isSocket();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(12, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        this.refreshButton = new Button(composite, 0);
        this.refreshButton.setText("Get Now");
        this.refreshButton.setLayoutData((Object)new GridData());
        Label label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        StatisticsTable statisticsTable = new StatisticsTable();
        this.table = statisticsTable.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.setTableStatisticsData();
        this.createContextMenu();
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorSnmpStatisticsInfo.this.refreshButton.setEnabled(false);
                try {
                    EditorSnmpStatisticsInfo.this.setTableStatisticsData();
                }
                finally {
                    EditorSnmpStatisticsInfo.this.refreshButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.setTableStatisticsData();
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditorSnmpStatisticsInfo.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void setTableStatisticsData() {
        this.table.removeAll();
        this.viewer.refresh();
        ArrayList nodeList = this.getNodeList();
        int dateCount = 0;
        while (dateCount < nodeList.size()) {
            NodeInformation nodeInfo = (NodeInformation)nodeList.get(dateCount);
            String[] statisticsInfo = null;
            if (!this.isSocket) {
                statisticsInfo = new String[COLUMN_HEADER.length];
                statisticsInfo[0] = nodeInfo.getIpaddress();
                statisticsInfo[1] = nodeInfo.getNodename();
                String snmpLevel = nodeInfo.getSnmpLevel();
                statisticsInfo[2] = !snmpLevel.equals("0") ? nodeInfo.getSnmpVersion() : "--";
                SnmpStatisticsInfo snmpInfo = SnmpStatisticsManager.getInstance().getSnmpStatisticsInfo(nodeInfo.getIpaddress());
                SnmpV3UsmStatisticsInfo snmpV3Info = SnmpV3UsmStatisticsManager.getInstance().getSnmpStatisticsInfo(nodeInfo.getIpaddress());
                statisticsInfo[3] = Integer.toString(snmpInfo.getSnmpSocketTimeout());
                statisticsInfo[4] = Integer.toString(snmpInfo.getSnmpUnmuchRequestID());
                statisticsInfo[5] = Integer.toString(snmpInfo.getSnmpErrorStatus());
                statisticsInfo[6] = Integer.toString(snmpInfo.getSnmpV3UnmuchmsgID());
                statisticsInfo[7] = Integer.toString(snmpV3Info.getUsmStatsUnsupportedSecLevels());
                statisticsInfo[8] = Integer.toString(snmpV3Info.getUsmStatsNotInTimeWindows());
                statisticsInfo[9] = Integer.toString(snmpV3Info.getUsmStatsUnknownUserNames());
                statisticsInfo[10] = Integer.toString(snmpV3Info.getUsmStatsUnknownEngineIDs());
                statisticsInfo[11] = Integer.toString(snmpV3Info.getUsmStatsWrongDigests());
                statisticsInfo[12] = Integer.toString(snmpV3Info.getUsmStatsDecryptionErrors());
            } else {
                Shell shell;
                String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                ConnectionSnmpStatisricsInfo connectNodeInfo = new ConnectionSnmpStatisricsInfo(engineAddress);
                try {
                    statisticsInfo = connectNodeInfo.getSnmpStatisticsInfo(nodeInfo);
                }
                catch (EngineConnectException e) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
                catch (IOException e) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(statisticsInfo);
            item.setData((Object)statisticsInfo);
            ++dateCount;
        }
    }

    public ArrayList getNodeList() {
        ArrayList nodeList = null;
        try {
            if (!this.isSocket) {
                DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
                nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
            } else {
                String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
                nodeList = connectNodeInfo.getNodeInformationList(null, null);
            }
        }
        catch (SQLException e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            shell.dispose();
            return nodeList;
        }
        catch (Exception e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            shell.dispose();
            return nodeList;
        }
        return nodeList;
    }

    private int computeNodeColWidth() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.08f);
    }

    private int computeStatisticsDataColWidth() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    private final class StatisticsTable
    extends AbstractTableView {
        private boolean[] isColDirection;

        private StatisticsTable() {
        }

        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            this.isColDirection = new boolean[COLUMN_HEADER.length];
            TableColumn[] col = new TableColumn[COLUMN_HEADER.length];
            int i = 0;
            while (i < col.length) {
                col[i] = new TableColumn(this.table, 0x1000000);
                col[i].setText(COLUMN_HEADER[i]);
                if (i <= 2) {
                    col[i].setWidth(EditorSnmpStatisticsInfo.this.computeNodeColWidth());
                } else {
                    col[i].setWidth(EditorSnmpStatisticsInfo.this.computeStatisticsDataColWidth());
                }
                this.isColDirection[i] = true;
                final int count = i;
                col[i].addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        ((StatisticsTable)StatisticsTable.this).isColDirection[count] = count <= 2 ? StatisticsTable.this.sortTable(StatisticsTable.this.table, count, StatisticsTable.this.isColDirection[count]) : StatisticsTable.this.sortIntegerTable(StatisticsTable.this.table, count, StatisticsTable.this.isColDirection[count]);
                    }
                });
                ++i;
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                    StatisticsTable.this.setResizedTableColumnWidth();
                }
            });
            return this.table;
        }

        protected void setResizedTableColumnWidth() {
            if (EditorSnmpStatisticsInfo.this.getEditorSite().getPage().isPartVisible(EditorSnmpStatisticsInfo.this.getEditorSite().getPart()) && this.getSite().getShell() != null) {
                this.getSite().getShell().getSize();
            }
        }
    }
}

