/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpv3;

import java.io.Serializable;

public class SnmpEngineID
implements Serializable {
    private static final long serialVersionUID = -8329761101443998815L;
    private static final int ID_LENGTH = 32;
    private byte[] id = null;

    public SnmpEngineID(byte[] engineID) {
        int length = 0;
        if (engineID != null) {
            length = engineID.length;
        }
        if (length > 32) {
            length = 32;
        }
        this.id = new byte[length];
        System.arraycopy(engineID, 0, this.id, 0, length);
    }

    public SnmpEngineID(String engineID) throws NumberFormatException {
        int length = 0;
        if (engineID != null) {
            if (engineID.length() % 2 != 0) {
                engineID = "0".concat(engineID);
            }
            length = engineID.length() / 2;
        }
        if (length > 32) {
            length = 32;
        }
        this.id = new byte[length];
        int i = 0;
        while (i < length) {
            this.id[i] = (byte)Integer.parseInt(engineID.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SnmpEngineID)) {
            return false;
        }
        SnmpEngineID engineID = (SnmpEngineID)obj;
        if (this.id.length != engineID.id.length) {
            return false;
        }
        int i = 0;
        int li = this.id.length;
        while (i < li) {
            if (this.id[i] != engineID.id[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int li = this.id.length;
        while (i < li) {
            String str = Integer.toHexString(this.id[i] & 0xFF);
            if (str.length() == 1) {
                sb.append("0");
            }
            sb.append(str);
            ++i;
        }
        return sb.toString();
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] id) {
        this.id = id;
    }
}

