/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmpagent.AbstractAgentView;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.process.AgentSysupTime;
import netjfwatcher.snmpagent.process.ThreadAgent;
import netjfwatcher.snmptest.SnmpErrorTest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AgentOperationView
extends AbstractAgentView {
    public static final int TEXT_WIDTH = 120;
    public static final int SNMPV3_TEXT_WIDTH = 250;
    private static final int COMBO_BOX_WIDTH = 150;
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{950, 400};
    private static Logger logger;
    private Text engineIDText;
    private Text engineBootText;
    private Text engineStartTimeText;
    private Text engineSysUpTimeText;
    private Text engineSysUpTimeDataText;
    private Button engineSysUpTimeUpdateButton;
    private Button refreshButton;
    private Text userNameText;
    private Text authPrivText;
    private Text authProtocolText;
    private Text authPassPhrasaText;
    private Text privProtocolText;
    private Text privPassPhrasaText;
    private Combo snmpErrorTestCombo;
    private Combo snmpErrorReportCombo;
    private Button errorTestSetButton;
    private Text allowHostText;
    private Text roCommunityText;
    private Text rwCommunityText;
    private Color textBackColor;
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = whiteColor;
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite baseComposite = new Composite((Composite)scrollComposite, 0);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData());
        GridLayout gridLayout = new GridLayout(7, false);
        Composite composite = new Composite(baseComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        GridData gridData = null;
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("Allow-Host");
        label.setLayoutData((Object)new GridData());
        this.allowHostText = new Text(composite, 2056);
        this.allowHostText.setEnabled(false);
        this.allowHostText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.allowHostText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("EngineID");
        label.setLayoutData((Object)new GridData());
        this.engineIDText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.engineIDText.setEnabled(false);
        this.engineIDText.setBackground(this.textBackColor);
        this.engineIDText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Error Test");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.snmpErrorTestCombo = new Combo(composite, 12);
        this.snmpErrorTestCombo.add("Normal");
        this.snmpErrorTestCombo.add("Wrong digest");
        this.snmpErrorTestCombo.add("Descryption error");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.snmpErrorTestCombo.setLayoutData((Object)gridData);
        this.snmpErrorTestCombo.select(0);
        this.errorTestSetButton = new Button(composite, 0);
        this.errorTestSetButton.setText("Error Set");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.errorTestSetButton.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Read Community");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.roCommunityText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.roCommunityText.setEnabled(false);
        this.roCommunityText.setBackground(this.textBackColor);
        this.roCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("EngineBoots");
        label.setLayoutData((Object)new GridData());
        this.engineBootText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.engineBootText.setEnabled(false);
        this.engineBootText.setBackground(this.textBackColor);
        this.engineBootText.setLayoutData((Object)gridData);
        this.setSnmpErrorReportCombo(composite);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Write Community");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.rwCommunityText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.rwCommunityText.setEnabled(false);
        this.rwCommunityText.setBackground(this.textBackColor);
        this.rwCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Engine Start Time");
        label.setLayoutData((Object)new GridData());
        this.engineStartTimeText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.engineStartTimeText.setEnabled(false);
        this.engineStartTimeText.setBackground(this.textBackColor);
        this.engineStartTimeText.setLayoutData((Object)gridData);
        this.setDummyColumnHorizontalSpan3(composite);
        this.setDummyColumnHorizontalSpan2(composite);
        label = new Label(composite, 0);
        label.setText("EngineSysUpTime");
        label.setLayoutData((Object)new GridData());
        this.engineSysUpTimeText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.engineSysUpTimeText.setEnabled(false);
        this.engineSysUpTimeText.setBackground(this.textBackColor);
        this.engineSysUpTimeText.setLayoutData((Object)gridData);
        this.setDummyColumnHorizontalSpan3(composite);
        this.setDummyColumnHorizontalSpan2(composite);
        label = new Label(composite, 0);
        label.setText("EngineSysUpTime Value (Sec)");
        label.setLayoutData((Object)new GridData());
        this.engineSysUpTimeDataText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.engineSysUpTimeDataText.setLayoutData((Object)gridData);
        this.engineSysUpTimeUpdateButton = new Button(composite, 0);
        this.engineSysUpTimeUpdateButton.setText("Update");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.refreshButton = new Button(composite, 0);
        this.refreshButton.setText("Refresh");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.setDummyColumnHorizontalSpan1(composite);
        this.setDummyColumnHorizontalSpan2(composite);
        label = new Label(composite, 0);
        label.setText("User Name");
        label.setLayoutData((Object)new GridData());
        this.userNameText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.userNameText.setEnabled(false);
        this.userNameText.setBackground(this.textBackColor);
        this.userNameText.setLayoutData((Object)gridData);
        this.setDummyColumnHorizontalSpan3(composite);
        this.setDummyColumnHorizontalSpan2(composite);
        label = new Label(composite, 0);
        label.setText("AuthPriv");
        label.setLayoutData((Object)new GridData());
        this.authPrivText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.authPrivText.setEnabled(false);
        this.authPrivText.setBackground(this.textBackColor);
        this.authPrivText.setLayoutData((Object)gridData);
        this.setDummyColumnHorizontalSpan3(composite);
        this.setDummyColumnHorizontalSpan2(composite);
        label = new Label(composite, 0);
        label.setText("AuthProtocol");
        label.setLayoutData((Object)new GridData());
        this.authProtocolText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.authProtocolText.setEnabled(false);
        this.authProtocolText.setBackground(this.textBackColor);
        this.authProtocolText.setLayoutData((Object)gridData);
        this.setDummyColumnHorizontalSpan3(composite);
        this.setDummyColumnHorizontalSpan2(composite);
        label = new Label(composite, 0);
        label.setText("AuthPassPhrase");
        label.setLayoutData((Object)new GridData());
        this.authPassPhrasaText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.authPassPhrasaText.setEnabled(false);
        this.authPassPhrasaText.setBackground(this.textBackColor);
        this.authPassPhrasaText.setLayoutData((Object)gridData);
        this.setDummyColumnHorizontalSpan3(composite);
        this.setDummyColumnHorizontalSpan2(composite);
        label = new Label(composite, 0);
        label.setText("PrivProtocol");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.privProtocolText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.privProtocolText.setEnabled(false);
        this.privProtocolText.setBackground(this.textBackColor);
        this.privProtocolText.setLayoutData((Object)gridData);
        this.setDummyColumnHorizontalSpan3(composite);
        this.setDummyColumnHorizontalSpan2(composite);
        label = new Label(composite, 0);
        label.setText("PrivPassPhrase");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.privPassPhrasaText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.privPassPhrasaText.setEnabled(false);
        this.privPassPhrasaText.setBackground(this.textBackColor);
        this.privPassPhrasaText.setLayoutData((Object)gridData);
        this.setDummyColumnHorizontalSpan3(composite);
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        SnmpErrorTest.getInstance().setAgentErrorControlCode("Normal");
        SnmpErrorTest.getInstance().setAgentErrorReportCode("Normal");
        this.setText();
        this.setListener();
        this.setSysupTime();
    }

    public void setText() {
        SnmpAgentConfigInfo snmpCommonInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        SnmpV3AgentConfigInfo snmpV3info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        this.allowHostText.setText(snmpCommonInfo.getAllowHost());
        this.roCommunityText.setText(snmpCommonInfo.getReadCommunity());
        this.rwCommunityText.setText(snmpCommonInfo.getWriteCommunity());
        this.engineIDText.setText(snmpV3info.getSnmpEngineID());
        this.engineBootText.setText(snmpV3info.getSnmpEngineBoots());
        this.engineStartTimeText.setText("");
        this.engineSysUpTimeText.setText("");
        this.engineSysUpTimeDataText.setText("");
        this.userNameText.setText(snmpV3info.getUserName());
        this.authPrivText.setText(snmpV3info.getAuthPriv());
        this.authProtocolText.setText(snmpV3info.getAuthProtocol());
        this.authPassPhrasaText.setText(snmpV3info.getAuthPassPhrase());
        this.privProtocolText.setText(snmpV3info.getPrivProtocol());
        this.privPassPhrasaText.setText(snmpV3info.getPrivPassPhrase());
    }

    private void setListener() {
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AgentOperationView.this.setText();
                AgentOperationView.this.setSysupTime();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.engineSysUpTimeUpdateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (MessageDialog.openQuestion((Shell)AgentOperationView.this.getSite().getShell(), (String)"Confirm Engine SysUp Time", (String)("Engine SysUp Time update ?, Progress time = " + AgentOperationView.this.engineSysUpTimeText.getText()))) {
                    AgentOperationView.this.updateEngineSysUpTime();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.engineSysUpTimeDataText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                String engineSysUpTimeDataString = AgentOperationView.this.engineSysUpTimeDataText.getText();
                try {
                    long sysupTimeMills = Long.parseLong(engineSysUpTimeDataString) * 1000L;
                    AgentOperationView.this.engineSysUpTimeText.setText(AgentOperationView.this.convertTime(sysupTimeMills));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warning("NumberFormatException " + engineSysUpTimeDataString);
                }
            }
        });
        this.errorTestSetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Set Error : error code=" + AgentOperationView.this.snmpErrorTestCombo.getText() + " , report error code=" + AgentOperationView.this.snmpErrorReportCombo.getText());
                SnmpErrorTest.getInstance().setAgentErrorControlCode(AgentOperationView.this.snmpErrorTestCombo.getText());
                SnmpErrorTest.getInstance().setAgentErrorReportCode(AgentOperationView.this.snmpErrorReportCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setSnmpErrorReportCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Error Report");
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.snmpErrorReportCombo = new Combo(composite, 12);
        this.snmpErrorReportCombo.add("Normal");
        this.snmpErrorReportCombo.add("Unsupported security level");
        this.snmpErrorReportCombo.add("Not in time packet");
        this.snmpErrorReportCombo.add("Unknown user name");
        this.snmpErrorReportCombo.add("Unknown engine ID");
        this.snmpErrorReportCombo.add("Wrong digest");
        this.snmpErrorReportCombo.add("Descryption error");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.snmpErrorReportCombo.setLayoutData((Object)gridData);
        this.snmpErrorReportCombo.select(0);
    }

    private void setDummyColumnHorizontalSpan1(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
    }

    private void setDummyColumnHorizontalSpan2(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
    }

    private void setDummyColumnHorizontalSpan3(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
    }

    public void updateSnmpAgentInfo() {
        SnmpAgentConfigInfo snmpCommonInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        SnmpV3AgentConfigInfo snmpV3info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        this.allowHostText.setText(snmpCommonInfo.getAllowHost());
        this.roCommunityText.setText(snmpCommonInfo.getReadCommunity());
        this.rwCommunityText.setText(snmpCommonInfo.getWriteCommunity());
        this.engineIDText.setText(snmpV3info.getSnmpEngineID());
        this.engineBootText.setText(snmpV3info.getSnmpEngineBoots());
        this.userNameText.setText(snmpV3info.getUserName());
        this.authPrivText.setText(snmpV3info.getAuthPriv());
        this.authProtocolText.setText(snmpV3info.getAuthProtocol());
        this.authPassPhrasaText.setText(snmpV3info.getAuthPassPhrase());
        this.privProtocolText.setText(snmpV3info.getPrivProtocol());
        this.privPassPhrasaText.setText(snmpV3info.getPrivPassPhrase());
    }

    public String convertTime(long time) {
        int baseUnit = 1000;
        int ms = (int)(time % (long)baseUnit);
        int second = (int)(time / (long)baseUnit % 60L);
        int minute = (int)(time / (long)baseUnit / 60L % 60L);
        int hour = (int)(time / (long)baseUnit / 60L / 60L % 24L);
        int day = (int)(time / (long)baseUnit / 60L / 60L / 24L);
        String timeData = String.valueOf(day) + "day  " + hour + "hour  " + minute + "min  " + second + "sec  " + ms + "msec";
        return timeData;
    }

    public void setSysupTime() {
        long agentStartTime = ThreadAgent.getInstance().getStartSnmpAgentEngineTime();
        Date agentDate = Calendar.getInstance().getTime();
        agentDate.setTime(agentStartTime);
        this.engineStartTimeText.setText(this.dateformat.format(agentDate));
        long sysupTimeMills = System.currentTimeMillis() - agentStartTime;
        this.engineSysUpTimeText.setText(this.convertTime(sysupTimeMills));
        this.engineSysUpTimeDataText.setText(Long.toString(sysupTimeMills / 1000L));
    }

    private void updateEngineSysUpTime() {
        String data = this.engineSysUpTimeDataText.getText();
        try {
            long sysupTimeMills = System.currentTimeMillis() - Long.parseLong(data) * 1000L;
            ThreadAgent.getInstance().setStartSnmpAgentEngineTime(sysupTimeMills);
            MibInfo miboid = AgentSysupTime.getInstance().updateSysupTime();
            this.setSysupTime();
            AgentInstanceDataRefreshQueue.getInstance().pushQueue(miboid);
        }
        catch (NumberFormatException numberFormatException) {
            MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
            alertMessageBox.setMessage("Illegal SysupTime data");
            alertMessageBox.open();
            this.engineSysUpTimeDataText.setFocus();
        }
    }
}

