/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.model;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.bit.SnmpBit;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmpagent.model.AgentDataImportException;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.process.ThreadAgent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Bundle;

public class AgentDataImport {
    public static final String SYSUPTIME_OID = "1.3.6.1.2.1.1.3.0";
    private static Logger logger = null;
    private static final String IPADENTADDR_OID_DESC = "ipAdEntAddr";
    private HashMap agentOidDescriptionMap = null;
    private HashMap<String, MibInfo> agentOidMap = null;
    private ArrayList<MibInfo> agentOidInfoList = new ArrayList();
    private ArrayList<String> searchOidDescriptionList = new ArrayList();
    private String deviceAddress = "";
    private String localIPAddr = "";
    private String messageChangeIPAddress = "";

    public AgentDataImport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setDefaultAgentData(String csvFile, Table table) throws AgentDataImportException, FileNotFoundException {
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = bundle.getEntry(csvFile);
        if (url == null) {
            throw new FileNotFoundException("FileNotFound : " + csvFile);
        }
        URLConnection con = null;
        InputStream in = null;
        try {
            con = url.openConnection();
            in = con.getInputStream();
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            throw new AgentDataImportException(e.getMessage());
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                this.parseAgentData(csvFile, bufferedReader, table);
            }
            catch (IOException e) {
                logger.warning("BufferedReader : " + e.getMessage());
                throw new AgentDataImportException("BufferedReader : " + e.getMessage());
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e1) {
                    logger.warning("BufferedReader close : " + e1.getMessage());
                    throw new AgentDataImportException("BufferedReader close : " + e1.getMessage());
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    logger.warning("InputStreamReader close : " + e1.getMessage());
                    throw new AgentDataImportException("InputStreamReader close : " + e1.getMessage());
                }
            }
        }
    }

    public String setAgentData(String csvFile) throws AgentDataImportException, FileNotFoundException {
        this.messageChangeIPAddress = "";
        FileReader fileReader = null;
        BufferedReader bufferReader = null;
        try {
            try {
                fileReader = new FileReader(csvFile);
                bufferReader = new BufferedReader(fileReader);
                this.parseAgentData(csvFile, bufferReader, null);
            }
            catch (FileNotFoundException e) {
                logger.warning("Import agent data file : " + e.getMessage() + " , file: " + csvFile);
                throw e;
            }
        }
        finally {
            if (bufferReader != null) {
                try {
                    bufferReader.close();
                }
                catch (IOException e1) {
                    logger.warning("BufferedReader close : " + e1.getMessage());
                    throw new AgentDataImportException("BufferedReader close : " + e1.getMessage());
                }
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e2) {
                    logger.warning("FileReader close : " + e2.getMessage());
                    throw new AgentDataImportException("FileReader close : " + e2.getMessage());
                }
            }
        }
        return this.messageChangeIPAddress;
    }

    private void parseAgentData(String csvFile, BufferedReader bufferReader, Table table) throws AgentDataImportException {
        this.agentOidInfoList.clear();
        this.searchOidDescriptionList.clear();
        try {
            this.localIPAddr = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e4) {
            logger.warning("UnknownHostException : " + e4.getMessage());
            e4.printStackTrace();
        }
        String[] arrayLine = null;
        int agentDataCounter = 1;
        try {
            try {
                AgentMibTree agentMibTable = AgentMibTree.getInstance();
                this.agentOidDescriptionMap = agentMibTable.getMibDescripHashMap();
                this.agentOidMap = agentMibTable.getOidHashMap();
                while ((arrayLine = this.splitReadLine(bufferReader.readLine(), "=")) != null) {
                    int oidPositionWork;
                    String[] workArrayLine = this.checkDeviceIPAddress(arrayLine);
                    if (workArrayLine != null) {
                        arrayLine = workArrayLine;
                    }
                    if ((oidPositionWork = arrayLine[0].lastIndexOf(".")) < 0) {
                        logger.warning("Format error import file : " + csvFile + " : line =" + agentDataCounter + "  " + arrayLine[0]);
                        continue;
                    }
                    String searchOidDescription = arrayLine[0].substring(0, oidPositionWork);
                    boolean isFound = false;
                    String searchOid = "";
                    MibInfo agentOidInfo = null;
                    int i = 0;
                    while (i < arrayLine[0].length()) {
                        if (this.agentOidDescriptionMap.containsKey(searchOidDescription)) {
                            isFound = true;
                            agentOidInfo = (MibInfo)this.agentOidDescriptionMap.get(searchOidDescription);
                            searchOid = String.valueOf(agentOidInfo.getOid()) + arrayLine[0].substring(searchOidDescription.length(), arrayLine[0].length());
                            break;
                        }
                        if (oidPositionWork < i) {
                            logger.warning("oidPositionWork : " + oidPositionWork);
                            logger.warning("i : " + i);
                            throw new AgentDataImportException("Undefined OID, import file : " + csvFile + " : line =" + agentDataCounter + " OID description=" + arrayLine[0]);
                        }
                        searchOidDescription = arrayLine[0].substring(0, oidPositionWork - i);
                        ++i;
                    }
                    oidPositionWork = searchOid.lastIndexOf(".");
                    if (oidPositionWork < 0) {
                        throw new AgentDataImportException("Undefined OID, import file : " + csvFile + " : line =" + agentDataCounter + " OID=" + searchOid);
                    }
                    String workSearchOid = searchOid.substring(0, oidPositionWork);
                    if (isFound) {
                        isFound = false;
                        int i2 = 0;
                        while (i2 < searchOid.length()) {
                            if (this.agentOidMap.containsKey(workSearchOid)) {
                                isFound = true;
                                agentOidInfo = this.agentOidMap.get(workSearchOid);
                                break;
                            }
                            int checkOidPos = workSearchOid.lastIndexOf(".");
                            if (checkOidPos < 0) break;
                            workSearchOid = workSearchOid.substring(0, checkOidPos);
                            ++i2;
                        }
                    }
                    if (agentOidInfo == null) {
                        logger.warning("Undefined OID, import file : " + csvFile + " : line =" + agentDataCounter);
                        throw new AgentDataImportException("Undefined OID, import file : " + csvFile + " : line =" + agentDataCounter);
                    }
                    AbstractSnmpObject agentSnmpObject = null;
                    try {
                        agentSnmpObject = arrayLine.length > 1 ? this.createAgentSnmpObject(arrayLine[1], agentOidInfo.getSyntax()) : this.createAgentSnmpObject("", agentOidInfo.getSyntax());
                        if (agentSnmpObject == null) {
                            continue;
                        }
                    }
                    catch (NumberFormatException e3) {
                        logger.warning("NumberFormatException " + e3.getMessage());
                        e3.printStackTrace();
                        throw new AgentDataImportException("Format error import file : " + csvFile + " : line =" + agentDataCounter);
                    }
                    catch (SnmpBadValueException e3) {
                        logger.warning("SnmpBadValueException " + e3.getMessage());
                        e3.printStackTrace();
                        throw new AgentDataImportException("Format error import file : " + csvFile + " : line =" + agentDataCounter);
                    }
                    String oidSuffix = arrayLine[0].substring(searchOidDescription.length(), arrayLine[0].length());
                    try {
                        this.searchOidDescriptionList.add(searchOidDescription);
                        this.createAgentOidInfo(agentOidInfo, oidSuffix, arrayLine[0], agentSnmpObject);
                        String descriptionSuffix = searchOid.substring(workSearchOid.length(), searchOid.length());
                        this.showTable(table, agentDataCounter, agentOidInfo, oidSuffix, descriptionSuffix, agentSnmpObject);
                        ++agentDataCounter;
                    }
                    catch (Exception e2) {
                        logger.warning(e2.getMessage());
                        e2.printStackTrace();
                        throw new AgentDataImportException("Format error import file : " + csvFile + " : line =" + agentDataCounter);
                    }
                }
                this.createAgentTree();
                this.setSysupTime();
            }
            catch (AgentDataImportException e) {
                throw e;
            }
            catch (Exception e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                throw new AgentDataImportException("Abort import file : " + csvFile);
            }
        }
        finally {
            if (bufferReader != null) {
                try {
                    bufferReader.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    public void setNetJFWatcher0() {
        this.agentOidInfoList.clear();
        this.searchOidDescriptionList.clear();
        AgentMibTree agentMibTable = AgentMibTree.getInstance();
        this.agentOidDescriptionMap = agentMibTable.getMibDescripHashMap();
        this.agentOidMap = agentMibTable.getOidHashMap();
        try {
            this.localIPAddr = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e4) {
            logger.warning("UnknownHostException : " + e4.getMessage());
            e4.printStackTrace();
        }
    }

    public void setNetJFWatcher1(int agentDataCounter, Table table, String searchOid, String oidSuffix, String value) throws SnmpBadValueException, Exception {
        MibInfo agentOidInfo = null;
        if (this.agentOidMap.containsKey(searchOid)) {
            agentOidInfo = this.agentOidMap.get(searchOid);
        }
        AbstractSnmpObject agentSnmpObject = null;
        agentSnmpObject = this.createAgentSnmpObject(value, agentOidInfo.getSyntax());
        this.searchOidDescriptionList.add(agentOidInfo.getDescrip());
        this.createAgentOidInfo(agentOidInfo, "." + oidSuffix, agentOidInfo.getDescrip(), agentSnmpObject);
        this.showTable(table, agentDataCounter, agentOidInfo, "." + oidSuffix, "." + oidSuffix, agentSnmpObject);
    }

    public void setNetJFWatcher2() {
        this.createAgentTree();
        this.setSysupTime();
    }

    private void createAgentOidInfo(MibInfo miboid, String oidSuffix, String agentDescription, AbstractSnmpObject agentSnmpObject) throws Exception {
        MibInfo agentMibInfo = new MibInfo();
        agentMibInfo.setAgentMibValue(agentSnmpObject);
        agentMibInfo.setOid(String.valueOf(miboid.getOid()) + oidSuffix);
        agentMibInfo.setDescrip(agentDescription);
        agentMibInfo.setAccess(miboid.getAccess());
        agentMibInfo.setAgentInstance(true);
        this.agentOidInfoList.add(agentMibInfo);
    }

    private void showTable(Table table, int agentDataCounter, MibInfo miboid, String oidSuffix, String agentDescriptionSuffix, AbstractSnmpObject agentSnmpObject) {
        String[] agentTableArray = new String[]{Long.toString(agentDataCounter), String.valueOf(miboid.getDescrip()) + agentDescriptionSuffix, String.valueOf(miboid.getOid()) + oidSuffix, agentSnmpObject.toString(), String.valueOf(miboid.getSyntax()), miboid.getAccess().equals("ro") ? "read-only" : (miboid.getAccess().equals("rw") ? "read-write" : "not-accessible")};
        MibInfo agentOidInfo = new MibInfo();
        agentOidInfo.setInstanceNo(agentDataCounter);
        agentOidInfo.setOid(agentTableArray[2]);
        agentOidInfo.setDescrip(agentTableArray[1]);
        agentOidInfo.setValue(agentTableArray[3]);
        agentOidInfo.setSyntax(agentTableArray[4]);
        agentOidInfo.setAccess(miboid.getAccess());
        agentOidInfo.setAgentInstance(true);
        AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(agentTableArray[2], agentOidInfo);
        if (table == null) {
            Table agentTable = NetJFWatcherApplication.getAgentTableView().getTable();
            TableItem tableItem = new TableItem(agentTable, 0);
            tableItem.setText(agentTableArray);
            tableItem.setData((Object)agentTableArray);
        } else {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(agentTableArray);
            tableItem.setData((Object)agentTableArray);
        }
    }

    private AbstractSnmpObject createAgentSnmpObject(String agentValue, String oidType) throws NumberFormatException, SnmpBadValueException {
        AbstractSnmpObject snmpObject;
        block28: {
            snmpObject = new SnmpNull();
            String checkValue = agentValue;
            String value = checkValue.indexOf("\"") == 0 && checkValue.lastIndexOf("\"") == checkValue.length() - 1 ? checkValue.substring(1, checkValue.length() - 1) : agentValue;
            if (oidType.equals("INTEGER")) {
                snmpObject = new SnmpInteger(Integer.parseInt(agentValue));
            } else if (oidType.equals("Counter32")) {
                snmpObject = new SnmpCounter32(Integer.parseInt(agentValue));
            } else if (oidType.equals("Counter64")) {
                snmpObject = new SnmpCounter64(Integer.parseInt(agentValue));
            } else if (oidType.equals("Gauge32")) {
                snmpObject = new SnmpGauge32(Integer.parseInt(agentValue));
            } else if (oidType.equals("OctetString")) {
                snmpObject = new SnmpOctetString(value);
            } else if (oidType.equals("IpAddress")) {
                snmpObject = new SnmpIPAddress(agentValue);
            } else if (oidType.equals("ObjectID")) {
                try {
                    snmpObject = new SnmpObjectIdentifier(agentValue);
                }
                catch (SnmpBadValueException snmpBadValueException) {
                    MibInfo workMibOid = (MibInfo)this.agentOidDescriptionMap.get(agentValue.substring(1, agentValue.length() - 1));
                    String detectObjectID = null;
                    if (workMibOid != null) {
                        detectObjectID = workMibOid.getOid();
                    }
                    if (detectObjectID != null) {
                        snmpObject = new SnmpObjectIdentifier(detectObjectID);
                        break block28;
                    }
                    snmpObject = new SnmpOctetString(value);
                }
            } else if (oidType.equals("TimeTicks")) {
                snmpObject = new SnmpTimeTicks(Integer.parseInt(agentValue));
            } else if (oidType.equals("Uinteger32")) {
                snmpObject = new SnmpUInteger32(Integer.parseInt(agentValue));
            } else if (oidType.equals("Bits")) {
                snmpObject = new SnmpBit(Integer.parseInt(value));
            } else if (oidType.equals("Opaque")) {
                snmpObject = new SnmpBit(Integer.parseInt(value));
            } else if (oidType.equals("DisplayString")) {
                snmpObject = new SnmpOctetString(value);
            } else {
                return null;
            }
        }
        return snmpObject;
    }

    private void createAgentTree() {
        int agentCount = 0;
        while (agentCount < this.agentOidInfoList.size()) {
            MibInfo nextAgentMibInfo = null;
            if (agentCount + 1 < this.agentOidInfoList.size()) {
                nextAgentMibInfo = this.agentOidInfoList.get(agentCount + 1);
            }
            MibInfo oidDefineInfo = (MibInfo)this.agentOidDescriptionMap.get(this.searchOidDescriptionList.get(agentCount));
            MibInfo agentMibInfo = this.agentOidInfoList.get(agentCount);
            oidDefineInfo.getAgaentMibInfoList().add(agentMibInfo);
            if (oidDefineInfo.getAgaentMibInfoList().size() == 1) {
                if (nextAgentMibInfo == null) {
                    agentMibInfo.setNextMibOid(null);
                } else {
                    agentMibInfo.setNextMibOid(nextAgentMibInfo.getOid());
                }
                oidDefineInfo.setNextMibOid(agentMibInfo.getOid());
            }
            if (oidDefineInfo.getAgaentMibInfoList().size() > 1) {
                MibInfo preAgentMibInfo = (MibInfo)oidDefineInfo.getAgaentMibInfoList().get(oidDefineInfo.getAgaentMibInfoList().size() - 2);
                if (nextAgentMibInfo == null) {
                    agentMibInfo.setNextMibOid(null);
                } else {
                    agentMibInfo.setNextMibOid(nextAgentMibInfo.getOid());
                }
                preAgentMibInfo.setNextMibOid(agentMibInfo.getOid());
                this.agentOidMap.put(preAgentMibInfo.getOid(), preAgentMibInfo);
            }
            this.agentOidMap.put(agentMibInfo.getOid(), agentMibInfo);
            ++agentCount;
        }
    }

    private void setSysupTime() {
        MibInfo miboid;
        AgentMibTree mibtable = AgentMibTree.getInstance();
        HashMap oidMap = mibtable.getOidHashMap();
        if (oidMap.containsKey(SYSUPTIME_OID) && (miboid = (MibInfo)oidMap.get(SYSUPTIME_OID)) != null) {
            AbstractSnmpObject sysupTimeObject = ((MibInfo)oidMap.get(SYSUPTIME_OID)).getAgentMibValue();
            long importSysupTime = Long.parseLong(sysupTimeObject.getValue().toString());
            long sysupTimeMills = System.currentTimeMillis() - importSysupTime * 10L;
            ThreadAgent.getInstance().setStartSnmpAgentEngineTime(sysupTimeMills);
        }
    }

    private String[] splitReadLine(String line, String delim) {
        String[] arrayLine = null;
        if (line != null) {
            arrayLine = line.split(delim);
        }
        return arrayLine;
    }

    private String[] checkDeviceIPAddress(String[] arrayLine) {
        if (arrayLine == null || arrayLine.length != 2) {
            return null;
        }
        if (this.deviceAddress.equals("")) {
            this.deviceAddress = this.getDeviceIPAddress(arrayLine[0]);
            if (!this.deviceAddress.equals("")) {
                String workValue;
                String workOid = this.updateOIDDeviceIPAddress(arrayLine[0], this.deviceAddress);
                if (!workOid.equals("")) {
                    arrayLine[0] = workOid;
                }
                if (!(workValue = this.updateValueDeviceIPAddress(arrayLine[1], this.deviceAddress)).equals("")) {
                    arrayLine[1] = workValue;
                }
            }
        } else {
            String workValue;
            String workOid = this.updateOIDDeviceIPAddress(arrayLine[0], this.deviceAddress);
            if (!workOid.equals("")) {
                arrayLine[0] = workOid;
            }
            if (!(workValue = this.updateValueDeviceIPAddress(arrayLine[1], this.deviceAddress)).equals("")) {
                arrayLine[1] = workValue;
            }
        }
        return arrayLine;
    }

    private String getDeviceIPAddress(String oid) {
        String deviceLocalIPAddress = "";
        int oidPositionWork = oid.indexOf(IPADENTADDR_OID_DESC);
        if (oidPositionWork >= 0) {
            deviceLocalIPAddress = oid.substring(IPADENTADDR_OID_DESC.length() + 1, oid.length());
            if (deviceLocalIPAddress.equals("0.0.0.0") || deviceLocalIPAddress.equals("127.0.0.1")) {
                return "";
            }
            logger.info("deviceIPAddress : " + deviceLocalIPAddress);
            if (!this.localIPAddr.equals("127.0.0.1")) {
                this.messageChangeIPAddress = "Replace Device IP Address : " + deviceLocalIPAddress + " --> " + this.localIPAddr;
            }
        }
        return deviceLocalIPAddress;
    }

    private String updateOIDDeviceIPAddress(String oid, String deviceAddress) {
        if (this.localIPAddr.equals("127.0.0.1")) {
            return "";
        }
        String deviceOIDIPAddress = "";
        int oidPositionWork = oid.indexOf(deviceAddress);
        if (oidPositionWork >= 0) {
            deviceOIDIPAddress = oid.replaceFirst(deviceAddress, this.localIPAddr);
        }
        return deviceOIDIPAddress;
    }

    private String updateValueDeviceIPAddress(String value, String deviceAddress) {
        if (this.localIPAddr.equals("127.0.0.1")) {
            return "";
        }
        String deviceValueIPAddress = "";
        int oidPositionWork = value.indexOf(deviceAddress);
        if (oidPositionWork >= 0) {
            deviceValueIPAddress = value.replaceFirst(deviceAddress, this.localIPAddr);
        }
        return deviceValueIPAddress;
    }
}

