/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager;

import java.net.InetAddress;
import java.net.UnknownHostException;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.snmpmanager.process.SnmpCommandOperation;
import netjfwatcher.engine.snmpmanager.process.SnmpOperationDataHolder;
import netjfwatcher.snmpmanager.SnmpV1ValueTypeSelection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

abstract class AbstractSnmpOperationView
extends ViewPart {
    protected static final String GETNEXTREQUEST_BUTTON = "GetNext";
    protected static final String GETREQUEST_BUTTON = "Get";
    protected static final String READ_COMMUNITY = "public";
    protected static final String READ_WRITE_COMMUNITY = "private";
    protected static final int TEXT_WIDTH = 200;
    protected static final int SET_VALUE_TEXT_WIDTH = 250;
    protected static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 200};
    protected Text targetIPText;
    protected Text oidText;
    protected Text accessTypeText;
    protected Text setValueText;
    protected Combo snmpValueTypeCombo;
    protected Text roCommunityText;
    protected Text rwCommunityText;
    protected Button getNextButton;
    protected Button getRequestButton;
    protected Button snmpSetButton;
    protected SnmpOperationDataHolder dataHolder;
    protected Color textBackColor;

    AbstractSnmpOperationView() {
    }

    public abstract void createPartControl(Composite var1);

    public void getRequestButtonListener() {
        if (!this.checkIPAddress()) {
            return;
        }
        this.getRequestButton.setEnabled(false);
        this.getNextButton.setEnabled(false);
        this.snmpSetButton.setEnabled(false);
        this.dataHolder.setViewSite(this.getViewSite());
        this.dataHolder.setTargetIP(this.targetIPText.getText());
        this.dataHolder.setRoCommunity(this.roCommunityText.getText());
        this.dataHolder.setTargetOid(this.oidText.getText());
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SnmpCommandOperation.getInstance().getRequest(AbstractSnmpOperationView.this.dataHolder);
            }
        });
        this.getRequestButton.setEnabled(true);
        this.getNextButton.setEnabled(true);
        this.snmpSetButton.setEnabled(true);
    }

    public void getNextRequestButtonListener() {
        if (!this.checkIPAddress()) {
            return;
        }
        this.getRequestButton.setEnabled(false);
        this.getNextButton.setEnabled(false);
        this.snmpSetButton.setEnabled(false);
        this.dataHolder.setViewSite(this.getViewSite());
        this.dataHolder.setTargetIP(this.targetIPText.getText());
        this.dataHolder.setRoCommunity(this.roCommunityText.getText());
        this.dataHolder.setTargetOid(this.oidText.getText());
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SnmpCommandOperation.getInstance().getNextRequest(AbstractSnmpOperationView.this.dataHolder);
            }
        });
        this.getRequestButton.setEnabled(true);
        this.getNextButton.setEnabled(true);
        this.snmpSetButton.setEnabled(true);
    }

    public void setRequestButtonListener() {
        if (!this.checkIPAddress()) {
            return;
        }
        this.snmpSetButton.setEnabled(false);
        this.getNextButton.setEnabled(false);
        this.dataHolder.setViewSite(this.getViewSite());
        this.dataHolder.setTargetIP(this.targetIPText.getText());
        this.dataHolder.setRwCommunity(this.rwCommunityText.getText());
        this.dataHolder.setTargetOid(this.oidText.getText());
        this.dataHolder.setSetValue(this.setValueText.getText());
        this.dataHolder.setSetType(SnmpV1ValueTypeSelection.getInstance().getSnmpValueType());
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SnmpCommandOperation.getInstance().setRequest(AbstractSnmpOperationView.this.dataHolder);
            }
        });
        this.snmpSetButton.setEnabled(true);
        this.getNextButton.setEnabled(true);
    }

    private boolean checkIPAddress() {
        boolean isOKAddress = false;
        int snmpVersion = this.dataHolder.getSnmpVersion();
        String targetIPAddress = this.targetIPText.getText();
        if (targetIPAddress.equals("")) {
            if (snmpVersion == 3) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Select Agent Address");
                shell.dispose();
                this.targetIPText.setFocus();
                return isOKAddress;
            }
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Input Agent Address");
            shell.dispose();
            this.targetIPText.setFocus();
            return isOKAddress;
        }
        String ipAddress = "";
        try {
            InetAddress host = InetAddress.getByName(targetIPAddress);
            ipAddress = host.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("UnknownHostException IP Address = " + this.targetIPText.getText()));
            shell.dispose();
            this.targetIPText.setFocus();
            return isOKAddress;
        }
        if (snmpVersion == 3 && SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(ipAddress) == null) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Not found SNMP V3 Agent Address = " + ipAddress));
            shell.dispose();
            return isOKAddress;
        }
        isOKAddress = true;
        return isOKAddress;
    }

    public void setFocus() {
    }

    public void setInitText() {
        this.oidText.setText("1.3.6.1.2.1.1.1");
        this.snmpValueTypeCombo.setText("OCTETSTRING");
        this.accessTypeText.setText("read-only");
    }

    protected abstract void setStatusLine();

    public Text getOidText() {
        return this.oidText;
    }

    public Combo getSnmpValueTypeCombo() {
        return this.snmpValueTypeCombo;
    }

    public Text getAccessTypeText() {
        return this.accessTypeText;
    }

    public Text getSetValueText() {
        return this.setValueText;
    }
}

