/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.snmpmanager.process.SnmpOperationDataHolder;
import netjfwatcher.snmpmanager.AbstractSnmpOperationView;
import netjfwatcher.snmpmanager.SnmpV3ValueTypeSelection;
import netjfwatcher.snmptest.SnmpErrorTest;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class SnmpV3OperationView
extends AbstractSnmpOperationView {
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{1000, 500};
    private static final int DISCOVERY_TEXT_WIDTH = 100;
    private static final int COMBO_WIDTH = 120;
    private static final int ERROR_TEST_COMBO_WIDTH = 180;
    private static final int AGENT_LIST_VERTICAL_SPAN = 7;
    private static final int AGENT_LIST_WIDTH_HINT = 200;
    private static final int AGENT_LIST_HEIGHTHINT = 5;
    private static Logger logger;
    private final DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SubStatusLineManager statusLineManager;
    private ArrayList snmpV3InfoList;
    private List snmpV3AgentList = null;
    private Text selectV3AgentAddressText;
    private Text engineIDText;
    private Text engineBootText;
    private Text engineSysUpTimeText;
    private Text userNameText;
    private Combo authPrivCombo;
    private Combo authProtocolCombo;
    private Text authPassPhrasaText;
    private Text privProtocolText;
    private Text privPassPhrasaText;
    private Text agentLearnedText;
    private Button discoveryResetButton;
    private Combo snmpErrorTestCombo;

    public void createPartControl(Composite parent) {
        this.setStatusLine();
        this.textBackColor = Display.getCurrent().getSystemColor(1);
        this.dataHolder = new SnmpOperationDataHolder();
        this.dataHolder.setSnmpVersion(3);
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout0 = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout0);
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite baseComposite = new Composite((Composite)scrollComposite, 0);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData());
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(6, false);
        Composite composite = new Composite(baseComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("Agent Address");
        label.setLayoutData((Object)new GridData());
        this.targetIPText = new Text(composite, 2048);
        this.targetIPText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.targetIPText.setLayoutData((Object)gridData);
        Label label2 = new Label(composite, 0);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Request OID");
        label.setLayoutData((Object)new GridData());
        this.oidText = new Text(composite, 2048);
        this.oidText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.oidText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Set Value");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.setValueText = new Text(composite, 2048);
        this.setValueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.setValueText.setLayoutData((Object)gridData);
        label2 = new Label(composite, 0);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Access Type");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.accessTypeText = new Text(composite, 2056);
        this.accessTypeText.setEnabled(false);
        this.accessTypeText.setBackground(this.textBackColor);
        this.setValueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.accessTypeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Value Type");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.snmpValueTypeCombo = new Combo(composite, 12);
        this.snmpValueTypeCombo.add("INTEGER");
        this.snmpValueTypeCombo.add("COUNTER32");
        this.snmpValueTypeCombo.add("COUNTER64");
        this.snmpValueTypeCombo.add("GAUGE32");
        this.snmpValueTypeCombo.add("OCTETSTRING");
        this.snmpValueTypeCombo.add("IPADDRESS");
        this.snmpValueTypeCombo.add("NSAPADDRESS");
        this.snmpValueTypeCombo.add("OBJECTIDENTIFIER");
        this.snmpValueTypeCombo.add("TIMETICKS");
        this.snmpValueTypeCombo.add("INTEGER32");
        this.snmpValueTypeCombo.add("BITSTRING");
        this.snmpValueTypeCombo.add("OPAQUE");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpValueTypeCombo.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Error test");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.snmpErrorTestCombo = new Combo(composite, 12);
        this.snmpErrorTestCombo.add("Normal");
        this.snmpErrorTestCombo.add("Unsupported security level");
        this.snmpErrorTestCombo.add("Not in time packet");
        this.snmpErrorTestCombo.add("Unknown user name");
        this.snmpErrorTestCombo.add("Unknown engine ID");
        this.snmpErrorTestCombo.add("Wrong digest");
        this.snmpErrorTestCombo.add("Descryption error");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 180;
        this.snmpErrorTestCombo.setLayoutData((Object)gridData);
        this.snmpErrorTestCombo.select(0);
        GridLayout gridLayout2 = new GridLayout(6, false);
        Composite compositeBottonAndCommunity = new Composite(baseComposite, 0);
        compositeBottonAndCommunity.setLayoutData((Object)new GridData(256));
        compositeBottonAndCommunity.setLayout((Layout)gridLayout2);
        label = new Label(compositeBottonAndCommunity, 0);
        label.setText("Read Community");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.roCommunityText = new Text(compositeBottonAndCommunity, 2048);
        this.roCommunityText.setText("public");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.roCommunityText.setLayoutData((Object)gridData);
        this.getNextButton = new Button(compositeBottonAndCommunity, 0);
        this.getNextButton.setText("GetNext");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.getNextButton.setLayoutData((Object)gridData);
        label = new Label(compositeBottonAndCommunity, 0);
        label.setText("Write Community");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.rwCommunityText = new Text(compositeBottonAndCommunity, 2048);
        this.rwCommunityText.setText("private");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.rwCommunityText.setLayoutData((Object)gridData);
        this.snmpSetButton = new Button(compositeBottonAndCommunity, 0);
        this.snmpSetButton.setText("Set");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.snmpSetButton.setLayoutData((Object)gridData);
        label = new Label(compositeBottonAndCommunity, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.getRequestButton = new Button(compositeBottonAndCommunity, 0);
        this.getRequestButton.setText("Get");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.getRequestButton.setLayoutData((Object)gridData);
        this.createSnmpV3AgnetInfoComposite(baseComposite);
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setInitText();
        this.snmpV3AgentList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SnmpV3OperationView.this.snmpV3AgentList.getSelectionIndex();
                SnmpV3OperationView.this.selectAgent(index);
            }
        });
        this.getRequestButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SnmpV3OperationView.this.getRequestButtonListener();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.getNextButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SnmpErrorTest.getInstance().setManagerErrorControlCode(SnmpV3OperationView.this.snmpErrorTestCombo.getText());
                SnmpV3OperationView.this.dataHolder.setEngineIDText(SnmpV3OperationView.this.engineIDText);
                SnmpV3OperationView.this.dataHolder.setEngineBootText(SnmpV3OperationView.this.engineBootText);
                SnmpV3OperationView.this.dataHolder.setEngineSysUpTimeText(SnmpV3OperationView.this.engineSysUpTimeText);
                SnmpV3OperationView.this.dataHolder.setAgentLearnedText(SnmpV3OperationView.this.agentLearnedText);
                SnmpV3OperationView.this.getNextRequestButtonListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.snmpValueTypeCombo.addSelectionListener((SelectionListener)SnmpV3ValueTypeSelection.getInstance());
        this.snmpSetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SnmpV3OperationView.this.setRequestButtonListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.discoveryResetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SnmpV3OperationView.this.resetAgentDiscovery();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createSnmpV3AgnetInfoComposite(Composite baseComposite) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        Composite compositeSnmpV3AgentProperty = new Composite(baseComposite, 0);
        GridLayout gridLayoutV3AgentProp = new GridLayout(1, false);
        compositeSnmpV3AgentProperty.setLayout((Layout)gridLayoutV3AgentProp);
        compositeSnmpV3AgentProperty.setLayoutData((Object)new GridData(256));
        Group snmpV3AgentInfoGroup = new Group(compositeSnmpV3AgentProperty, 0);
        snmpV3AgentInfoGroup.setText("SNMP V3 Agent Information");
        snmpV3AgentInfoGroup.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        snmpV3AgentInfoGroup.setLayoutData((Object)gridData);
        this.snmpV3AgentList = new List((Composite)snmpV3AgentInfoGroup, 2052);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 7;
        data.widthHint = 200;
        data.heightHint = this.snmpV3AgentList.getItemHeight() * 5;
        this.snmpV3AgentList.setLayoutData((Object)data);
        this.snmpV3InfoList = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getResourceSnmpV3ConfigList();
        String[] snmpV3TargetAddress = new String[this.snmpV3InfoList.size()];
        int i = 0;
        while (i < this.snmpV3InfoList.size()) {
            SnmpV3ManagerConfigInfo info = (SnmpV3ManagerConfigInfo)this.snmpV3InfoList.get(i);
            System.out.println("Address : " + info.getIpAddress());
            snmpV3TargetAddress[i] = info.getIpAddress();
            this.snmpV3AgentList.add(info.getIpAddress());
            ++i;
        }
        this.snmpV3AgentList.select(0);
        this.snmpV3AgentList.setLayoutData((Object)data);
        Label label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("Select Agent Address");
        label2.setLayoutData((Object)new GridData());
        this.selectV3AgentAddressText = new Text((Composite)snmpV3AgentInfoGroup, 2048);
        this.selectV3AgentAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.selectV3AgentAddressText.setLayoutData((Object)gridData);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("User Name");
        label2.setLayoutData((Object)new GridData());
        this.userNameText = new Text((Composite)snmpV3AgentInfoGroup, 2048);
        this.userNameText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.userNameText.setLayoutData((Object)gridData);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("EngineID");
        label2.setLayoutData((Object)new GridData());
        this.engineIDText = new Text((Composite)snmpV3AgentInfoGroup, 2048);
        this.engineIDText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineIDText.setLayoutData((Object)gridData);
        this.engineIDText.setEditable(false);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("AuthPriv");
        label2.setLayoutData((Object)new GridData());
        this.authPrivCombo = new Combo((Composite)snmpV3AgentInfoGroup, 12);
        this.authPrivCombo.add("NOAUTH");
        this.authPrivCombo.add("AUTH");
        this.authPrivCombo.add("PRIV");
        this.authPrivCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.authPrivCombo.setLayoutData((Object)gridData);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("EngineBoots");
        label2.setLayoutData((Object)new GridData());
        this.engineBootText = new Text((Composite)snmpV3AgentInfoGroup, 2048);
        this.engineBootText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineBootText.setLayoutData((Object)gridData);
        this.engineBootText.setEditable(false);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("AuthProtocol");
        label2.setLayoutData((Object)new GridData());
        this.authProtocolCombo = new Combo((Composite)snmpV3AgentInfoGroup, 12);
        this.authProtocolCombo.add("MD5");
        this.authProtocolCombo.add("SHA");
        this.authProtocolCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.authProtocolCombo.setLayoutData((Object)gridData);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("EngineSysUpTime");
        label2.setLayoutData((Object)new GridData());
        this.engineSysUpTimeText = new Text((Composite)snmpV3AgentInfoGroup, 2048);
        this.engineSysUpTimeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.engineSysUpTimeText.setLayoutData((Object)gridData);
        this.engineSysUpTimeText.setEditable(false);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("AuthPassPhrase");
        label2.setLayoutData((Object)new GridData());
        this.authPassPhrasaText = new Text((Composite)snmpV3AgentInfoGroup, 2048);
        this.authPassPhrasaText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.authPassPhrasaText.setLayoutData((Object)gridData);
        this.agentLearnedText = new Text((Composite)snmpV3AgentInfoGroup, 2056);
        this.agentLearnedText.setText("Undiscovery");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.agentLearnedText.setLayoutData((Object)gridData);
        this.agentLearnedText.setEnabled(false);
        this.agentLearnedText.setBackground(this.textBackColor);
        this.discoveryResetButton = new Button((Composite)snmpV3AgentInfoGroup, 0);
        this.discoveryResetButton.setText("Discovery Reset");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.discoveryResetButton.setLayoutData((Object)gridData);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("PrivProtocol");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        this.privProtocolText = new Text((Composite)snmpV3AgentInfoGroup, 2048);
        this.privProtocolText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.privProtocolText.setLayoutData((Object)gridData);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        label2 = new Label((Composite)snmpV3AgentInfoGroup, 0);
        label2.setText("PrivPassPhrase");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label2.setLayoutData((Object)gridData);
        this.privPassPhrasaText = new Text((Composite)snmpV3AgentInfoGroup, 2048);
        this.privPassPhrasaText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.privPassPhrasaText.setLayoutData((Object)gridData);
    }

    private void selectAgent(int index) {
        SnmpV3ManagerConfigInfo info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(this.snmpV3AgentList.getItem(index));
        if (info != null) {
            this.selectV3AgentAddressText.setText(info.getIpAddress());
            this.targetIPText.setText(info.getIpAddress());
            if (info.getSnmpEngineID() != null && !info.getSnmpEngineID().equals("")) {
                this.engineIDText.setText("0x" + info.getSnmpEngineID());
            } else {
                this.engineIDText.setText("");
            }
            if (info.getSnmpEngineBoots() != null) {
                this.engineBootText.setText(info.getSnmpEngineBoots());
            } else {
                this.engineBootText.setText("");
            }
            if (info.isLearned()) {
                this.agentLearnedText.setText("Dicovery");
            } else {
                this.agentLearnedText.setText("Undiscovery");
            }
            long agentSnmpEngineTime = 0L;
            if (info.getSnmpEngineTime() != null) {
                try {
                    agentSnmpEngineTime = Long.parseLong(info.getSnmpEngineTime());
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warning("NumberFormatException Agent snmp EngineTime " + info.getSnmpEngineTime());
                }
            }
            if (agentSnmpEngineTime != 0L) {
                Date agentDate = Calendar.getInstance().getTime();
                agentDate.setTime(agentSnmpEngineTime);
                this.engineSysUpTimeText.setText(this.dateformat.format(agentDate));
            } else {
                this.engineSysUpTimeText.setText("");
            }
            SnmpV3ManagerUserConfigInfo userInfo = (SnmpV3ManagerUserConfigInfo)info.getUserList().get(0);
            if (userInfo != null) {
                this.userNameText.setText(userInfo.getUsername());
                this.authPrivCombo.setText(userInfo.getAuthPriv());
                this.authProtocolCombo.setText(userInfo.getAuthProtocol());
                this.authPassPhrasaText.setText(userInfo.getAuthPassPhrase());
                this.privProtocolText.setText(userInfo.getPrivProtocol());
                this.privPassPhrasaText.setText(userInfo.getPrivPassPhrase());
            }
        }
    }

    private void resetAgentDiscovery() {
        int index = this.snmpV3AgentList.getSelectionIndex();
        String selectAgentAddress = this.snmpV3AgentList.getItem(index);
        SnmpV3ManagerConfigInfo info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(this.snmpV3AgentList.getItem(index));
        if (selectAgentAddress.equals("")) {
            return;
        }
        this.engineIDText.setText("");
        this.engineBootText.setText("");
        this.engineSysUpTimeText.setText("");
        this.agentLearnedText.setText("Undiscovery");
        info.setLearned(false);
        info.setSnmpEngineID("");
        info.setSnmpEngineBoots("");
        info.setSnmpEngineTime("");
        SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(selectAgentAddress, info);
        HashMap snmpV3ManagerMap = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3ConfigAddresssMapList();
        snmpV3ManagerMap.put(selectAgentAddress, info);
        logger.info("Discovery reset Agent=" + selectAgentAddress);
    }

    public void updateSnmpV3AgentList() {
        this.snmpV3AgentList.removeAll();
        this.snmpV3InfoList = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getResourceSnmpV3ConfigList();
        String[] snmpV3TargetAddress = new String[this.snmpV3InfoList.size()];
        int i = 0;
        while (i < this.snmpV3InfoList.size()) {
            SnmpV3ManagerConfigInfo info = (SnmpV3ManagerConfigInfo)this.snmpV3InfoList.get(i);
            System.out.println("Address : " + info.getIpAddress());
            snmpV3TargetAddress[i] = info.getIpAddress();
            this.snmpV3AgentList.add(info.getIpAddress());
            ++i;
        }
        this.snmpV3AgentList.select(0);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        int snmpPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpPort();
        String snmpV3Timeout = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV3Timeout();
        String snmpV3Retry = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV3Retry();
        this.statusLineManager.setMessage("Snmp Port=" + snmpPort + " timeout=" + snmpV3Timeout + " retry=" + snmpV3Retry);
    }
}

