/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.model;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmpmanager.trap.ThreadTrapReceive;
import netjfwatcher.snmpmanager.trap.TrapListenerImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;

public class ActionBuilderTrapReceiveTable {
    public static final int TIMER_STOP = -1;
    private static Logger logger;
    private Display display;
    private final Table trapTable;
    private final SubStatusLineManager statusLineManager;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private final IAction startTrap = new ActionStartTrapReceiveThread();
    private final IAction stopTrap = new ActionStopTrapReceiveThread();
    private final IAction restartTrap = new ActionRestartTrapReceiveThread();
    private final IAction resetTrapTable = new ActionRemoveNode();

    public ActionBuilderTrapReceiveTable(Display display, Table table, SubStatusLineManager statusLineManager) {
        logger = Logger.getLogger(this.getClass().getName());
        this.display = display;
        this.trapTable = table;
        this.statusLineManager = statusLineManager;
    }

    public IAction getActionStartTrap() {
        return this.startTrap;
    }

    public IAction getActionStopTrap() {
        return this.stopTrap;
    }

    public IAction getActionRestartTrap() {
        return this.restartTrap;
    }

    public IAction getActionResetTrapTable() {
        return this.resetTrapTable;
    }

    private abstract class AbstractTrapAction
    extends Action {
        private AbstractTrapAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    private final class ActionStartTrapReceiveThread
    extends AbstractTrapAction {
        private ActionStartTrapReceiveThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderTrapReceiveTable.this.bundle.getEntry("icons/trap.gif"));
        }

        public String getText() {
            return "Trap\u53d7\u4fe1\u958b\u59cb";
        }

        public String getToolTipText() {
            return "Trap\u53d7\u4fe1\u3092\u958b\u59cb\u3057\u307e\u3059";
        }

        protected void doTask() {
            TrapListenerImpl listener = TrapListenerImpl.getInstance();
            ThreadTrapReceive trapthread = ThreadTrapReceive.getInstance();
            Shell shell = ActionBuilderTrapReceiveTable.this.display.getActiveShell();
            MessageBox alertMessageBox = new MessageBox(shell, 72);
            if (trapthread.checkThread()) {
                alertMessageBox.setMessage("Already Trap thraed alive");
                alertMessageBox.open();
                ActionBuilderTrapReceiveTable.this.statusLineManager.setMessage("Trap receive status is active");
                return;
            }
            if (!trapthread.startReceiving()) {
                logger.warning("Abort Trap start");
                alertMessageBox.setMessage("Abort Trap start");
                alertMessageBox.open();
                return;
            }
            trapthread.addTrapListener(listener);
            ActionBuilderTrapReceiveTable.this.statusLineManager.setMessage("Trap receive status is active");
        }
    }

    private final class ActionStopTrapReceiveThread
    extends AbstractTrapAction {
        private ActionStopTrapReceiveThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderTrapReceiveTable.this.bundle.getEntry("icons/trapstop.gif"));
        }

        public String getText() {
            return "Trap\u53d7\u4fe1\u505c\u6b62";
        }

        public String getToolTipText() {
            return "Trap\u53d7\u4fe1\u3092\u505c\u6b62\u3057\u307e\u3059";
        }

        protected void doTask() {
            ThreadTrapReceive trapthread = ThreadTrapReceive.getInstance();
            trapthread.stopReceiving();
            ActionBuilderTrapReceiveTable.this.statusLineManager.setMessage("Trap receive status is stop");
        }
    }

    private final class ActionRestartTrapReceiveThread
    extends AbstractTrapAction {
        private ActionRestartTrapReceiveThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderTrapReceiveTable.this.bundle.getEntry("icons/traprestart.gif"));
        }

        public String getText() {
            return "Trap\u53d7\u4fe1\u518d\u8d77\u52d5";
        }

        public String getToolTipText() {
            return "Trap\u53d7\u4fe1\u3092\u518d\u8d77\u52d5\u3057\u307e\u3059";
        }

        protected void doTask() {
            ActionBuilderTrapReceiveTable.this.statusLineManager.setMessage("Trap receive status is stop");
            TrapListenerImpl listener = TrapListenerImpl.getInstance();
            ThreadTrapReceive trapthread = ThreadTrapReceive.getInstance();
            Shell shell = ActionBuilderTrapReceiveTable.this.display.getActiveShell();
            MessageBox alertMessageBox = new MessageBox(shell, 72);
            if (!trapthread.checkThread()) {
                alertMessageBox.setMessage("Not Trap thraed alive");
                alertMessageBox.open();
                ActionBuilderTrapReceiveTable.this.statusLineManager.setMessage("Trap receive status is active");
                return;
            }
            trapthread.stopReceiving();
            if (!trapthread.startReceiving()) {
                logger.warning("Abort Trap start");
                alertMessageBox.setMessage("Abort Trap start");
                alertMessageBox.open();
                return;
            }
            trapthread.addTrapListener(listener);
            ActionBuilderTrapReceiveTable.this.statusLineManager.setMessage("Trap receive status is active");
        }
    }

    private final class ActionRemoveNode
    extends AbstractTrapAction {
        private ActionRemoveNode() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderTrapReceiveTable.this.bundle.getEntry("icons/clear.gif"));
        }

        public String getText() {
            return "Clear Trap Table";
        }

        public String getToolTipText() {
            return "Trap\u53d7\u4fe1\u30c6\u30fc\u30d6\u30eb\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059";
        }

        protected void doTask() {
            ActionBuilderTrapReceiveTable.this.trapTable.removeAll();
            TableViewer view = NetJFWatcherApplication.getTrapTableView().getViewer();
            view.refresh();
        }
    }
}

