/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmpmanager.trap.AbstractTrapMessageProcessing;
import netjfwatcher.snmpmanager.trap.ITrapListener;

public class TrapV2ReceiveMP
extends AbstractTrapMessageProcessing {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public final void process(String agentAddress, byte[] encodedMessage, List listenerList) throws SnmpBadValueException {
        SnmpSequence receiveSnmpSequence = new SnmpSequence();
        SNMPTLV nextTLV3 = receiveSnmpSequence.extractNextTLV(encodedMessage, 0);
        try {
            receiveSnmpSequence.setTLV(nextTLV3);
        }
        catch (SnmpBadValueException e) {
            this.logger.warning("Trap V2 parse error : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        AbstractSnmpObject msgVersion2 = receiveSnmpSequence.getSNMPObjectAt(0);
        if (!(msgVersion2 instanceof SnmpInteger)) {
            this.logger.warning("SNMP V2 Trap Version is not INTEGER");
            throw new SnmpBadValueException("Version is not INTEGER : " + msgVersion2.toString());
        }
        SnmpTrap2PDU trap2PDU = this.parseSNMPTrap2PDU(receiveSnmpSequence.getSNMPObjectAt(2));
        int i = 0;
        while (i < listenerList.size()) {
            ITrapListener listener = (ITrapListener)listenerList.get(i);
            listener.processTrapV2(trap2PDU, "SNMPV2C", agentAddress);
            ++i;
        }
    }
}

