/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.socketclient;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.resourceconfig.EngineResourceConfig;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;
import netjfwatcher.socketclient.ActionBuilderXMLSocket;
import netjfwatcher.socketclient.ActionEngineTreeRefresh;
import netjfwatcher.socketclient.EngineInfo;
import netjfwatcher.socketclient.EngineListListener;
import netjfwatcher.socketclient.EngineTree;
import netjfwatcher.socketclient.EngineTreeGroup;
import netjfwatcher.socketclient.EngineTreeViewContentProvider;
import netjfwatcher.socketclient.IEngineNode;
import netjfwatcher.socketclient.XMLSocketConnectThread;
import netjfwatcher.socketclient.XMLSocketConnectTimerProcessor;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewSorter;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

public class EngineListView
extends ViewPart {
    private TreeViewer viewer;
    private EngineTreeGroup engineTreeGroupRootOfRoot;
    private Map engineConnectStateMap;
    private Bundle bundle;
    private Display display;
    private static final String engineIconFileName = "icons/engine.gif";
    private static final String engineStopIconFileName = "icons/engine_stop.gif";
    private Image engineIocnImage;
    private Image engineStopIocnImage;
    private static ActionBuilderEditorsPartClose actionBuilder = new ActionBuilderEditorsPartClose();
    private static ActionBuilderXMLSocket xmlSocketAction = new ActionBuilderXMLSocket();
    private ActionEngineTreeRefresh refreshAction = new ActionEngineTreeRefresh();
    private static Logger logger = null;

    public EngineListView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.bundle = NetJFWatcherPlugin.getInstance().getBundle();
        this.createImage();
        this.viewer = new TreeViewer(parent);
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter((ViewerSorter)new NetMenuTreeViewSorter());
        this.viewer.setContentProvider((IContentProvider)new EngineTreeViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EngineListLabelProvider());
        this.viewer.setInput(this.createInitialInput());
        this.setTreeViewer();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new EngineListListener(this.viewer));
        this.refreshAction.setEngineListTreeViewer(this);
        XMLSocketConnectTimerProcessor.getInstance().setEngineListTreeViewer(this.getSite(), this.viewer);
        this.createContextMenu();
        this.initActions();
    }

    private void createImage() {
        try {
            URL url = null;
            url = this.bundle.getEntry(engineIconFileName);
            if (url == null) {
                logger.severe("Not found icon file : icons/engine_stop.gif");
            } else {
                this.engineIocnImage = new Image((Device)this.display, url.openStream());
            }
            url = this.bundle.getEntry(engineStopIconFileName);
            if (url == null) {
                logger.severe("Npt found icon file : icons/engine_stop.gif");
            } else {
                this.engineStopIocnImage = new Image((Device)this.display, url.openStream());
            }
        }
        catch (IOException e) {
            logger.warning("Abort create image " + e.getMessage() + " for " + engineStopIconFileName);
            e.printStackTrace();
        }
    }

    public void setTreeViewer() {
        this.engineConnectStateMap = XMLSocketConnectThread.getInstance().getEngineConnectStateMap();
        this.engineTreeGroupRootOfRoot.removeChildAll();
        this.createEngineList();
        this.viewer.expandAll();
        this.viewer.refresh();
    }

    private void createEngineList() {
        IEngineNode engineNode = (IEngineNode)this.viewer.getInput();
        EngineTreeGroup baseMenuGroup = engineNode.getParent();
        if (engineNode instanceof EngineTreeGroup) {
            baseMenuGroup = (EngineTreeGroup)engineNode;
        }
        ArrayList engineList = EngineResourceConfig.getInstance().getEngineInfo().getEngineInfoList();
        String engineAddress = "";
        String enginePortString = "";
        int i = 0;
        while (i < engineList.size()) {
            engineAddress = ((EngineResourceInfo)engineList.get(i)).getEngineIPaddress();
            enginePortString = ((EngineResourceInfo)engineList.get(i)).getEnginePort();
            EngineInfo engineInfo = new EngineInfo();
            engineInfo.setEngineAddress(engineAddress);
            engineInfo.setEnginePort(enginePortString);
            EngineTree engineTreeNode = new EngineTree(engineInfo);
            baseMenuGroup.addChild(engineTreeNode);
            ++i;
        }
    }

    public void setFocus() {
    }

    private Object createInitialInput() {
        this.engineTreeGroupRootOfRoot = new RootOfRootEngineTreeGroup();
        return this.engineTreeGroupRootOfRoot;
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EngineListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionBuilder().actionCloseAllEditors());
        manager.add(xmlSocketAction.getActionXMLSocketView());
    }

    private void initActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add(xmlSocketAction.getActionXMLSocketView());
        toolBarManager.add(this.getActionBuilder().actionCloseAllEditors());
    }

    public ActionBuilderEditorsPartClose getActionBuilder() {
        return actionBuilder;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.engineIocnImage != null && this.engineIocnImage.isDisposed()) {
            this.engineIocnImage.dispose();
        }
        if (this.engineStopIocnImage != null && this.engineStopIocnImage.isDisposed()) {
            this.engineStopIocnImage.dispose();
        }
    }

    class EngineListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public Image getImage(Object element) {
            EngineInfo engineInfo = ((IEngineNode)element).getEngineInfo();
            String state = (String)EngineListView.this.engineConnectStateMap.get(engineInfo.getEngineAddress());
            if (state == null || state.equals(" Unconnect")) {
                return EngineListView.this.engineStopIocnImage;
            }
            return EngineListView.this.engineIocnImage;
        }

        public String getText(Object element) {
            IEngineNode node = (IEngineNode)element;
            EngineInfo engineInfo = node.getEngineInfo();
            return engineInfo.getEngineAddress();
        }

        public Color getForeground(Object element) {
            IEngineNode node = (IEngineNode)element;
            EngineInfo engineInfo = node.getEngineInfo();
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            if (engineInfo.getEngineAddress().equals(engineAddress)) {
                return Display.getCurrent().getSystemColor(1);
            }
            return Display.getCurrent().getSystemColor(2);
        }

        public Color getBackground(Object element) {
            IEngineNode node = (IEngineNode)element;
            EngineInfo engineInfo = node.getEngineInfo();
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            if (engineInfo.getEngineAddress().equals(engineAddress)) {
                return Display.getCurrent().getSystemColor(10);
            }
            return Display.getCurrent().getSystemColor(1);
        }

        public void dispose() {
        }
    }

    private static final class RootOfRootEngineTreeGroup
    extends EngineTreeGroup {
        RootOfRootEngineTreeGroup() {
        }

        public EngineTreeGroup getParent() {
            return null;
        }

        public void removeChild(Node toRemove) {
        }
    }
}

