/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.preferences;

import java.io.IOException;
import java.util.logging.Logger;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.widgets.Shell;

public final class HttpAccessPreference {
    private static final String HTTP_URL_XML_NODE_INFO_LIST = "nodewatch/export/NodeRegisterInfoExportAction";
    private static final String NODE_MAP = "nodemapframe.do?engineAddress=all";
    private static final String AUTH_NODE_LIST = "manager/authNodemanagerFrame.do?engineAddress=all";
    private static final String NODE_LIST = "nodemanagerFrame.do?engineAddress=all";
    private static final String MAINTENANCE = "maintenance/maintestart.do?engineAddress=all";
    private static final String AUTH_NODE_VIEW = "manager/authNodeviewframe.do";
    private static final String NODE_VIEW = "nodeviewframe.do";
    private static Logger logger = null;
    private static PreferenceStore webAccessPref;

    private HttpAccessPreference() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public String getUrl() throws HttpAccessPreferenceException {
        webAccessPref = new PreferenceStore("resources/webAccess.pref");
        try {
            webAccessPref.load();
        }
        catch (IOException e1) {
            logger.warning("HTTP access preference load error : " + e1.getMessage());
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"HTTP access preference load error", (String)"HTTP access Preference load error.");
            shell.dispose();
            throw new HttpAccessPreferenceException("HTTP access preference load error");
        }
        return webAccessPref.getString("HTTP_URL");
    }

    public String getNodeListImportUrl() throws HttpAccessPreferenceException {
        String nodeListImportUrl = String.valueOf(this.getUrl()) + HTTP_URL_XML_NODE_INFO_LIST;
        return nodeListImportUrl;
    }

    public String getNodeMapUrl() throws HttpAccessPreferenceException {
        String menuUrl = String.valueOf(this.getUrl()) + NODE_MAP;
        return menuUrl;
    }

    public String getMaintenanceUrl() throws HttpAccessPreferenceException {
        String menuUrl = String.valueOf(this.getUrl()) + MAINTENANCE;
        return menuUrl;
    }

    public String getAuthNodeManagerUrl() throws HttpAccessPreferenceException {
        String menuUrl = String.valueOf(this.getUrl()) + AUTH_NODE_LIST;
        return menuUrl;
    }

    public String getNodeManagerUrl() throws HttpAccessPreferenceException {
        String menuUrl = String.valueOf(this.getUrl()) + NODE_LIST;
        return menuUrl;
    }

    public String getAuthNodeViewUrl() throws HttpAccessPreferenceException {
        String nodeViewUrl = String.valueOf(this.getUrl()) + AUTH_NODE_VIEW;
        return nodeViewUrl;
    }

    public String getNodeViewUrl() throws HttpAccessPreferenceException {
        String nodeViewUrl = String.valueOf(this.getUrl()) + NODE_VIEW;
        return nodeViewUrl;
    }

    public static HttpAccessPreference getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ HttpAccessPreference(HttpAccessPreference httpAccessPreference) {
        this();
    }

    private static class SingletonResource {
        static final HttpAccessPreference RESOURCE = new HttpAccessPreference(null);

        private SingletonResource() {
        }
    }
}

