/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class BusyIndicator
extends Canvas {
    private static final int MARGIN = 2;
    private ImageData[] progressData;
    protected ImageLoader loader;
    protected Image image;
    protected Image animationImage;
    protected Thread busyThread;
    protected boolean stop;
    static /* synthetic */ Class class$0;

    public BusyIndicator(Composite parent, int style) {
        super(parent, style);
        this.loadProgressImage();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BusyIndicator.this.onPaint(event);
            }
        });
    }

    private void loadProgressImage() {
        InputStream is;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.forms.widgets.BusyIndicator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((is = clazz.getResourceAsStream("progress.gif")) != null) {
            this.loader = new ImageLoader();
            try {
                this.progressData = this.loader.load(is);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = new Point(0, 0);
        if (this.image != null) {
            Rectangle ibounds = this.image.getBounds();
            size.x = ibounds.width;
            size.y = ibounds.height;
        }
        if (this.loader != null) {
            size.x = Math.max(size.x, this.loader.logicalScreenWidth);
            size.y = Math.max(size.y, this.loader.logicalScreenHeight);
        }
        size.x += 4;
        size.y += 4;
        return size;
    }

    protected synchronized void createBusyThread() {
        if (this.busyThread != null) {
            return;
        }
        this.stop = false;
        this.busyThread = new Thread(){
            private Image timage;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    Image offScreenImage = new Image((Device)BusyIndicator.this.getDisplay(), BusyIndicator.this.loader.logicalScreenWidth, BusyIndicator.this.loader.logicalScreenHeight);
                    GC offScreenImageGC = new GC((Drawable)offScreenImage);
                    BusyIndicator.this.getDisplay().asyncExec(new Runnable(this, offScreenImageGC){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ GC val$offScreenImageGC;
                        {
                            this.this$1 = var1_1;
                            this.val$offScreenImageGC = gC;
                        }

                        public void run() {
                            2.access$0(this.this$1).drawBackground(this.val$offScreenImageGC, 0, 0, 2.access$0(this.this$1).loader.logicalScreenWidth, 2.access$0(this.this$1).loader.logicalScreenHeight);
                        }
                    });
                    try {
                        try {
                            int imageDataIndex = 0;
                            ImageData imageData = BusyIndicator.this.progressData[imageDataIndex];
                            if (this.timage != null && !this.timage.isDisposed()) {
                                this.timage.dispose();
                            }
                            this.timage = new Image((Device)BusyIndicator.this.getDisplay(), imageData);
                            offScreenImageGC.drawImage(this.timage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                            int repeatCount = BusyIndicator.this.loader.repeatCount;
                            while (!(BusyIndicator.this.loader.repeatCount != 0 && repeatCount <= 0 || BusyIndicator.this.stop || BusyIndicator.this.isDisposed())) {
                                switch (imageData.disposalMethod) {
                                    case 2: {
                                        offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                                        break;
                                    }
                                    case 3: {
                                        offScreenImageGC.drawImage(this.timage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                        break;
                                    }
                                }
                                imageDataIndex = (imageDataIndex + 1) % BusyIndicator.this.progressData.length;
                                imageData = BusyIndicator.this.progressData[imageDataIndex];
                                this.timage.dispose();
                                this.timage = new Image((Device)BusyIndicator.this.getDisplay(), imageData);
                                offScreenImageGC.drawImage(this.timage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                BusyIndicator.this.animationImage = offScreenImage;
                                BusyIndicator.this.getDisplay().syncExec(new Runnable(this){
                                    final /* synthetic */ 2 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        if (!2.access$0(this.this$1).isDisposed()) {
                                            2.access$0(this.this$1).redraw();
                                        }
                                    }
                                });
                                try {
                                    int ms = imageData.delayTime * 10;
                                    if (ms < 20) {
                                        ms += 50;
                                    }
                                    if (ms < 30) {
                                        ms += 20;
                                    }
                                    Thread.sleep(ms);
                                }
                                catch (InterruptedException interruptedException) {}
                                if (imageDataIndex != BusyIndicator.this.progressData.length - 1) continue;
                                --repeatCount;
                            }
                        }
                        catch (SWTException sWTException) {}
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (offScreenImage != null && !offScreenImage.isDisposed()) {
                            offScreenImage.dispose();
                        }
                        if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                            offScreenImageGC.dispose();
                        }
                        if (this.timage == null) throw throwable;
                        if (this.timage.isDisposed()) throw throwable;
                        this.timage.dispose();
                        throw throwable;
                    }
                    {
                        Object var7_9 = null;
                    }
                    if (offScreenImage != null && !offScreenImage.isDisposed()) {
                        offScreenImage.dispose();
                    }
                    if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                        offScreenImageGC.dispose();
                    }
                    if (this.timage != null && !this.timage.isDisposed()) {
                        this.timage.dispose();
                    }
                    if (BusyIndicator.this.busyThread != null) return;
                    Display.getDefault().syncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            2.access$0(this.this$1).animationImage = null;
                            2.access$0(this.this$1).redraw();
                        }
                    });
                    return;
                }
                catch (Exception exception) {}
            }

            static /* synthetic */ BusyIndicator access$0(2 var0) {
                return var0.BusyIndicator.this;
            }
        };
        this.busyThread.setPriority(7);
        this.busyThread.setDaemon(true);
        this.busyThread.start();
    }

    public void dispose() {
        this.stop = true;
        this.busyThread = null;
        super.dispose();
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isBusy() {
        return this.busyThread != null;
    }

    protected void onPaint(PaintEvent event) {
        Image activeImage;
        if (this.animationImage != null && this.animationImage.isDisposed()) {
            this.animationImage = null;
        }
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        GC gc = event.gc;
        Image image = activeImage = this.animationImage != null ? this.animationImage : this.image;
        if (activeImage != null) {
            Rectangle ibounds = activeImage.getBounds();
            gc.drawImage(activeImage, rect.width / 2 - ibounds.width / 2, rect.height / 2 - ibounds.height / 2);
        }
    }

    public synchronized void setBusy(boolean busy) {
        if (busy) {
            if (this.busyThread == null) {
                this.createBusyThread();
            }
        } else if (this.busyThread != null) {
            this.stop = true;
            this.busyThread = null;
        }
    }

    public void setImage(Image image) {
        if (image != this.image && !this.isDisposed()) {
            this.image = image;
            this.redraw();
        }
    }
}

