/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.application;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;



/**
 * The main plugin class to be used in the desktop.
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetJFWatcherPlugin extends AbstractUIPlugin {
    /* UIPluginCX^X */
    private static NetJFWatcherPlugin instance;

    /* ResourceBundle */
    private ResourceBundle resourceBundle;

    /**
     * UIPluginCX^X𐶐܂B
     *
     */
    public NetJFWatcherPlugin() {
        instance = this;
    }

    /**
     * UIPluginCX^XԂ܂B
     *
     * @return instance RssrPlugin
     */
    public static NetJFWatcherPlugin getInstance() {
        return instance;
    }

    /**
     * This method is called upon plug-in activation
     *
     * @param context BundleContext
     * @throws Exception vtFXZbgňُ킪ꍇ
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);

        // Set the default preferences
        IPreferenceStore ps = getPreferenceStore();
        ps.setDefault(NetJFWatcherAdvisor.PROMPT_ON_EXIT_PREFERENCE, true);
        ps.setDefault(NetJFWatcherAdvisor.WORKBENCH_CONFIGURER, true);
    }

    /**
     * Returns the string from the plugin's resource bundle,
     * or 'key' if not found.
     *
     * @param key Key
     * @return plugin's resource bundle, or 'key' if not found
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle =
            NetJFWatcherPlugin.getDefault().getResourceBundle();

        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Returns the plugin's resource bundle,
     *
     * @return resourceBundle ResourceBundle
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    /**
     * Returns the shared instance.
     *
     * @return instance RssrPlugin
     */
    public static NetJFWatcherPlugin getDefault() {
        return instance;
    }
}
