package netjfwatcher.application;

import org.eclipse.jface.preference.IPreferenceStore;


/**
 * PreferenceێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class NetJFWatcherPreference {
    /** Log4J̒`t@C */
    public static final NetJFWatcherPreference LOG4J_CONFIGURATION =
        new NetJFWatcherPreference("log4j.configuration", "log4j.properties");

    /** [Nx`EBhE̕ */
    public static final NetJFWatcherPreference WORKBENCH_WIDTH =
        new NetJFWatcherPreference("WorkbenchWidth", "800");

    /** [Nx`EBhE̍ */
    public static final NetJFWatcherPreference WORKBENCH_HEIGHT =
        new NetJFWatcherPreference("WorkbenchHeight", "600");
    private final String defaultValue;
    private final String key;

    /**
     * keyƃftHgl̃yAPreferenceStoreƂĐ܂B
     *
     * @param key Key
     * @param defaultValue ftHgl
     */
    private NetJFWatcherPreference(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
        mynode().setDefault(key, defaultValue);
    }

    /**
     * Floatf[^Ԃ܂B
     *
     * @return Floatf[^
     */
    public float getFloat() {
        return mynode().getFloat(key);
    }

    /**
     * Intf[^Ԃ܂B
     *
     * @return Intf[^
     */
    public int getInt() {
        return mynode().getInt(key);
    }

    /**
     * Ԃ܂B
     *
     * @return 
     */
    public String getString() {
        return mynode().getString(key);
    }

    /**
     * ftHgԂ܂B
     *
     * @return ftHg
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * KeyԂ܂B
     *
     * @return key Key
     */
    public String key() {
        return key;
    }

    /**
     * FloatlZbg܂B
     *
     * @param value Floatl
     */
    public void putFloat(float value) {
        mynode().setValue(key, value);
    }

    /**
     * IntlZbg܂B
     *
     * @param value Intl
     */
    public void putInt(int value) {
        mynode().setValue(key, value);
    }

    /**
     * PreferenceStoreɕZbg܂B
     *
     * @param value 
     */
    public void putString(String value) {
        mynode().setValue(key, value);
    }

    /**
     * PreferenceStorekeyƃftHgl𕶎ɂĕԂ܂B
     *
     * @return PreferenceStorekeyƃftHgl̕
     */
    public String toString() {
        return "{" + getClass().getName() + ": key=" + key() + ", default="
        + defaultValue() + "}";
    }

    /**
     * PreferenceStoreԂ܂B
     *
     * @return IPreferenceStore
     */
    private static IPreferenceStore mynode() {
        return NetJFWatcherPlugin.getInstance().getPreferenceStore();
    }
}
