package netjfwatcher.authentication;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class AuthenticationManager {

	
	private Map<String, Date> clientIPMap = Collections.synchronizedMap(new HashMap<String, Date>());
	
	private AuthenticationManager() {
		
	}
	

	
	public boolean checkUserName(String ipAddress, String userName, String password) {
		
		if(AuthenticationConfig.getInstance().getAuthInfo().checkUser(userName, password)){
			if(!checkIP(ipAddress)) {
				setIP(ipAddress);
			}
			return true;	
		}
		return false;
	}
	
	
	public boolean checkIP(String ipAddress) {
		if(clientIPMap.containsKey(ipAddress)) {
			return true;
		}
		return false;
	}
	
	public void setIP(String ipAddress) {
		
		Date startDate = Calendar.getInstance().getTime();
		clientIPMap.put(ipAddress, startDate);
	}
	
    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AuthenticationManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AuthenticationManager RESOURCE = new AuthenticationManager();
    }
}
