/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.common.view;

import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderNodeDetect;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderNodeTree;
import netjfwatcher.engine.model.action.ActionBuilderSnmp;
import netjfwatcher.engine.model.action.ListenerNodeListTree;
import netjfwatcher.webbrowser.nodetree.NodeTreeViewContentProvider;
import netjfwatcher.webbrowser.nodetree.NodeTreeViewLabelProvider;
import netjfwatcher.webbrowser.nodetree.NodeTreeViewSorter;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;


/**
 * Node Tree Viewɂ郁o[yу\bh钊ۃNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractNodeTreeView extends ViewPart {
    /** Node TreeANV */
    protected ActionBuilderNodeTree actionNodeTree;

    /** A[ɊւANV */
    protected ActionBuilderAlarmList actinAlarm = new ActionBuilderAlarmList();

    /** m[hSnmp֘ÃANV */
    protected ActionBuilderSnmp snmpAction = new ActionBuilderSnmp();

    /** Ot\ɊւANV */
    protected ActionBuilderChart nodeChart = new ActionBuilderChart();

    /** Editor PartɊւANV */
    protected ActionBuilderEditorsPartClose actionBuilderEditorPart =
        new ActionBuilderEditorsPartClose();

    /** m[hɊւANV */
    protected ActionBuilderNodeOperation actionBuilderNodeOperation =
        new ActionBuilderNodeOperation();

    /** m[hoɊւANV */
    protected ActionBuilderNodeDetect actionBuilderNodeDetect =
        new ActionBuilderNodeDetect();

    /** TreeViewer */
    protected TreeViewer nodeListTreeViewer;

    protected Composite parentComposite;
    protected NodeTreeGroup nodeTreeGroupRoot;
    /**
     * Node Tree Viewɂ郁o[yу\bh钊ۃNX
     * CX^X𐶐܂B
     *
     */
    public AbstractNodeTreeView() {
        // nothing
    }

    /**
     * m[hTreeɊւANVԂ܂B
     *
     * @return actionNodeTree m[hTreeɊւANV
     */
    public ActionBuilderNodeTree getActionNodeTreeBuilder() {
        return actionNodeTree;
    }

    /**
     * tH[JXZbgꂽ̏łB
     *
     */
    public void setFocus() {
    }

    /**
     * TreeViewerԂ܂B
     *
     * @return nodeTreeViewer TreeViewer
     */
    public TreeViewer getViewer() {
        return nodeListTreeViewer;
    }

    /**
     * r[ꂽƂɂ܂sꃁ\bhłB
     *
     * @param parentComposite Composite
     */
    public void createPartControl(Composite parentComposite) {
    	this.parentComposite = parentComposite;
        /* Tree Viewer𐶐 */
        nodeListTreeViewer = new TreeViewer(parentComposite);
        nodeListTreeViewer.setUseHashlookup(true);
        nodeListTreeViewer.setContentProvider(
            new NodeTreeViewContentProvider());
        nodeListTreeViewer.setLabelProvider(new NodeTreeViewLabelProvider());

        /* SorterZbg */
        nodeListTreeViewer.setSorter(new NodeTreeViewSorter());

        /* m[hTree Group̓f[^ƂăZbg */
        nodeListTreeViewer.setInput(createInitialInput());
        nodeListTreeViewer.expandAll();

        /* m[hTreeRoot擾 */
        INodeTreeNode nodeTreeNode = (INodeTreeNode) getViewer().getInput();
        nodeTreeGroupRoot = nodeTreeNode.getParent();

        if (nodeTreeNode instanceof NodeTreeGroup) {
            nodeTreeGroupRoot = (NodeTreeGroup) nodeTreeNode;
        }

        /* m[hTreeANVZbg */
        actionNodeTree =
            new ActionBuilderNodeTree(
                this, nodeListTreeViewer, parentComposite, nodeTreeGroupRoot);

        /* m[hTree View̑IXi[ݒ */
        setupNodeTreeViewListener();

        /* Contextj[ */
        createContextMenu();

        /* ANV̏ƂToolBarݒ */
        setToolBarActions();

        /* \ݒ */
        initShow();
    }

    /**
     * ̃m[hTreer[̏͐ݒl𐶐܂B
     *
     * @return topInputDataObject
     */
    protected Object createInitialInput() {
        /* m[hTreełtopm[h𐶐 */
        NodeTreeGroup topInputDataObject = new RootOfRootNodeTreeGroup();

        return topInputDataObject;
    }

    /**
     * m[hTree View̏\̂߂Ƀf[^擾A\
     * \bhłB
     *
     */
    abstract protected void initShow();

    /**
     * m[hTree View̑IXi[ݒ肵܂B
     *
     */
    protected void setupNodeTreeViewListener() {
        /*
         * Node Tree ViewɃXi[o^
         * Xi[̏ƂẮA
         * e[uViewɃtB[hꗗőIGg͒lƂĐݒ
         *
         */
        nodeListTreeViewer.addSelectionChangedListener(
            new ListenerNodeListTree(false));
    }

    /**
     * m[hTree View̃j[ݒ肷郁\bhłB
     *
     */
    abstract protected void setToolBarActions();

    /**
     * m[hTree ViewContextj[ݒ肷郁\bhłB
     *
     */
    abstract protected void createContextMenu();

    /**
     * m[hTreeɂTopm[ĥ߂̃NXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    protected static final class RootOfRootNodeTreeGroup extends NodeTreeGroup {
        /**
         * em[hԂ܂B
         *
         * @return em[h
         */
        public NodeTreeGroup getParent() {
            return null;
        }

        /**
         * qm[h폜܂B
         *
         * @param toRemove m[h
         */
        public void removeChild(INodeTreeNode toRemove) {
            // ROOT O[vȂ悤ɃI[o[Ch
        }
    }
}
