/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.common.view;

import java.util.Calendar;
import java.util.GregorianCalendar;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;


/**
 * J_[𐶐NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CalendarTable {
    /* J_[e[uJ(Day)TCY */
    private static final int DAY_WIDTH = 30;

    /* j̒` */
    private static final String[] WEEK =
        // { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
        {"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" };

    /* jForgroundF */
    private Color sundayColor =
        Display.getCurrent().getSystemColor(SWT.COLOR_RED);

    /* yjforgroundF */
    private Color saturdayColor =
        Display.getCurrent().getSystemColor(SWT.COLOR_BLUE);
    private Color todayColor =
        Display.getCurrent().getSystemColor(SWT.COLOR_DARK_BLUE);
    private Color whiteColor =
        Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

    /* J_[e[u */
    private Table table;

    // Tableɕ\ĂJ_[
    private Calendar displayCalendar;

    //  NAj
    private int iThisYear;
    private int iThisMonth;
    private int iThisDate;
    private int iThisWeek;

    /**
     * J_[e[u𐶐܂B
     *
     * @param parent TableCX^X̐eɂȂR|Wbg
     * @param style  X^C Rg[
     */
    public CalendarTable(Composite parent, int style) {
        /*
         * ColorIuWFNgjĂꍇăZbg
         */
        if ((sundayColor == null) || sundayColor.isDisposed()) {
            sundayColor = Display.getCurrent().getSystemColor(SWT.COLOR_RED);
        }

        if ((saturdayColor == null) || saturdayColor.isDisposed()) {
            saturdayColor = Display.getCurrent().getSystemColor(SWT.COLOR_BLUE);
        }

        if ((todayColor == null) || todayColor.isDisposed()) {
            todayColor =
                Display.getCurrent().getSystemColor(SWT.COLOR_DARK_BLUE);
        }

        if ((whiteColor == null) || whiteColor.isDisposed()) {
            whiteColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
        }

        /*
         * ݎiftHgP[, ^C][j
         * GregorianCalendar \z
         */
        this.displayCalendar = new GregorianCalendar();

        iThisYear = displayCalendar.get(Calendar.YEAR);
        iThisMonth = displayCalendar.get(Calendar.MONTH);
        iThisDate = displayCalendar.get(Calendar.DATE);
        iThisWeek = displayCalendar.get(Calendar.DAY_OF_WEEK);

        table = new Table(parent, style);

        /* J_[e[uZbg */
        setupCalendarTable();
    }

    /*
     * Calendare[uZbg܂B
     *
     */
    private void setupCalendarTable() {
        // Set Grid Data
        GridData tableGridData = new GridData(GridData.FILL);
        tableGridData.horizontalAlignment = GridData.CENTER;
        tableGridData.verticalAlignment = GridData.CENTER;
        table.setLayoutData(tableGridData);

        // r̕\
        table.setLinesVisible(true);

        // ̃wb_̕\
        table.setHeaderVisible(true);

        // ̃wb_ɗjݒ
        TableColumn[] col = new TableColumn[WEEK.length];

        for (int iCol = 0; iCol < WEEK.length; iCol++) {
            col[iCol] = new TableColumn(table, SWT.CENTER);
            col[iCol].setText(WEEK[iCol]);
            col[iCol].setWidth(DAY_WIDTH);
        }
    }

    /*
     * J_[Zbg܂B
     */
    private String setCalendar() {
        String strYYMM = "";

        //J_[̓eUNA
        table.removeAll();

        // \N̕쐬
        strYYMM = (" " + displayCalendar.get(Calendar.YEAR) + "N "
            + (displayCalendar.get(Calendar.MONTH) + 1) + " ");

        Calendar tmpCal = (Calendar) displayCalendar.clone();

        // ɂ 1珇ɁAe[uɃZbg
        tmpCal.set(Calendar.DAY_OF_MONTH, 1);

        int iDispMonth = displayCalendar.get(Calendar.MONTH);

        TableItem item = new TableItem(table, SWT.NULL);

        // P\
        while (iDispMonth == tmpCal.get(Calendar.MONTH)) {
            // TςATableItemǉāA̍sɂ
            if (tmpCal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
                item = new TableItem(table, SWT.NULL);
            }

            item.setText(
                tmpCal.get(Calendar.DAY_OF_WEEK) - 1,
                Integer.toString(tmpCal.get(Calendar.DATE)));

            item.setForeground(0, sundayColor); // jColor
            item.setForeground(6, saturdayColor); // yjColor

            if (
                (iThisYear == displayCalendar.get(Calendar.YEAR))
                    && ((iThisMonth + 1) == (displayCalendar.get(
                        Calendar.MONTH) + 1))
                    && (iThisDate == tmpCal.get(Calendar.DATE))) {
                /* ݓColorZbg */
                item.setForeground(
                    tmpCal.get(Calendar.DAY_OF_WEEK) - 1, whiteColor);
                item.setBackground(
                    tmpCal.get(Calendar.DAY_OF_WEEK) - 1, todayColor);
            }

            // i߂
            tmpCal.add(Calendar.DAY_OF_MONTH, 1);
        }

        return strYYMM;
    }

    /**
     * J_[\ĂNԂ܂B
     *
     * @return strYear
     */
    public String getSelectYear() {
        String strYear = Integer.toString(displayCalendar.get(Calendar.YEAR));

        return strYear;
    }

    /**
     * J_[\Ă錎Ԃ܂B
     *
     * @return strMonth
     */
    public String getSelectMonth() {
        String strMonth =
            Integer.toString((displayCalendar.get(Calendar.MONTH) + 1));

        return strMonth;
    }

    /**
     * ݂̔NAAԂ܂B
     *
     * @return strYYMMDD
     */
    public String getTodaysYYMMDD() {
        String strYear = Integer.toString(iThisYear);
        String strMonth = Integer.toString(iThisMonth + 1);
        String strDate = Integer.toString(iThisDate);
        String strDayOfWeek = WEEK[iThisWeek - 1];

        String strYYMMDD =
            strYear + " " + strMonth + "/" + strDate + " [" + strDayOfWeek
            + "]";

        return strYYMMDD;
    }

    
    /**
     * ݂̔NԂ܂B
     *
     * @return strYear ݂̔N
     */
    public String getTodaysYY() {
        String strYear = Integer.toString(iThisYear);

        return strYear;
    }

    /**
     * ݂̌Ԃ܂B
     *
     * @return strMonth ݂̌
     */
    public String getTodaysMM() {
        String strMonth = Integer.toString(iThisMonth + 1);

        return strMonth;
    }

    /**
     * {̓ɂԂ܂B
     *
     * @return strDate {̓ɂ
     */
    public String getTodaysDD() {
        String strDate = Integer.toString(iThisDate);

        return strDate;
    }

    /**
     * J_[𗂌ɕύX܂B
     *
     * @return J_[ɕ\N̕
     */
    public String setNextMonth() {
        displayCalendar.add(Calendar.MONTH, 1);

        return setCalendar();
    }

    /**
     * J_[OɕύX܂B
     *
     * @return J_[ɕ\N̕
     */
    public String setPrevMonth() {
        displayCalendar.add(Calendar.MONTH, -1);

        return setCalendar();
    }

    /**
     * J_[ɕύX܂B
     *
     * @return J_[ɕ\N̕
     */
    public String setThisMonth() {
        displayCalendar.set(iThisYear, iThisMonth, iThisDate);

        return setCalendar();
    }

    /**
     * w̔ÑJ_[ɃZbg܂B
     *
     * @param iYear  \sN
     * @param iMonth \s
     * @return       J_[ɕ\N̕
     */
    public String setSpecifiedMonth(int iYear, int iMonth) {
        displayCalendar.set(iYear, iMonth, iThisDate);

        return setCalendar();
    }



    /**
     * TableԂ܂B
     *
     * @return table Table
     */
    public Table getTable() {
        return table;
    }
}
