/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.common.view;

import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.engine.preferance.ViewColorPreferancePage;

import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;


/**
 * e[uXgr[ɕ\ColorێNXłB
 * A[̃xɑΉ\Fm[hXge[u\F
 * vtFXɐݒ肳ĂȂǂ琶ĕێ
 * ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class TableListViewColor {
    /* MO */
    private static Logger logger;

    /* G[LevelA[\F */
    private Color alarmErrorLevelColor;

    /* xLevelA[\F */
    private Color alarmWarningLevelColor;

    /* LevelA[\F */
    private Color alarmInfoLevelColor;

    /* m[hXge[uԍOʕ\F */
    private Color nodeListEvenForgroundColor;

    /* m[hXge[uԍwiF */
    private Color nodeListEvenBackgroundColor;

    /* m[hXge[uԍOʕ\F */
    private Color nodeListOddForgroundColor;

    /* m[hXge[uԍwiF */
    private Color nodeListOddBackgroundColor;

    /* m[hXge[uXe[^XOʕ\F */
    private Color nodeListStatusForgroundColor;

    private TableListViewColor() {
        logger = Logger.getLogger(this.getClass().getName());

        updateAlarmListColor();
        updateNodeListColor();
    }

    /**
     * A[Xg̃J[XV܂B
     *
     */
    public void updateAlarmListColor() {
        if (alarmErrorLevelColor != null) {
            alarmErrorLevelColor.dispose();
        }

        if (alarmWarningLevelColor != null) {
            alarmWarningLevelColor.dispose();
        }

        if (alarmInfoLevelColor != null) {
            alarmInfoLevelColor.dispose();
        }

        PreferenceStore colorPref;
        colorPref =
            new PreferenceStore(ViewColorPreferancePage.COLOR_PREFERENCE_FILE);

        try {
            colorPref.load();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
        }

        String errorColorPref =
            colorPref.getString(
                ViewColorPreferancePage.ALARM_ERROR_LEVEL_COLOR_NAME);
        String warningColorPref =
            colorPref.getString(
                ViewColorPreferancePage.ALARM_WARNING_LEVEL_COLOR_NAME);
        String infoColorPref =
            colorPref.getString(
                ViewColorPreferancePage.ALARM_INFO_LEVEL_COLOR_NAME);

        if ((errorColorPref == null) || errorColorPref.equals("")) {
            alarmErrorLevelColor =
                parseColor(
                    ViewColorPreferancePage.DEFAULT_ALARM_ERROR_LEVEL_COLOR);
        } else {
            Color createColor = null;
            createColor = parseColor(errorColorPref);

            if (createColor == null) {
                alarmErrorLevelColor =
                    Display.getCurrent().getSystemColor(SWT.COLOR_RED);
            } else {
                alarmErrorLevelColor = createColor;
            }
        }

        if ((warningColorPref == null) || warningColorPref.equals("")) {
            alarmWarningLevelColor =
                parseColor(
                    ViewColorPreferancePage.DEFAULT_ALARM_WARNING_LEVEL_COLOR);
        } else {
            Color createColor = null;
            createColor = parseColor(warningColorPref);

            if (createColor == null) {
                alarmWarningLevelColor =
                    Display.getCurrent().getSystemColor(SWT.COLOR_GREEN);
            } else {
                alarmWarningLevelColor = createColor;
            }
        }

        if ((infoColorPref == null) || infoColorPref.equals("")) {
            alarmInfoLevelColor =
                parseColor(
                    ViewColorPreferancePage.DEFAULT_ALARM_INFO_LEVEL_COLOR);
        } else {
            Color createColor = null;
            createColor = parseColor(infoColorPref);

            if (createColor == null) {
                alarmInfoLevelColor =
                    Display.getCurrent().getSystemColor(SWT.COLOR_BLACK);
            } else {
                alarmInfoLevelColor = createColor;
            }
        }
    }

    /**
     * m[hXg̃J[XV܂B
     *
     */
    public void updateNodeListColor() {
        if (nodeListEvenForgroundColor != null) {
            nodeListEvenForgroundColor.dispose();
        }

        if (nodeListEvenBackgroundColor != null) {
            nodeListEvenBackgroundColor.dispose();
        }

        if (nodeListOddForgroundColor != null) {
            nodeListOddForgroundColor.dispose();
        }

        if (nodeListOddBackgroundColor != null) {
            nodeListOddBackgroundColor.dispose();
        }

        if (nodeListStatusForgroundColor != null) {
            nodeListStatusForgroundColor.dispose();
        }

        PreferenceStore colorPref;
        colorPref =
            new PreferenceStore(ViewColorPreferancePage.COLOR_PREFERENCE_FILE);

        try {
            colorPref.load();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
        }

        String nodeListEvenForColorPref =
            colorPref.getString(
                ViewColorPreferancePage.NODE_LIST_EVEN_FORGROUND_COLOR_NAME);
        String nodeListEvenBackColorPref =
            colorPref.getString(
                ViewColorPreferancePage.NODE_LIST_EVEN_BACKGROUND_COLOR_NAME);
        String nodeListOddForColorPref =
            colorPref.getString(
                ViewColorPreferancePage.NODE_LIST_ODD_FORGROUND_COLOR_NAME);
        String nodeListOddBackColorPref =
            colorPref.getString(
                ViewColorPreferancePage.NODE_LIST_ODD_BACKGROUND_COLOR_NAME);
        String nodeListStatusForColorPref =
            colorPref.getString(
                ViewColorPreferancePage.NODE_LIST_STATUS_COLOR_NAME);

        if (
            nodeListEvenForColorPref.equals("")
                || (nodeListEvenForColorPref == null)) {
            nodeListEvenForgroundColor =
                parseColor(
                    ViewColorPreferancePage.DEFAULT_NODE_LIST_EVEN_FORGROUND_COLOR);
        } else {
            Color createColor = null;
            createColor = parseColor(nodeListEvenForColorPref);

            if (createColor == null) {
                nodeListEvenForgroundColor =
                    Display.getCurrent().getSystemColor(SWT.COLOR_BLACK);
            } else {
                nodeListEvenForgroundColor = createColor;
            }
        }

        if (
            nodeListEvenBackColorPref.equals("")
                || (nodeListEvenBackColorPref == null)) {
            nodeListEvenBackgroundColor =
                parseColor(
                    ViewColorPreferancePage.DEFAULT_NODE_LIST_EVEN_BACKGROUND_COLOR);
        } else {
            Color createColor = null;
            createColor = parseColor(nodeListEvenBackColorPref);

            if (createColor == null) {
                nodeListEvenBackgroundColor =
                    Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
            } else {
                nodeListEvenBackgroundColor = createColor;
            }
        }

        if (
            nodeListOddForColorPref.equals("")
                || (nodeListOddForColorPref == null)) {
            nodeListOddForgroundColor =
                parseColor(
                    ViewColorPreferancePage.DEFAULT_NODE_LIST_ODD_FORGROUND_COLOR);
        } else {
            Color createColor = null;
            createColor = parseColor(nodeListOddForColorPref);

            if (createColor == null) {
                nodeListOddForgroundColor =
                    Display.getCurrent().getSystemColor(SWT.COLOR_BLACK);
            } else {
                nodeListOddForgroundColor = createColor;
            }
        }

        if (
            nodeListOddBackColorPref.equals("")
                || (nodeListOddBackColorPref == null)) {
            nodeListOddBackgroundColor =
                parseColor(
                    ViewColorPreferancePage.DEFAULT_NODE_LIST_ODD_BACKGROUND_COLOR);
        } else {
            Color createColor = null;
            createColor = parseColor(nodeListOddBackColorPref);

            if (createColor == null) {
                nodeListOddBackgroundColor =
                    Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
            } else {
                nodeListOddBackgroundColor = createColor;
            }
        }

        if (
            nodeListStatusForColorPref.equals("")
                || (nodeListStatusForColorPref == null)) {
            nodeListStatusForgroundColor =
                parseColor(
                    ViewColorPreferancePage.DEFAULT_NODE_LIST_STATUS_COLOR);
        } else {
            Color createColor = null;
            createColor = parseColor(nodeListStatusForColorPref);

            if (createColor == null) {
                nodeListStatusForgroundColor =
                    Display.getCurrent().getSystemColor(SWT.COLOR_RED);
            } else {
                nodeListStatusForgroundColor = createColor;
            }
        }
    }

    /**
     * RGBJ[f[^\񂩂J[IuWFNg𐶐܂B
     *
     * @param str RGBJ[f[^\(exp. "255,255,255")
     * @return ColorIuWFNg
     */
    private Color parseColor(String str) {
        Pattern pattern;
        String[] itemRGB;
        Color createColor = null;
        pattern = Pattern.compile(",");
        itemRGB = pattern.split(str);

        if (itemRGB.length == 3) {
            try {
                int[] rgbData = new int[itemRGB.length];

                for (int j = 0; j < rgbData.length; j++) {
                    rgbData[j] = Integer.parseInt(itemRGB[j]);
                }

                createColor =
                    new Color(null, rgbData[0], rgbData[1], rgbData[2]);
            } catch (NumberFormatException e) {
                logger.warning(str + " : " + e.getMessage());
            }
        } else {
            logger.warning("Illegal Color RGB Data : " + str);
        }

        return createColor;
    }

    /* ( Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (alarmErrorLevelColor != null) {
            alarmErrorLevelColor.dispose();
        }

        if (alarmWarningLevelColor != null) {
            alarmWarningLevelColor.dispose();
        }

        if (alarmInfoLevelColor != null) {
            alarmInfoLevelColor.dispose();
        }

        if (nodeListEvenForgroundColor != null) {
            nodeListEvenForgroundColor.dispose();
        }

        if (nodeListEvenBackgroundColor != null) {
            nodeListEvenBackgroundColor.dispose();
        }

        if (nodeListOddForgroundColor != null) {
            nodeListOddForgroundColor.dispose();
        }

        if (nodeListOddBackgroundColor != null) {
            nodeListOddBackgroundColor.dispose();
        }

        if (nodeListStatusForgroundColor != null) {
            nodeListStatusForgroundColor.dispose();
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static TableListViewColor getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * A[̃G[x̃J[Ԃ܂B
     *
     * @return alarmErrorLevelColor G[x̃J[
     */
    public Color getAlarmErrorLevelColor() {
        return alarmErrorLevelColor;
    }

    /**
     * A[̏񃌃x̃J[Ԃ܂B
     *
     * @return alarmInfoLevelColor 񃌃x̃J[
     */
    public Color getAlarmInfoLevelColor() {
        return alarmInfoLevelColor;
    }

    /**
     * A[̌xx̃J[Ԃ܂B
     *
     * @return alarmWarningLevelColorxx̃J[
     */
    public Color getAlarmWarningLevelColor() {
        return alarmWarningLevelColor;
    }

    /**
     * m[hXg̊ԍ̔wiF̃J[Ԃ܂B
     *
     * @return nodeListEvenBackgroundColor m[hXg̊ԍ̔wiF̃J[
     */
    public Color getNodeListEvenBackgroundColor() {
        return nodeListEvenBackgroundColor;
    }

    /**
     * m[hXg̊ԍ̕F̃J[Ԃ܂B
     *
     * @return nodeListEvenForgroundColor m[hXg̊ԍ̕F̃J[
     */
    public Color getNodeListEvenForgroundColor() {
        return nodeListEvenForgroundColor;
    }

    /**
     * m[hXg̋ԍ̔wiF̃J[Ԃ܂B
     *
     * @return nodeListOddBackgroundColor m[hXg̋ԍ̔wiF̃J[
     */
    public Color getNodeListOddBackgroundColor() {
        return nodeListOddBackgroundColor;
    }

    /**
     * m[hXg̋ԍ̕F̃J[Ԃ܂B
     *
     * @return nodeListOddForgroundColorm[hXg̋ԍ̕F̃J[
     */
    public Color getNodeListOddForgroundColor() {
        return nodeListOddForgroundColor;
    }

    /**
     * m[hXg̃Xe[^X̕F̃J[Ԃ܂B
     *
     * @return nodeListStatusForgroundColor m[hXg̃Xe[^X̕F̃J[
     */
    public Color getNodeListStatusForgroundColor() {
        return nodeListStatusForgroundColor;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final TableListViewColor RESOURCE = new TableListViewColor();
    }
}
