/*
 * Created on 2004/06/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.control;

import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.database.access.model.DBTableAlarmFilter;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.database.access.model.DBTableTaskSchedule;
import netjfwatcher.database.access.model.DatabaseTest;


/**
 * ORACLEpSQLێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DataAccessObjectOracle extends AbstractDataAccessObject {
    /* CNgJpSQL */
    private static final String AUTO_INCREMENT =
        "id MEDIUMINT NOT NULL AUTO_INCREMENT";

    /** m[hĎe[uSQL */
    private static final String CREATE_NODEREGISTER_TABLE =
        "CREATE TABLE " + DBTableNodeRegister.NODE_REGISTER_TABLE + " ("
        + DBTableNodeRegister.NODENAME + " VARCHAR(255),"
        + DBTableNodeRegister.IPADDRESS + " VARCHAR(15),"
        + DBTableNodeRegister.NODEGROUP + " VARCHAR(255),"
        + DBTableNodeRegister.NODEX + " VARCHAR(10),"
        + DBTableNodeRegister.NODEY + " VARCHAR(10),"
        + DBTableNodeRegister.NODEKIND + " VARCHAR(255),"
        + DBTableNodeRegister.PING_PERIOD + " VARCHAR(10),"
        + DBTableNodeRegister.PING_THRESHOLD + " VARCHAR(10),"
        + DBTableNodeRegister.SNMP_VERSION + " VARCHAR(255),"
        + DBTableNodeRegister.SNMP_PERIOD + " VARCHAR(10),"
        + DBTableNodeRegister.SNMPTIMEOUT + " VARCHAR(10),"
        + DBTableNodeRegister.SNMP_LEVEL + " VARCHAR(10),"
        + DBTableNodeRegister.SNMP_ROCOMMUNITY + " VARCHAR(10),"
        + DBTableNodeRegister.SNMP_RWCOMMUNITY + " VARCHAR(10),"
        + DBTableNodeRegister.HTTP_URL + " VARCHAR(255),"
        + DBTableNodeRegister.HTTP_PERIOD + " VARCHAR(10),"
        + DBTableNodeRegister.HTTP_PORT + " VARCHAR(10),"
        + DBTableNodeRegister.HTTP_TIMEOUT + " VARCHAR(10),"
        + DBTableNodeRegister.POP3_PERIOD + " VARCHAR(10),"
        + DBTableNodeRegister.SMTP_PERIOD + " VARCHAR(10),"
        + DBTableNodeRegister.SMTP_PORT + " VARCHAR(10),"
        + DBTableNodeRegister.SMTP_TIMEOUT + " VARCHAR(10),"
        + DBTableNodeRegister.ENGINE_ADDRESS + " VARCHAR(255),"
        + DBTableNodeRegister.LAST_CHECK + " "
        + AbstractDataAccessObject.TIMESTAMP + ","
        + DBTableNodeRegister.REGISTER_DATE + " "
        + AbstractDataAccessObject.TIMESTAMP + ")";

    /** m[hĎe[u폜SQL */
    private static final String DROP_NODEREGISTER_TABLE =
        "DROP TABLE " + DBTableNodeRegister.NODE_REGISTER_TABLE;

    /** A[e[uSQL */
    private static final String CREATE_ALARM_TABLE =
        "CREATE TABLE " + DBTableAlarm.ALARM_TABLE + " ("
        + "id serial PRIMARY KEY," + DBTableAlarm.NODENAME + " VARCHAR(255),"
        + DBTableAlarm.GROUP + " VARCHAR(255)," + DBTableAlarm.IPADDRESS
        + " VARCHAR(15)," + DBTableAlarm.ALARM_CODE + " VARCHAR(255),"
        + DBTableAlarm.ALARM_LEVEL + " VARCHAR(10),"
        + DBTableAlarm.ALARM_MESSAGE + " VARCHAR(255),"
        + DBTableAlarm.ALARM_CONFIRM + " VARCHAR(10),"
        + DBTableAlarm.ALARM_DATE + " " + AbstractDataAccessObject.TIMESTAMP
        + ")";

    /** A[e[u폜SQL */
    private static final String DROP_ALARM_TABLE =
        "DROP TABLE " + DBTableAlarm.ALARM_TABLE;

    /* A[tB^[e[uSQL */
    private static final String CREATE_ALARM_FILTER_TABLE =
        "CREATE TABLE " + DBTableAlarmFilter.ALARM_FILTER_TABLE + " ("
        + "id serial PRIMARY KEY," + DBTableAlarmFilter.NODENAME
        + " VARCHAR(10)," + DBTableAlarmFilter.IPADDRESS + " VARCHAR(15),"
        + DBTableAlarmFilter.ALARM_CODE + " VARCHAR(255),"
        + DBTableAlarmFilter.ALARM_LEVEL + " VARCHAR(10),"
        + DBTableAlarmFilter.ALARM_MESSAGE + " VARCHAR(255),"
        + DBTableAlarmFilter.ALARM_CONFIRM + " VARCHAR(10),"
        + DBTableAlarmFilter.ALARM_START_DATE + " VARCHAR(16),"
        + DBTableAlarmFilter.ALARM_END_DATE + " VARCHAR(16))";

    /** A[tB^[e[u폜SQL */
    private static final String DROP_ALARM_FILTER_TABLE =
        "DROP TABLE " + DBTableAlarmFilter.ALARM_FILTER_TABLE;

    /** ^XNXPW[e[uSQL */
    private static final String CREATE_TASK_SCHEDULE_TABLE =
        "CREATE CACHED TABLE " + DBTableTaskSchedule.TASK_SCHEDULEE_TABLE_NAME
        + " (" + AUTO_INCREMENT + " , " + DBTableTaskSchedule.TASK_ID
        + " VARCHAR(10)," + DBTableTaskSchedule.START_DATE + " "
        + AbstractDataAccessObject.TIMESTAMP + ", "
        + DBTableTaskSchedule.END_DATE + " "
        + AbstractDataAccessObject.TIMESTAMP + ")";

    /** ^XNXPW[e[u폜SQL */
    private static final String DROP_TASK_SCHEDULE_TABLE =
        "DROP TABLE " + DBTableTaskSchedule.TASK_SCHEDULEE_TABLE_NAME
        + " IF EXISTS";

    /** m[hMAP/Linke[uSQL */
    private static final String CREATE_NODE_MAP_LINK_TABLE =
        "CREATE TABLE " + DBTableMapLink.NODE_MAPLINK_TABLE + " ("
        + "id serial PRIMARY KEY," + DBTableMapLink.NODE_X_ADDRESS
        + " VARCHAR(15)," + DBTableMapLink.NODE_Y_ADDRESS + " VARCHAR(15))";

    /* m[hMAP/Linke[u폜SQL */
    private static final String DROP_NODE_MAP_LINK_TABLE =
        "DROP TABLE " + DBTableMapLink.NODE_MAPLINK_TABLE;

    /* f[^x[XғeXgpe[uSQL */
    private static final String CREATE_DATABASE_TEST_TABLE =
        "CREATE TABLE " + DatabaseTest.DATABASE_TEST_TABLE + " ("
        + "id serial PRIMARY KEY , " + DatabaseTest.TEST_CHAR + " VARCHAR(15),"
        + DatabaseTest.TEST_DATE + " " + AbstractDataAccessObject.TIMESTAMP
        + ")";

    /** f[^x[XғeXgpe[u폜SQL */
    private static final String DROP_DATABASE_TEST_TABLE =
        "DROP TABLE " + DatabaseTest.DATABASE_TEST_TABLE;

    /* e[uǗe[uSQL */
    private static final String CREATE_TABLE_MANAGEMENT_TABLE =
        "CREATE TABLE " + DBTableManagement.TABLEMANAGEMENT + " ("
        + "id serial PRIMARY KEY," + DBTableManagement.IPADDRESS
        + " VARCHAR(15)," + DBTableManagement.TABLE_NAME + " VARCHAR(255),"
        + DBTableManagement.LIMIT_CHECK + " VARCHAR(255),"
        + DBTableManagement.TABLE_CREATE_DATE + " "
        + AbstractDataAccessObject.TIMESTAMP + ")";

    /* e[uǗe[u폜SQL */
    private static final String DROP_TABLE_MANAGEMENT_TABLE =
        "DROP TABLE " + DBTableManagement.TABLEMANAGEMENT;

    /*  */
    private static final String ITEM_SNMP_STATISTICS_TABLE =
        "( " + DBTableStatisticsMIBControl.STATIS_OID + " VARCHAR(255),"
        + " instance_total VARCHAR(40)," + " period VARCHAR(40),"
        + " threshold VARCHAR(40)," + " thresholdtype VARCHAR(40),"
        + " curdate " + AbstractDataAccessObject.TIMESTAMP + " )";

    /* GarbageCollectione[uSQL */
    private static final String CREATE_GARBAGECOLLECTION_TABLE =
        "CREATE TABLE " + DBTableGarbageCollection.GARBAGECOLLECTION_TABLE
        + " (" + "id serial PRIMARY KEY,"
        + DBTableGarbageCollection.TOTAL_MEMORY + " VARCHAR(255), "
        + DBTableGarbageCollection.FREE_MEMORY + " VARCHAR(255), "
        + DBTableGarbageCollection.CHECK_DATE + " "
        + AbstractDataAccessObject.TIMESTAMP + " )";

    /** GarbageCollectione[u폜SQL */
    private static final String DROP_GARBAGECOLLECTION_TABLE =
        "DROP TABLE IF EXISTS "
        + DBTableGarbageCollection.GARBAGECOLLECTION_TABLE;

    /**
     * m[hĎe[uSQLԂ܂B
     *
     * @return CREATE_NODEREGISTER_TABLE m[hĎe[uSQL
     */
    public String getCreateNoderegisterTable() {
        return CREATE_NODEREGISTER_TABLE;
    }

    /**
    * m[hĎe[u폜SQLԂ܂B
    *
    * @return DROP_NODEREGISTER_TABLE m[hĎe[u폜SQL
    */
    public String getDropNoderegisterTableSQL() {
        return DROP_NODEREGISTER_TABLE;
    }

    /**
     * A[e[uSQLԂ܂B
     *
     * @return DROP_ALARM_TABLE A[e[uSQL
     */
    public String getDropAlarmTableSQL() {
        return DROP_ALARM_TABLE;
    }

    /**
     * A[e[u폜SQLԂ܂B
     *
     * @return CREATE_ALARM_TABLE A[e[u폜SQL
     */
    public String getCreateAlarmTable() {
        return CREATE_ALARM_TABLE;
    }

    /**
     * m[hMAP/Linke[uSQLԂ܂B
     *
     * @return CREATE_NODE_MAP_LINK_TABLE m[hMAP/Linke[uSQL
     */
    public String getCreateNodeMapLinkTableSQL() {
        return CREATE_NODE_MAP_LINK_TABLE;
    }

    /**
     * m[hMAP/Linke[u폜SQLԂ܂B
     *
     * @return DROP_NODE_MAP_LINK_TABLE m[hMAP/Linke[u폜SQL
     */
    public String getDropNodeMapLinkTableSQL() {
        return DROP_NODE_MAP_LINK_TABLE;
    }

    /**
     * A[tB^[e[uSQLԂ܂B
     *
     * @return CREATE_ALARM_FILTER_TABLE A[tB^[e[uSQL
     */
    public String getCreateAlarmFilterTableSQL() {
        return CREATE_ALARM_FILTER_TABLE;
    }

    /**
     * A[tB^[e[u폜SQLԂ܂B
     *
     * @return DROP_ALARM_FILTER_TABLE A[tB^[e[u폜SQL
     */
    public String getDropAlarmFilterTableSQL() {
        return DROP_ALARM_FILTER_TABLE;
    }

    /**
     * f[^x[XғeXgpe[uSQLԂ܂B
     *
     * @return CREATE_DATABASE_TEST_TABLE f[^x[XғeXgpe[uSQL
     */
    public String getCreateDatabaseTestTableSQL() {
        return CREATE_DATABASE_TEST_TABLE;
    }

    /**
     * f[^x[XғeXgpe[u폜SQLԂ܂B
     *
     * @return DROP_DATABASE_TEST_TABLE f[^x[XғeXgpe[u폜SQL
     */
    public String getDropDatabaseTestTableSQL() {
        return DROP_DATABASE_TEST_TABLE;
    }

    /**
     * ^XNXPW[e[uSQLԂ܂B
     *
     * @return CREATE_TASK_SCHEDULE_TABLE ^XNXPW[e[uSQL
     */
    public String getCreateTaskSCheduleTable() {
        return CREATE_TASK_SCHEDULE_TABLE;
    }

    /**
     * ^XNXPW[e[u폜SQLԂ܂B
     *
     * @return DROP_TASK_SCHEDULE_TABLE ^XNXPW[e[u폜SQL
     */
    public String getDropTaskSCheduleTable() {
        return DROP_TASK_SCHEDULE_TABLE;
    }

    /**
     * e[uǗe[uSQLԂ܂B
     *
     * @return CREATE_TABLE_MANAGEMENT_TABLE e[uǗe[uSQL
     */
    public String getCreateTableManagementTableSQL() {
        return CREATE_TABLE_MANAGEMENT_TABLE;
    }

    /**
     * e[uǗe[u폜SQLԂ܂B
     *
     * @return DROP_TABLE_MANAGEMENT_TABLE e[uǗe[u폜SQL
     */
    public String getDropTableManagementTableSQL() {
        return DROP_TABLE_MANAGEMENT_TABLE;
    }

    /**
     * GarbageCollectione[uSQLԂ܂B
     *
     * @return CREATE_GARBAGECOLLECTION_TABLE GarbageCollectione[uSQL
     */
    public String getCreateGarbageCollectionTableSQL() {
        return CREATE_GARBAGECOLLECTION_TABLE;
    }

    /**
     * GarbageCollectione[u폜SQLԂ܂B
     *
     * @return DROP_GARBAGECOLLECTION_TABLE GarbageCollectione[u폜SQL
     */
    public String getDropGarbageCollectionTableSQL() {
        return DROP_GARBAGECOLLECTION_TABLE;
    }

    /**
     * CNgSQLԂ܂B
     *
     * @return AUTO_INCREMENT
     */
    public String getAutoIncrement() {
        return AUTO_INCREMENT;
    }

    /**
     * SNMPvMIBe[uSQLԂ܂B
     *
     * @return ITEM_SNMP_STATISTICS_TABLE SNMPvMIBe[uSQL
     */
    public String getItemSnmpStatisticsTableSQL() {
        return ITEM_SNMP_STATISTICS_TABLE;
    }
}
