/*
 * Created on 2004/05/10
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.engine.socket.info.ResourceInfo;


/**
 * A[tB^[e[u𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DBTableAlarmFilter extends DBTableBase {
    /** A[tB^[i[e[u */
    public static final String ALARM_FILTER_TABLE = "alarm_filter_table";

    /** A[IDi[J */
    public static final String ALARM_ID = "id";

    /** m[hi[J */
    public static final String NODENAME = "nodename";

    /** IPAhXi[J */
    public static final String IPADDRESS = "ipaddress";

    /** A[R[hi[J */
    public static final String ALARM_CODE = "alarm_code";

    /** A[xi[J */
    public static final String ALARM_LEVEL = "alarm_level";

    /** A[bZ[Wi[J */
    public static final String ALARM_MESSAGE = "alarm_message";

    /** A[mFԊi[J */
    public static final String ALARM_CONFIRM = "alarm_confirm";

    /** A[otB^[Jn */
    public static final String ALARM_START_DATE = "alarm_start_date";

    /** A[otB^[I */
    public static final String ALARM_END_DATE = "alarm_end_date";

    /** A[tB^[ChJ[h */
    public static final String ANY = "*";

    /** A[mFԂɂ関mFԕ\ */
    public static final String CONFIM = "unconfirm";

    // MO
    private static Logger logger = null;

    /*
     * Alarm filter updateIDwp0n܂DB1
     * n܂DBɑΉ
     */
    private final String alarmID;

    /**
     * A[tB^[e[uCX^X𐶐܂B
     *
     */
    public DBTableAlarmFilter() {
        logger = Logger.getLogger(this.getClass().getName());

        SystemResourceFileParse resourceset =
            (SystemResourceConfig.getInstance()).getResourceFileParse();
        ResourceInfo resourceInfo = resourceset.getResourceInfo();

        String kind = resourceInfo.getDatabaseName();

        if (kind.equals(AbstractDataAccessObject.HSQLDB)) {
            alarmID = "'0'";
        } else if (
            kind.equals(AbstractDataAccessObject.DERBY)
                || kind.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
            alarmID = "1";
        } else {
            alarmID = "'1'";
        }
    }

    /**
     * A[tB^[e[u𐶐܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        AbstractDataAccessObject dataaccessobject =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        // e[u폜
        try {
            this.deleteTable(databaseAccess, ALARM_FILTER_TABLE);
        } catch (SQLException e) {
            logger.info(
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                + " : " + e.getMessage());
        }

        try {
            // V[PXe[u폜
            this.dropSequence(
                databaseAccess,
                dataaccessobject.getDropAlarmFilterTableSequenceSQL());

            // f[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                dataaccessobject.getCreateAlarmFilterTableSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Alarm Filtere[u폜܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            AbstractDataAccessObject dataaccessobject =
                DatabaseAccessControlKind.getInstance().getDataAccessObject();
            this.deleteTable(databaseAccess, ALARM_FILTER_TABLE);

            // V[PXe[u폜
            this.dropSequence(
                databaseAccess,
                dataaccessobject.getDropAlarmFilterTableSequenceSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * A[tB^[e[uZbg܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void putAlarmFilter()
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // Date date = new Date();
            Calendar cal = Calendar.getInstance();
            Date date = cal.getTime();

            String nodename = ANY;
            String ipaddress = ANY;
            String alarmCode = ANY;
            String alarmLevel = ANY;
            String alarmMessage = ANY;
            String alarmConfirm = CONFIM;

            // String alarm_start_date = dateformat.format(date);
            String alarmStartDate = Long.toString(date.getTime());
            String alarmEndDate = ANY;

            // alarm filterlDBɊi[
            databaseAccess.executeUpdate(
                "insert into " + ALARM_FILTER_TABLE + "( " + NODENAME + ", "
                + IPADDRESS + ", " + ALARM_CODE + ", " + ALARM_LEVEL + ", "
                + ALARM_MESSAGE + "," + ALARM_CONFIRM + "," + ALARM_START_DATE
                + ", " + ALARM_END_DATE + " )" + " VALUES( " + "'" + nodename
                + "'," + "'" + ipaddress + "'," + "'" + alarmCode + "'," + "'"
                + alarmLevel + "'," + "'" + alarmMessage + "'," + "'"
                + alarmConfirm + "'," + " '" + alarmStartDate + "'," + " '"
                + alarmEndDate + "'" + ")");

            // databaseAccess.executeUpdate("commit");
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
                databaseAccess = null;
            }
        }
    }

    /**
     * A[tB^[e[uXV܂B
     *
     * @param alarmViewFilter A[tB^[
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void updateAlarmFilter(final AlarmViewFilter alarmViewFilter)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            String nodename = alarmViewFilter.getNodename();
            String ipaddress = alarmViewFilter.getIpaddress();
            String alarmCode = alarmViewFilter.getAlarmCode();
            String alarmLevel = alarmViewFilter.getAlarmLevel();
            String alarmMessage = alarmViewFilter.getAlarmMessage();
            String alarmConfirm = alarmViewFilter.getAlarmConfirm();
            String alarmStartDate = alarmViewFilter.getAlarmStartDate();
            String alarmEndDate = alarmViewFilter.getAlarmEndDate();

            String sql = "";

            sql = "UPDATE " + ALARM_FILTER_TABLE + " set " + NODENAME + "= "
                + "'" + nodename + "'," + IPADDRESS + "= " + "'" + ipaddress
                + "'," + ALARM_CODE + "= " + "'" + alarmCode + "',"
                + ALARM_LEVEL + "= " + "'" + alarmLevel + "'," + ALARM_MESSAGE
                + "= " + "'" + alarmMessage + "'," + ALARM_CONFIRM + "= " + "'"
                + alarmConfirm + "'," + ALARM_START_DATE + "= " + "'"
                + alarmStartDate + "'," + ALARM_END_DATE + "= " + "'"
                + alarmEndDate + "'" + " where " + ALARM_ID + "=" + alarmID;

            // alarm filterlDBɊi[
            databaseAccess.executeUpdate(sql);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
                databaseAccess = null;
            }
        }
    }

    /**
     * A[tB^[񃊃Xg擾܂B
     *
     * @return alarmFilterList A[tB^[񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public ArrayList findAll() throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList alarmFilterList = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            //sql̍쐬
            String sql = "SELECT * from " + ALARM_FILTER_TABLE;
            System.out.println(sql);
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);
            alarmFilterList = new ArrayList();

            while (rs.next()) {
                AlarmViewFilter alarmViewFilter = new AlarmViewFilter();

                alarmViewFilter.setNodename(rs.getObject(NODENAME).toString());
                alarmViewFilter.setIpaddress(
                    rs.getObject(IPADDRESS).toString());
                alarmViewFilter.setAlarmCode(
                    rs.getObject(ALARM_CODE).toString());
                alarmViewFilter.setAlarmLevel(
                    rs.getObject(ALARM_LEVEL).toString());
                alarmViewFilter.setAlarmMessage(
                    rs.getObject(ALARM_MESSAGE).toString());
                alarmViewFilter.setAlarmConfirm(
                    rs.getObject(ALARM_CONFIRM).toString());
                alarmViewFilter.setAlarmStartDate(
                    rs.getObject(ALARM_START_DATE).toString());

                if (rs.getObject(ALARM_END_DATE) != null) {
                    alarmViewFilter.setAlarmEndDate(
                        rs.getObject(ALARM_END_DATE).toString());
                } else {
                    alarmViewFilter.setAlarmEndDate(null);
                }

                alarmFilterList.add(alarmViewFilter);
            }

            return alarmFilterList;
        } catch (DatabaseConnectionException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } catch (SQLException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
        }
    }
}
