/*
 * Created on 2006/12/28
 *
 *
 *@Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;



public final class DBTableDatabaseWatcher extends DBTableBase {

    public static final String DATABASE_WATCHER_TABLE_NAME = "database_watcher";

    public static final String IPADDRESS = "ipAddress";

    public static final String USERNAME = "userName";

    public static final String PASSWORD = "password";

    public static final String JDBC_DRIVER = "jdbcDriver";

    public static final String DATABASE_NAME = "databaseName";

    public static final String CONNECT_URL = "connectURL";

    public static final String WATCHER_PERIOD = "watcherPeriod";
    
    public static final String DATABASE_SQL = "checkSql";
    
    public static final String ISQUERY = "isQuery";
    
    public static final String DATABASE_EXPECT = "expect";
    
    public static final String CURDATE = "curdate";

    public static final String QUERY_STRING = "Query";
    public static final String UPDATE_STRING = "Update";
    /* MO */
    private static Logger logger = null;


    private static final String DATABASE_WATCH_TABLE_ITEM =
        " (" 
        + USERNAME + " VARCHAR(255), " + PASSWORD + "  VARCHAR(255)," + JDBC_DRIVER
        + " VARCHAR(255)," + DATABASE_NAME + " VARCHAR(255)," + CONNECT_URL
        + " VARCHAR(255)," + IPADDRESS + " VARCHAR(255)," + WATCHER_PERIOD + " VARCHAR(255),"
        + DATABASE_SQL + " VARCHAR(255),"
        + ISQUERY + " VARCHAR(255),"
        + DATABASE_EXPECT + " VARCHAR(255),"
        + CURDATE + " " + AbstractDataAccessObject.TIMESTAMP + " )";


    private final DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * PrintMIBe[u𑀍삷VOgNX
     * CX^X𐶐܂B
     *
     */
    private DBTableDatabaseWatcher() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMP PrintMIB e[u𐶐܂B
     *
     * @param targetIpAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable()
        throws DatabaseConnectionException, SQLException {



        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, DATABASE_WATCHER_TABLE_NAME);

            // f[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                "CREATE TABLE " + DATABASE_WATCHER_TABLE_NAME
                + DATABASE_WATCH_TABLE_ITEM);


        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * SNMP Print MIB e[u폜
     *
     * @param targetIpAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable()
        throws DatabaseConnectionException, SQLException {
       

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, DATABASE_WATCHER_TABLE_NAME);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * wm[hIP AddressPrint MIB񃊃XgԂ܂B
     *
     * @param tragetIpAddress m[hIPAhX
     * @return nodeIfList Interface MIB񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized DatabaseWatcherInfo findDatabaseWatcher(
        final String tragetIpAddress)
        throws SQLException, DatabaseConnectionException {


        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        DatabaseWatcherInfo databaseInfo = null;

        try {
            //sql̍쐬
            String sql =
                "SELECT * from " + DATABASE_WATCHER_TABLE_NAME
                + " where " + IPADDRESS + "=" + "'" + tragetIpAddress + "'";

            // SQLXe[ggIuWFNg̍쐬
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {

            	databaseInfo = new DatabaseWatcherInfo();
            	databaseInfo.setDatabaseUser(rs.getObject(USERNAME).toString());
            	databaseInfo.setDatabasePassword(rs.getObject(PASSWORD).toString());
            	databaseInfo.setDatabaseDriver(rs.getObject(JDBC_DRIVER).toString());
            	databaseInfo.setDatabaseName(
                    rs.getObject(DATABASE_NAME).toString());
            	databaseInfo.setDatabaseUrl(
                        rs.getObject(CONNECT_URL).toString());
                databaseInfo.setWatcherPeriod(rs.getObject(WATCHER_PERIOD).toString());
                databaseInfo.setDatabaseSQL(rs.getObject(DATABASE_SQL).toString());
                String isQuery = rs.getObject(ISQUERY).toString();
                if(isQuery.equals(QUERY_STRING)) {
                	databaseInfo.setQuery(true);
                } else {
                	databaseInfo.setQuery(false);
                }
                databaseInfo.setDatabaseExpect(rs.getObject(DATABASE_EXPECT).toString());
                break;

            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }

        return databaseInfo;
    }

    /**
     * Print MIBCfbNXɃf[^x[XɊi[܂B
     *
     * @param tragetIpAddress IPAhX
     * @param interfacesList PrintMIBi[Xgzň
     * ziXgjOIDɑΉAXgɂ̓CfbNX̒li[
     * Ă
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾
     * oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void putDatabaseWatcher(
        final String tragetIpAddress, final DatabaseWatcherInfo databaseInfo)
        throws DatabaseConnectionException, SQLException {


        String isQuery;
        if(databaseInfo.isQuery()) {
        	isQuery = QUERY_STRING;
        } else {
        	isQuery = UPDATE_STRING;
        }
        Date date = Calendar.getInstance().getTime();

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        String sql = "";
        try {
            	                            
                if (
                    DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                 .equals(
                            AbstractDataAccessObject.DERBY)
                        || DatabaseAccessControlKind.getInstance()
                                                        .getDatabaseName()
                                                        .equals(
                            AbstractDataAccessObject.EMBEDDED_DERBY)) {
                	sql = "insert into " 
                    + DATABASE_WATCHER_TABLE_NAME + "( " + IPADDRESS  + ", " + USERNAME
                    + ", " + PASSWORD + ", " + JDBC_DRIVER + ", " + DATABASE_NAME
                    + ", " + CONNECT_URL + ", " + WATCHER_PERIOD + ", "
                    + DATABASE_SQL + ", "
                    + ISQUERY + ", "
                    + DATABASE_EXPECT + ", "
                    + CURDATE + " )"
                    + " VALUES( " + "'"
                    + tragetIpAddress + "'," + "'"
                    + databaseInfo.getDatabaseUser() + "'," + "'"
                    + databaseInfo.getDatabasePassword() + "'," + "'"
                    + databaseInfo.getDatabaseDriver() + "'," + "'"
                    + databaseInfo.getDatabaseName() + "'," + "'"
                    + databaseInfo.getDatabaseUrl() + "'," + "'"
                    + databaseInfo.getWatcherPeriod() + "'," + "'"
                    + databaseInfo.getDatabaseSQL() + "'," + "'"
                    + isQuery + "'," + "'"
                    + databaseInfo.getDatabaseExpect() + "'," + "'"
                    + simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                } else {
                	sql = "insert into "
                    + DATABASE_WATCHER_TABLE_NAME + "( " + IPADDRESS + ", " + USERNAME
                    + ", " + PASSWORD + ", " + JDBC_DRIVER + ", " + DATABASE_NAME
                    + ", " + CONNECT_URL + ", " + WATCHER_PERIOD + ", "
                    + DATABASE_SQL + ", "
                    + ISQUERY + ", "
                    + DATABASE_EXPECT + ", "
                    +  CURDATE + " )"
                    + " VALUES( " + "'"

                    + tragetIpAddress + "'," + "'"
                    + databaseInfo.getDatabaseUser() + "'," + "'"
                    + databaseInfo.getDatabasePassword() + "'," + "'"
                    + databaseInfo.getDatabaseDriver() + "'," + "'"
                    + databaseInfo.getDatabaseName() + "'," + "'"
                    + databaseInfo.getDatabaseUrl() + "'," + "'"
                    + databaseInfo.getWatcherPeriod() + "'," + "'"
                    + databaseInfo.getDatabaseSQL() + "'," + "'"
                    + isQuery + "'," + "'"
                    + databaseInfo.getDatabaseExpect() + "'," + "'"
                    + simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                }

        } catch (SQLException ex) {
            logger.warning(ex.getMessage() + " IP=" + tragetIpAddress + " SQL=" + sql);
            throw ex;
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " IP=" + tragetIpAddress + " SQL=" + sql);
            throw e;
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Print MIBXV܂B
     * Print MIB񂪕ωꍇɂ́AA[ʒm܂B
     *
     * @param tragetIpAddress IPAhX
     * @param interfacesArrayList Listz̈OIDɑΉAz񖈂
     * IndexɑΉPrintMIB񂪓
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void updateDatabaseWatcher(
        final String tragetIpAddress, final DatabaseWatcherInfo databaseInfo)
        throws DatabaseConnectionException, SQLException {

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {

            updateDatabaseWatcherTabel(
                databaseAccess, tragetIpAddress, databaseInfo);
        } catch (SQLException ex) {
            logger.warning(ex.getMessage() + " IP=" + tragetIpAddress);
            ex.printStackTrace();
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
            e.printStackTrace();
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }


    /**
     * PrintMIBe[uXV܂B
     *
     * @param databaseAccess f[^x[XANZXIuWFNg
     * @param interfacesArrayList PrintMIBi[Xg
     * @param ipaddressTablename e[u
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void updateDatabaseWatcherTabel(
        DatabaseAccess databaseAccess, final String tragetIpAddress, final DatabaseWatcherInfo databaseInfo)
        throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();

        String isQuery;
        if(databaseInfo.isQuery()) {
        	isQuery = QUERY_STRING;
        } else {
        	isQuery = UPDATE_STRING;
        }
            if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.DERBY)
                    || DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                    .equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                databaseAccess.executeUpdate(
                    "UPDATE " + DATABASE_WATCHER_TABLE_NAME
                    + " set "
                    
                    + IPADDRESS + "='"
                    + tragetIpAddress + "', "
                    + USERNAME + "='"
                    + databaseInfo.getDatabaseUser() + "', "
                    + PASSWORD + "='"
                    + databaseInfo.getDatabasePassword() + "', "
                    + JDBC_DRIVER + "='"
                    + databaseInfo.getDatabaseDriver() + "', "
                    + DATABASE_NAME + "='"
                    + databaseInfo.getDatabaseName() + "', "
                    + CONNECT_URL + "='"
                    + databaseInfo.getDatabaseUrl() + "', "
                    + WATCHER_PERIOD + "='"
                    + databaseInfo.getWatcherPeriod() + "', "                  
                    + DATABASE_SQL + "='"
                    + databaseInfo.getDatabaseSQL() + "', "
                    + ISQUERY + "='"
                    + isQuery + "', "   
                    + DATABASE_EXPECT + "='"
                    + databaseInfo.getDatabaseExpect() + "', "   
                    
                    + CURDATE + "='"
                    + simpleDateformat.format(date) + "'"
                    + " where " + IPADDRESS + "=" + "'" + tragetIpAddress + "'"
                    + " ");
            } else {
                databaseAccess.executeUpdate(
                    "UPDATE " + DATABASE_WATCHER_TABLE_NAME
                    + " set " + IPADDRESS + "='"
                    + tragetIpAddress + "', "
                    + USERNAME + "='"
                    + databaseInfo.getDatabaseUser() + "', "
                    + PASSWORD + "='"
                    + databaseInfo.getDatabasePassword() + "', "
                    + JDBC_DRIVER + "='"
                    + databaseInfo.getDatabaseDriver() + "', "
                    + DATABASE_NAME + "='"
                    + databaseInfo.getDatabaseName() + "', "
                    + CONNECT_URL + "='"
                    + databaseInfo.getDatabaseUrl() + "', "
                    + WATCHER_PERIOD + "='"
                    + databaseInfo.getWatcherPeriod() + "', "                  
                    + DATABASE_SQL + "='"
                    + databaseInfo.getDatabaseSQL() + "', "
                    + ISQUERY + "='"
                    + isQuery + "', "   
                    + DATABASE_EXPECT + "='"
                    + databaseInfo.getDatabaseExpect() + "', "  
                    + CURDATE + "='"
                    + simpleDateformat.format(date) + "'"
                    + " where " + IPADDRESS + "=" + "'" + tragetIpAddress + "'"
                    + " ");
                
            }
        
    }

    /**
     * Printe[ȗSĂIndex폜܂B
     * ́APrint܂́AIndexԍωꍇŁA
     * e[uXVoȂ̂ňUAe[u폜čēxA
     * e[u邽߂ɌĂ΂܂B
     *
     *
     * @param tragetIpAddress m[hIPAhX
     * @param preOidList O̎悵OIDCX^XXg
     * @return
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void deleteDatabaseWatcherNodeIP(
        final String tragetIpAddress)
        throws DatabaseConnectionException, SQLException {

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
                String sql = "";
                //sql̍쐬
                sql = "DELETE from " + DATABASE_WATCHER_TABLE_NAME
                    + " where " + IPADDRESS + "=" + "'" + tragetIpAddress + "'";
                databaseAccess.executeUpdate(sql);           
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }



    /**
     * VOgNXCX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static DBTableDatabaseWatcher getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTableDatabaseWatcher RESOURCE = new DBTableDatabaseWatcher();
    }
}
