/*
 * Created on 2004/04/08
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.SQLException;

import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;



/**
 * m[hĎsXV郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 *@@version 1.0
 */
public final class LastCheckTimeUpDate {
    /**
     * m[hĎŐVXVVOgNXCX^X
     * 𐶐܂B
     *
     */
    private LastCheckTimeUpDate() {
    }

    /**
     * m[hĎŐVXVCX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static LastCheckTimeUpDate getInstance() {
        return SingletonResource.INSTANCE;
    }

    /**
     * m[hĎsŐVXV܂B
     *
     * @param ipaddress m[hIPAhX
     * @return isSuccess m[hĎsŐVXV
     * ̃tO
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized boolean updateCheckTime(final String ipaddress)
        throws DatabaseConnectionException, SQLException {
        /* XVʃtO */
        boolean isSuccess = false;

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            DBTableNodeRegister noderegister =
                DBTableNodeRegister.getInstance();
            noderegister.upDateLastCheck(ipaddress);
            isSuccess = true;
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }

        return isSuccess;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final LastCheckTimeUpDate INSTANCE = new LastCheckTimeUpDate();
    }
}
