/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model.hsqldb;

import java.util.ArrayList;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.engine.resource.DatabasePropertyResource;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;


/**
 * HSQLDB̃p[^ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class HsqldbParams {
    /* HSQLDB jdbchCo */
    private String driver = HsqldbPreference.HSQLDB_DRIVER;

    /* HSQLDB URL */
    private String accessUrl =
        HsqldbPreference.HSQLDB_URL + HsqldbPreference.P_PORT;

    /* HSQLDBڑ|[g */
    private String port = HsqldbPreference.P_PORT;

    /* HSQLDB[U */
    private String user = HsqldbPreference.P_USER;

    /* HSQLDBpX[h */
    private String passwd = HsqldbPreference.P_PASSWD;

    /*
     * HSQLDB̃p[^ێNXCX^X𐶐܂B
     */
    private HsqldbParams() {
        setHSQLDBParam();
    }

    /*
     * HSQLDBp[^Zbg܂B
     *
     */
    private void setHSQLDBParam() {
        /*  */
        ArrayList databasePropList =
            DatabasePropertyResource.getInstance().getdatabasePropList()
                                    .getDatabasePropList();

        for (int i = 0; i < databasePropList.size(); i++) {
            DatabasePropertyInfo info =
                (DatabasePropertyInfo) databasePropList.get(i);

            if (info.getDatabaseName().equals(AbstractDataAccessObject.HSQLDB)) {
                String url = info.getDatabaseUrl();
                String[] spilUrl = url.split(":");
                String workPort = HsqldbPreference.P_PORT;

                if (spilUrl.length > 0) {
                    String work = spilUrl[spilUrl.length - 1];
                    int pos = work.indexOf("/");

                    if (pos > 0) {
                        workPort = work.substring(0, pos);
                    } else {
                        workPort = work;
                    }
                }

                /* HSQLDB jdbchCo */
                driver = info.getDatabaseDriver();

                /* HSQLDB URL */
                accessUrl = info.getDatabaseUrl();

                /* HSQLDB Port */
                port = workPort;

                /* HSQLDB[U */
                user = info.getDatabaseUser();

                /* HSQLDBpX[h */
                passwd = info.getDatabasePassword();
            }
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static HsqldbParams getInstance() {
        return SingletonResource.HSQLDB_PARAM;
    }

    /**
     * HSQLDBhCoԂ܂B
     *
     * @return driver HSQLDBhCo
     */
    public String getDriver() {
        return driver;
    }

    /**
     * HSQLDB URLԂ܂B
     *
     * @return accessUrl HSQLDB URL
     */
    public String getAccessUrl() {
        return accessUrl;
    }

    /**
     * HSQLDB|[gԍԂ܂B
     *
     * @return port HSQLDB|[gԍ
     */
    public String getPort() {
        return port;
    }

    /**
     * HSQLDB[UԂ܂B
     *
     * @return user HSQLDB[U
     */
    public String getUser() {
        return user;
    }

    /**
    * HSQLDBpX[hԂ܂B
    *
    * @return passwd HSQLDBpX[h
    */
    public String getPasswd() {
        return passwd;
    }

    /*
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private static class SingletonResource {
        static final HsqldbParams HSQLDB_PARAM = new HsqldbParams();
    }
}
