/*
 * Created on 2004/07/18
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.control;

import netjfwatcher.engine.command.model.CommandAlarmControl;
import netjfwatcher.engine.command.model.CommandAlarmFilter;
import netjfwatcher.engine.command.model.CommandDatabasePropertyGet;
import netjfwatcher.engine.command.model.CommandDatabaseTest;
import netjfwatcher.engine.command.model.CommandGarbageCollection;
import netjfwatcher.engine.command.model.CommandGetNodeSnmp;
import netjfwatcher.engine.command.model.CommandInterfaceData;
import netjfwatcher.engine.command.model.CommandInterfaceMib;
import netjfwatcher.engine.command.model.CommandMailSendTest;
import netjfwatcher.engine.command.model.CommandMibGet;
import netjfwatcher.engine.command.model.CommandMibSet;
import netjfwatcher.engine.command.model.CommandNetworkCamera;
import netjfwatcher.engine.command.model.CommandNetworkPrinter;
import netjfwatcher.engine.command.model.CommandNodeAdd;
import netjfwatcher.engine.command.model.CommandNodeDelete;
import netjfwatcher.engine.command.model.CommandNodeEdit;
import netjfwatcher.engine.command.model.CommandNodeInformationGet;
import netjfwatcher.engine.command.model.CommandNodeMapLinkInormationGet;
import netjfwatcher.engine.command.model.CommandPing;
import netjfwatcher.engine.command.model.CommandResourceGet;
import netjfwatcher.engine.command.model.CommandResourceSet;
import netjfwatcher.engine.command.model.CommandSnmpStatisticsInfo;
import netjfwatcher.engine.command.model.CommandStatisticsMibDelete;
import netjfwatcher.engine.command.model.CommandStatisticsMibEdit;
import netjfwatcher.engine.command.model.CommandStatisticsMibGet;
import netjfwatcher.engine.command.model.CommandStatisticsMibSet;
import netjfwatcher.engine.command.model.CommandSystemMibGet;
import netjfwatcher.engine.command.model.CommandTaskScheduleCancel;
import netjfwatcher.engine.command.model.CommandTaskScheduleGet;
import netjfwatcher.engine.command.model.CommandTaskScheduleSet;
import netjfwatcher.engine.command.model.CommandXMLSocketState;


/**
* R}hR[hɑΉR}hCX^XMapping
* NXłB
*
* @author Yoshimasa Matsumoto
* @version 1.0
*/
public class CommandMappingTable {
    /* R}hIDɑΉR}hCX^X̔z */
    private static final Object[][] COMMAND_MAPPING_TABLE =
        {
            { CommandMappingTableResource.MIBGET_COMMAND_ID, new CommandMibGet() },
            { CommandMappingTableResource.MIBSET_COMMAND_ID, new CommandMibSet() },
            {
                CommandMappingTableResource.NODE_INFORMATION_COMMAND_ID,
                new CommandNodeInformationGet()
            },
            {
                CommandMappingTableResource.NODE_GET_SNMP_COMMAND_ID,
                new CommandGetNodeSnmp()
            },
            {
                CommandMappingTableResource.NODE_MAPLINK_COMMAND_ID,
                new CommandNodeMapLinkInormationGet()
            },
            {
                CommandMappingTableResource.ALARM_INFORMATION_COMMAND_ID,
                new CommandAlarmControl()
            },
            {
                CommandMappingTableResource.ALARM_FILTER_COMMAND_ID,
                new CommandAlarmFilter()
            },
            { CommandMappingTableResource.PING_COMMAND_ID, new CommandPing() },
            {
                CommandMappingTableResource.THREAD_START_COMMAND_ID,
                new CommandNodeAdd()
            },
            {
                CommandMappingTableResource.THREAD_STOP_COMMAND_ID,
                new CommandNodeDelete()
            },
            {
                CommandMappingTableResource.THREAD_RESTART_COMMAND_ID,
                new CommandNodeEdit()
            },
            {
                CommandMappingTableResource.SNMP_STATISTICS_INFO_COMMAND_ID,
                new CommandSnmpStatisticsInfo()
            },
            {
                CommandMappingTableResource.SYSTEM_MIB_GET_COMMAND_ID,
                new CommandSystemMibGet()
            },
            {
                CommandMappingTableResource.INTERFACE_MIB_GET_COMMAND_ID,
                new CommandInterfaceMib()
            },
            {
                CommandMappingTableResource.TASK_SCHEDULE_CONTROL_COMMAND_ID,
                new CommandTaskScheduleSet()
            },
            {
                CommandMappingTableResource.TASK_SCHEDULE_GET_COMMAND_ID,
                new CommandTaskScheduleGet()
            },
            {
                CommandMappingTableResource.TASK_SCHEDULE_CANCEL_COMMAND_ID,
                new CommandTaskScheduleCancel()
            },
            {
                CommandMappingTableResource.XMLSOCKET_STATE_COMMAND_ID,
                new CommandXMLSocketState()
            },
            {
                CommandMappingTableResource.INTERFACE_DATA_GET_COMMAND_ID,
                new CommandInterfaceData()
            },
            {
                CommandMappingTableResource.STATISTICS_MIB_GET_COMMAND_ID,
                new CommandStatisticsMibGet()
            },
            {
                CommandMappingTableResource.STATISTICS_MIB_SET_COMMAND_ID,
                new CommandStatisticsMibSet()
            },
            {
                CommandMappingTableResource.STATISTICS_MIB_EDIT_COMMAND_ID,
                new CommandStatisticsMibEdit()
            },
            {
                CommandMappingTableResource.STATISTICS_MIB_DELETE_COMMAND_ID,
                new CommandStatisticsMibDelete()
            },
            {
                CommandMappingTableResource.GARBAGECOLLECTION_COMMAND_ID,
                new CommandGarbageCollection()
            },
            {
                CommandMappingTableResource.RESOURCE_GET_COMMAND_ID,
                new CommandResourceGet()
            },
            {
                CommandMappingTableResource.RESOURCE_SET_COMMAND_ID,
                new CommandResourceSet()
            },
            {
                CommandMappingTableResource.MAIL_SEND_TEST_COMMAND_ID,
                new CommandMailSendTest()
            },
            {
                CommandMappingTableResource.DATABASE_PROPERTY_GET_COMMAND_ID,
                new CommandDatabasePropertyGet()
            },
            {
                CommandMappingTableResource.DATABASE_TEST_COMMAND_ID,
                new CommandDatabaseTest()
            },
            {
                CommandMappingTableResource.NETWORK_PRINTER_COMMAND_ID,
                new CommandNetworkPrinter()
            },
            {
                CommandMappingTableResource.NETWORK_CAMERA_COMMAND_ID,
                new CommandNetworkCamera()
            }
        };

    /** R}hɑΉAckX|XR[h */
    public static final String ACK_RESPONSE = "ACK";

    /** R}hɑΉNackX|XR[h */
    public static final String NACK_RESPONSE = "NACK";

    /**
     * R}h}bsOe[uԂ܂B<BR>
     *
     * @return commandMappingTable R}h}bsOe[u
     */
    public Object[][] getCommandMappingTable() {
        return COMMAND_MAPPING_TABLE;
    }
}
