/*
 * Created on 2003/08/02
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.control;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.CommandInfo;


/**
 * WebAvP[ṼR}hMpXbhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class CommnadReceiveServer extends AbstractConnectClientCheck
    implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /* R}hM|[g */
    private int port;

    /* R}hMThread */
    private Thread commandReceiveServerThread;

    /* ServerSocket */
    private ServerSocket socketListener;

    /* VXe\[X */
    private SystemResourceFileParse resourceInfo;

    /* ڑzXg */
    private String allowHost;

    /**
     * R}hMThreadNXCX^X𐶐܂B
     *
     */
    private CommnadReceiveServer() {
        logger = Logger.getLogger(this.getClass().getName());

        /* \[X񂩂R}hM|[g𒊏oAZbg */
        resourceInfo =
            (SystemResourceConfig.getInstance()).getResourceFileParse();
        this.port =
            Integer.parseInt(resourceInfo.getResourceInfo().getEnginePort());
        logger.info("Command receive PORT : " + port);

        allowHost = resourceInfo.getResourceInfo().getEngineAllowHost();
    }

    /**
     * R}hMThreadN܂B
     *
     * @throws IOException R}hMpServerSocket
     * sꍇ
     */
    public void startThread() throws IOException {
        socketListener = new ServerSocket(port);
        socketListener.setSoTimeout(0);

        commandReceiveServerThread = new Thread(this);
        commandReceiveServerThread.start();
    }

    /**
     * R}hMThread~܂B
     *
     */
    public void stopReceiving() {
        if (commandReceiveServerThread == null) {
            return;
        }

        // interrupt receive thread so it will die a natural death
        commandReceiveServerThread.interrupt();

        if (socketListener != null) {
            try {
                socketListener.close();
            } catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }

            /* Thread~܂Loop */
            while (
                (commandReceiveServerThread != null)
                    && commandReceiveServerThread.isAlive()) {
                try {
                    Thread.sleep(WAIT_SLEEP_TIME);
                } catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }

            socketListener = null;
        }

        commandReceiveServerThread = null;
    }

    /**
     * R}hM҂󂯂܂B
     *
     */
    public void run() {
        try {
            while (true) {
                /* R}hM҂ */
                Socket socket = socketListener.accept();

                if (checkAllowHost(socket)) {
                    logger.info(
                        "Connect address : "
                        + socket.getInetAddress().getHostAddress());

                    Thread thread = new Thread(new CommandReceiveThread(socket));
                    thread.start();
                }
            }
        } catch (BindException ex) {
            logger.warning("BindException: Address already in use : " + port);
        } catch (IOException ex) {
            logger.warning("ServerReceive IOException");
        } finally {
            try {
                if ((socketListener != null) && !socketListener.isClosed()) {
                    socketListener.close();
                }
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private boolean checkAllowHost(Socket socket) {
        logger.info(
            "Accept Address : " + socket.getInetAddress().getHostAddress()
            + " : port :" + socket.getLocalPort());
        logger.info("allowHost : " + allowHost);

        // socket.setKeepAlive(true);

        /* ڑIP Address */
        String remoteIPAddress = socket.getInetAddress().getHostAddress();
        logger.info("Connect remote IP Address : " + remoteIPAddress);

        /*
         * ڑClientł邩`FbN
         */
        boolean isAllowClient = checkHost(allowHost, remoteIPAddress);

        if (!isAllowClient) {
            /* Client ڑ */
            try {
                socket.close();
            } catch (IOException e) {
                logger.warning("Reject socket close error" + e.getMessage());
                e.printStackTrace();
            }

            return false;
        } else {
            /* Clientڑ󂯓
             * 󂯓ꂽڑpXbh𐶐EJn
             * Local IP Addressy PORT
             */
            return true;
        }
    }

    /**
     * ServerSocketN[Y܂B
     *
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (socketListener != null) {
            socketListener.close();
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static CommnadReceiveServer getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * R}hMThreadԂ܂B
     *
     * @return commandReceiveServerThread R}hMThread
     */
    public Thread getCommandReceiveThread() {
        return commandReceiveServerThread;
    }

    /**
     * R}hMɋNXbhNXłB
     * R}hR[hɑΉ鏈N܂B
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private static class CommandReceiveThread implements Runnable {
        private Socket socket;
        private ObjectInputStream ois = null;
        private ObjectOutputStream oos = null;
        private BufferedInputStream bis = null;
        private BufferedOutputStream bos = null;

        /**
         * R}hMThreadCX^X𐶐܂B
         *
         * @param commandSocket Socket
         */
        protected CommandReceiveThread(Socket commandSocket) {
            this.socket = commandSocket;
        }

        /**
         *
         */
        public void run() {
            logger.info(Thread.currentThread().getName());

            CommandInfo com = null;

            try {
                bis = new BufferedInputStream(socket.getInputStream());
                ois = new ObjectInputStream(bis);

                bos = new BufferedOutputStream(socket.getOutputStream());
                oos = new ObjectOutputStream(bos);

                com = (CommandInfo) ois.readObject();

                logger.info("Receive command : " + com.getCode());

                ControllerCommand command = ControllerCommand.getInstance();
                command.execute(com.getCode(), com, ois, oos);
            } catch (EOFException ex) {
                logger.warning("EOF Detect " + ex.getMessage());
            } catch (IOException ex) {
                logger.warning("IOException " + ex.getMessage());
                ex.printStackTrace();
            } catch (ClassNotFoundException ex) {
                logger.warning("ClassNotFoundException " + ex.getMessage());
                ex.printStackTrace();
            } catch (Exception ex) {
                logger.warning("Exception " + ex.getMessage());
                ex.printStackTrace();
            } finally {
                if (ois != null) {
                    try {
                        ois.close();
                    } catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }

                    ois = null;
                }

                if (bis != null) {
                    try {
                        bis.close();
                    } catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }

                    bis = null;
                }

                if (oos != null) {
                    try {
                        oos.close();
                    } catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }

                    oos = null;
                }

                if (bos != null) {
                    try {
                        bos.close();
                    } catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }

                    bos = null;
                }

                if (socket != null) {
                    try {
                        socket.close();
                    } catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }

                    socket = null;
                }

                com = null;
            }
        }

        /* ( Javadoc)
             * @see java.lang.Object#finalize()
             */
        protected void finalize() throws Throwable {
            super.finalize();
            ois.close();
            bis.close();
            oos.close();
            bos.close();
            socket.close();
        }
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final CommnadReceiveServer RESOURCE = new CommnadReceiveServer();
    }
}
