/*
 * Created on 2004/04/06
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.NodeInformation;


/**
 * m[hĎ̕ҏWsNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandNodeEdit extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * m[hĎ̕ҏWs܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        String responseCode = CommandMappingTableResource.ACK_RESPONSE;
        NodeEdit nodeedit = NodeEdit.getInstance();

        if (com.getNodeInformationList() != null) {
            ArrayList nodeInfoList = com.getNodeInformationList();

            for (int i = 0; i < nodeInfoList.size(); i++) {
                NodeInformation nodeInfo =
                    (NodeInformation) nodeInfoList.get(i);

                if (nodeInfo.getSnmpVersion().equals("SNMPV3")) {
                    if (
                        SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                               .getSnmpV3AgentInfo(
                                nodeInfo.getIpaddress()) == null) {
                        responseCode =
                            "Not found SNMP V3 Agent Address = "
                            + nodeInfo.getIpaddress();
                        logger.warning(responseCode);
                        sendResponse(responseCode, ois, oos);

                        continue;
                    }
                }

                try {
                    nodeedit.editNodeInfo(nodeInfo);
                } catch (DatabaseConnectionException e) {
                    logger.warning(
                        "DatabaseConnectionException : " + e.getMessage());
                    responseCode =
                        "DatabaseConnectionException : " + e.getMessage();
                } catch (SQLException e) {
                    logger.warning("SQLException : " + e.getMessage());
                    responseCode = "SQLException : " + e.getMessage();
                }
            }
        } else {
            logger.info("Edit Node IP=" + com.getIpaddress());

            NodeInformation nodeInfo = com.getNodeInformation();

            if (nodeInfo.getSnmpVersion().equals("SNMPV3")) {
                if (
                    SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                           .getSnmpV3AgentInfo(
                            com.getIpaddress()) == null) {
                    responseCode =
                        "Not found SNMP V3 Agent Address = "
                        + com.getIpaddress();
                    logger.warning(responseCode);
                    sendResponse(responseCode, ois, oos);

                    return;
                }
            }

            nodeedit.editNodeInfo(com);
        }

        sendResponse(responseCode, ois, oos);
    }
}
