/*
 * Created on 2004/12/15
 *
 *
 *
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.info.NodeInformation;


/**
 * m[hĎ̎悷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandNodeInformationGet extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * m[hĎ̎悵܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        NodeInformation nodeInfo = com.getNodeInformation();

        DBTableNodeRegister nodeRegisterDBTable =
            DBTableNodeRegister.getInstance();
        ArrayList list = null;

        try {
            if (
                nodeInfo.getSubCommand().equals(
                        ConnectionNodeInformation.NODE_INFORMATION)) {
                list = nodeRegisterDBTable.findTarget(com.getIpaddress());
            } else if (
                nodeInfo.getSubCommand().equals(
                        ConnectionNodeInformation.NODE_INFORMATION_LIST)) {
                list =
                    nodeRegisterDBTable.getNodeInfoList(
                        nodeInfo.getSortColumn(), nodeInfo.getSortDirection());
            }
        } catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (Exception e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            nodeRegisterDBTable = null;
        }

        sendResponse(list, ois, oos);
    }
}
