package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;


/**
 * Apache DerbyɊւANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderApacheDerby {
    /* MO */
    private static Logger logger;

    /* Apache Derby ThreadNANV */
    private IAction startApacheDerby = new ActionStartApacheDerbyThread();

    /* Apache Derby Thread~ANV */
    private IAction stopApacheDerby = new ActionStopApacheDerbyThread();

    /* EmbeddedApacheDerbyNANV */
    private IAction startEmbeddedApacheDerby =
        new ActionStartEmbeddedApacheDerbyThread();

    /* EmbeddedApacheDerby~ANV */
    private IAction stopEmbeddedApacheDerby =
        new ActionStopEmbeddedApacheDerbyThread();

    /* Apache Derby SysInfo̎ANV */
    private IAction sysInfoApacheDerby = new ActionSysInfoApacheDerby();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     *
     */
    public ActionBuilderApacheDerby() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Apache DerbyNANVNXCX^XԂ܂B
     *
     * @return startApacheDerby Apache DerbyNANV
     */
    public IAction getActionStartApacheDerby() {
        return startApacheDerby;
    }

    /**
     * Apache Derby~ANVNXCX^XԂ܂B
     *
     * @return stopApacheDerby Apache Derby~ANV
     */
    public IAction getActionStopApacheDerby() {
        return stopApacheDerby;
    }

    /**
     * ApacheDerby SysInfo̎ANVԂ܂B
     *
     * @return sysInfoApacheDerby ApacheDerby SysInfo̎ANV
     */
    public IAction getActionSysInfoApacheDerby() {
        return sysInfoApacheDerby;
    }

    /**
     * EmbeddedApacheDerbyNANVԂ܂B
     *
     * @return startEmbeddedApacheDerby EmbeddedApacheDerbyNANV
     */
    public IAction getActionEmbeddedStartApacheDerby() {
        return startEmbeddedApacheDerby;
    }

    /**
     * Apache Derby~ANVNXCX^XԂ܂B
     *
     * @return stopEmbeddedApacheDerby Apache Derby~ANV
     */
    public IAction getActionEmbeddedStopApacheDerby() {
        return stopEmbeddedApacheDerby;
    }

    /**
     * f[^x[XɊւANVNXłB
     *
     *
     */
    private abstract class AbstractDatabaseAction extends Action {
        public final void run() {
            doTask();
        }

        protected abstract void doTask();
    }

    /**
     * Apache DerbyT[őNsANVB
     */
    private final class ActionStartApacheDerbyThread
        extends AbstractDatabaseAction {
        /**
         * Apache DerbyT[oNANṼACRImageDescriptorԂ܂B
         *
         * @return Apache DerbyT[őNANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.APACHE_DERBY_START_IMAGE_FILE));
        }

        /**
         * Apache DerbyT[oNANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.APACHE_DERBY_START;
        }

        /**
         * Apache DerbyT[oNANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.APACHE_DERBY_START_TOOL_TIP;
        }

        /**
         * Apache DerbyT[őNs܂B
         *
         */
        protected void doTask() {
            logger.info("Apache Derby Start task");

            try {
                ApacheDerbyNetworkServer.getInstance().startDerbyNetworkServer();
            } catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Error", "Abort start Apache Derby "
                    + e.getMessage());
                shell.dispose();
            }
        }
    }

    /**
     * Apache DerbyT[o~ANVłBB
     */
    private final class ActionStopApacheDerbyThread
        extends AbstractDatabaseAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.APACHE_DERBY_STOP_IMAGE_FILE));
        }

        /**
         * Apache DerbyT[o~ANṼj[LqԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.APACHE_DERBY_STOP;
        }

        /**
         * Apache DerbyT[o~ANVToolTipText̕Ԃ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.APACHE_DERBY_STOP_TOOL_TIP;
        }

        /**
         * Apache DerbyT[o~܂B
         *
         */
        protected void doTask() {
            logger.info("Apache Derby shutdown");

            try {
                ApacheDerbyNetworkServer.getInstance().stopDerbyNetworkServer();
            } catch (Exception e) {
                e.printStackTrace();

                Shell shell = new Shell();
                MessageDialog.openError(shell, "Error", e.getMessage());
                shell.dispose();
            }
        }
    }

    /**
     * Apache Derby SysInfo̎ANVłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionSysInfoApacheDerby extends AbstractDatabaseAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.APACHE_DERBY_SYSINFO_IMAGE_FILE));
        }

        /**
         * Apache DerbyT[o~ANṼj[LqԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.APACHE_DERBY_SYSINFO;
        }

        /**
         * Apache DerbyT[o~ANVToolTipText̕Ԃ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.APACHE_DERBY_SYSINFO_TOOL_TIP;
        }

        /**
         * Apache DerbyT[o~܂B
         *
         */
        protected void doTask() {
            logger.info("Apache Derby Sys Info");

            try {
                ApacheDerbyNetworkServer.getInstance().getSysInfoNetworkServer();
            } catch (Exception e) {
                e.printStackTrace();

                Shell shell = new Shell();
                MessageDialog.openError(shell, "Error", e.getMessage());
                shell.dispose();
            }
        }
    }

    /**
     * EmbeddedApacheDerbyNANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @value 1.0
     */
    private final class ActionStartEmbeddedApacheDerbyThread
        extends AbstractDatabaseAction {
        /**
         * Apache DerbyT[oNANṼACRImageDescriptorԂ܂B
         *
         * @return Embedded Apache DerbyT[őNANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.APACHE_DERBY_START_IMAGE_FILE));
        }

        /**
         * Embedded Apache DerbyT[oNANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.EMBEDDED_APACHE_DERBY_START;
        }

        /**
         * Embedded Apache DerbyT[oNANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.EMBEDDED_APACHE_DERBY_START_TOOL_TIP;
        }

        /**
         * Apache DerbyT[őNs܂B
         *
         */
        protected void doTask() {
            logger.info("Embedded Apache Derby Start task");

            try {
                ApacheDerbyEmbeddedDerby.getInstance().startEmbeddedDerby();
            } catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openInformation(
                    shell, "Apache Derby Status", e.getMessage());
                shell.dispose();
            }
        }
    }

    /**
     * Apache DerbyT[o~ANVłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionStopEmbeddedApacheDerbyThread
        extends AbstractDatabaseAction {
        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.APACHE_DERBY_STOP_IMAGE_FILE));
        }

        /**
         * Apache DerbyT[o~ANṼj[LqԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.EMBEDDED_APACHE_DERBY_STOP;
        }

        /**
         * Apache DerbyT[o~ANVToolTipText̕Ԃ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.EMBEDDED_APACHE_DERBY_STOP_TOOL_TIP;
        }

        /**
         * Apache DerbyT[o~܂B
         *
         */
        protected void doTask() {
            logger.info("Embedded Apache Derby shutdown");

            try {
                ApacheDerbyEmbeddedDerby.getInstance().stopEmbeddedDerby();
            } catch (Exception e) {
                e.printStackTrace();

                Shell shell = new Shell();
                MessageDialog.openError(shell, "Error", e.getMessage());
                shell.dispose();
            }
        }
    }
}
