package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.nodedetect.EditorAutoNodeDetect;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;


/**
 * m[hoɊւANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNodeDetect extends Action {
    /*
     * OIEditorParti[(ANVɈUClose邽)
     */
    private static IEditorPart editorNodeConfigView;

    /* MO */
    private static Logger logger;

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /* m[hor[\ANV */
    private IAction nodeDetectView = new ActionAutoNodeDetectView();

    /**
     * m[hoɊւANVNXCX^X𐶐܂B
     *
     */
    public ActionBuilderNodeDetect() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hor[\ANVԂ܂B
     *
     * @return showNodeView m[h̍\`\ANV
     */
    public IAction getActionNodeDetectView() {
        return nodeDetectView;
    }

    /**
     * m[hoɊւANV`钊ۃNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractNodeDetectAction extends Action {
        /**
         * ANVs܂B
         */
        public final void run() {
            doTask();
        }

        /**
         * ANVs^XNłB
         *
         */
        protected abstract void doTask();

        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/usearch_obj.gif"));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Node Discovery";
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "Node Discovery";
        }
    }

    /**
     * m[h̍\`\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public final class ActionAutoNodeDetectView extends AbstractNodeDetectAction {
        /**
         * m[h̎or[\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                /*
                 * IꂽGg̃m[hURLEditorɃuEU
                 * I[v
                 * EditorID̓uEŨNX
                 */
                activePage.openEditor(
                    new EditorInputNodeView(
                        EditorAutoNodeDetect.TITLE_SUFFIX, false),
                    EditorAutoNodeDetect.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
