/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.node.EditorNodeConfig;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;


/**
 * m[hTree ViewTreeIXi[NXłB
 * IꂽTreẽm[hViewOpen܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ListenerNodeListTree implements ISelectionChangedListener {
    /* MO */
    private static Logger logger = null;

    /* lbg[NoRŏ擾邩ۂtO */
    private boolean isSocket;

    /**
     * m[hTree ViewTreeIXi[NXCX^X𐶐܂B
     *
     * @param isSocket lbg[NoRŏ擾邩ۂtO
     */
    public ListenerNodeListTree(boolean isSocket) {
        logger = Logger.getLogger(this.getClass().getName());
        this.isSocket = isSocket;
    }

    /**
     * e[uViewɃtB[hꗗőIGg͒lƂĐݒ肵A
     * ̃Cxg_@ƂWebɃANZX܂B
     *
     * @param event SelectionChangedEvent
     */
    public void selectionChanged(SelectionChangedEvent event) {
        // IGg擾
        StructuredSelection ss = (StructuredSelection) event.getSelection();

        // m[hGroup̏ꍇɂ̓uEUopenreturn
        logger.info("Tree node  select : " + ss.getFirstElement());

        if (ss.getFirstElement() instanceof NodeTreeGroup) {
            logger.info("NodeTreeGroup ");

            return;
        } else if (!(ss.getFirstElement() instanceof NodeTree)) {
            logger.info("No NodeTree ");

            return;
        }

        final NodeTree entry = (NodeTree) ss.getFirstElement();
        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        /*
         * IꂽGg̃m[hURLEditorɃuEU
         * I[v
         * EditorID̓uEŨNX
         */
        try {
            if (!isSocket) {
                activePage.openEditor(
                    new EditorInputNodeView(
                        entry.getName() + EditorNodeConfig.TITLE_SUFFIX,
                        entry.getNodeInfo(), isSocket),
                    EditorNodeConfig.class.getName());
            } else {
                activePage.openEditor(
                    new EditorInputNodeView(
                        entry.getName() + EditorNodeConfig.TITLE_SUFFIX
                        + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(),
                        entry.getNodeInfo(), isSocket),
                    EditorNodeConfig.class.getName());
            }
        } catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}
