/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.thread;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmpmanager.trap.ITrapListener;
import netjfwatcher.snmpmanager.trap.TrapDispatcher;



/**
 * TrapMThreadNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class TrapReceiveThread extends DataStringDisplay implements Runnable {
    /* MO */
    private static Logger logger;

    /* TrapMDatagramSocket */
    private DatagramSocket dSocket;

    /* TrapMThread */
    private Thread trapReceiveThread;

    /* TrapMXi[i[List */
    private List<ITrapListener> listenerList;

    /*
     * TRAPMpSocket𐶐AThread𐶐܂B<BR>
     *
     */
    private TrapReceiveThread() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * TrapMXi[Xgɓo^܂B
     *
     * @param listener TrapXi[
     */
    public void addTrapListener(ITrapListener listener) {
        // see if listener already added; if so, ignore
        for (int i = 0; i < listenerList.size(); i++) {
            if (listener == listenerList.get(i)) {
                return;
            }
        }

        // if got here, it's not in the list; add it
        listenerList.add(listener);
    }

    /**
     * TrapMXi[Xg폜܂B
     *
     * @param listener TrapXi[
     */
    public void removeTrapListener(ITrapListener listener) {
        // see if listener in list; if so, remove, if not, ignore
        for (int i = 0; i < listenerList.size(); i++) {
            if (listener == listenerList.get(i)) {
                listenerList.remove(i);

                break;
            }
        }
    }

    /**
     * Trap receive thread̏ԂԂ܂B
     *
     * @return Trap receive thread
     * true :ThreadN
     * false:Thread~
     */
    public boolean checkThread() {
        if ((trapReceiveThread == null) || !trapReceiveThread.isAlive()) {
            return false;
        }

        return true;
    }

    /**
     * TrapMThreadX^[g܂B
     *
     * @throws SocketException SocketɎsꍇ
     */
    public void startReceiving() throws SocketException {
        // TrapMXbhN̏ꍇɋN
        if ((trapReceiveThread == null) || !trapReceiveThread.isAlive()) {
            try {
                dSocket =
                    new DatagramSocket(
                        SystemResourceConfig.getInstance().getResourceFileParse()
                                            .getResourceInfo().getSnmpTrapPort());
                listenerList = Collections.synchronizedList(new LinkedList<ITrapListener>());
                trapReceiveThread = new Thread(this);
            } catch (SocketException e) {
                /* TrapMsockets */
                logger.warning(e.getMessage());
                e.printStackTrace();
                throw e;
            }

            if (trapReceiveThread != null) {
                trapReceiveThread.start();
            }
        }
    }

    /**
     * TrapMXbh~܂B
     *
     */
    public void stopReceiving() {
        // interrupt receive thread so it will die a natural death
        if (trapReceiveThread != null) {
            trapReceiveThread.interrupt();
            trapReceiveThread = null;
        }

        if (dSocket != null) {
            dSocket.close();

            /* TrapMThread~܂Loop */
            while ((trapReceiveThread != null) && trapReceiveThread.isAlive()) {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }

            dSocket = null;
        }

        logger.info("Trap thread stop");
        trapReceiveThread = null;
    }

    /**
     * TrapM҂XbhłB
     * ۂTrapMSNMP VersioñfBXpb`[ōs܂
     *
     */
    public void run() {
        logger.info("Trap receive start");

        while (
            (trapReceiveThread != null) && !trapReceiveThread.isInterrupted()) {
            /*
             * TrapM҂yTrap SNMP VersionɑΉɃfBXpb`[
             */
            TrapDispatcher dispPatcher = new TrapDispatcher();

            try {
                dispPatcher.disptcher(dSocket, listenerList);
            } catch (SocketException e) {
                if ((dSocket == null) || dSocket.isClosed()) {
                    /* Thread stopwɂꍇɂُ͈ƂȂ */
                    logger.info(
                        "Trap Receive Socket closed : " + e.getMessage());
                } else {
                    logger.warning("Trap receive error : " + e.getMessage());
                    e.printStackTrace();
                }
            } catch (GeneralSecurityException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();

                // break;
            } catch (SnmpV3ConfigurationException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();

                // break;
            } catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();

                // break;
            } catch (SnmpV3DecryptAbortException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();

                // break;
            } catch (IOException e) {
                /* TrapM҂Shutdown(퓮)yTrap
                     * MNs
                     */
                logger.warning(e.getMessage());

                break;
            }
        }

        logger.info("Trap receive Thread interrupt!!");
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static TrapReceiveThread getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * TrapMThraedԂ܂B
     *
     * @return trapReceiveThread TrapMThraed
     */
    public Thread getTrapReceiveThread() {
        return trapReceiveThread;
    }

    /**
     * DatagramSocketN[Y܂B
     *
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (dSocket != null) {
            dSocket.close();
        }
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final TrapReceiveThread RESOURCE = new TrapReceiveThread();
    }
}
