/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger;

import netjfwatcher.engine.calendar.CalendarView;
import netjfwatcher.engine.nodemaneger.list.NodeListTableView;
import netjfwatcher.engine.nodemaneger.list.NodeListTreeView;
import netjfwatcher.engine.nodemaneger.map.NodeMapView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;



/**
 * m[h}l[WPerspectiveNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeManagerPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.engine.nodemaneger.NodeManagerPerspective";
    private static final float NODE_TREE_RATIO = 0.20f;
    private static final float NODE_LIST_RATIO = 0.40f;

    /**
     * PerspectivȅCAEgs܂B
     *
     * @param layout IPageLayout
     */
    public void createInitialLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(false);

        String editorArea = layout.getEditorArea();

        /* PerspectiveɃm[hTree */
        IFolderLayout left =
            layout.createFolder(
                "left", IPageLayout.LEFT, NODE_TREE_RATIO, editorArea);
        left.addView(NodeListTreeView.class.getName());
        left.addView(CalendarView.class.getName());
        /* Perspective㑤Ƀm[hListƃm[hMap  */
        IFolderLayout top =
            layout.createFolder(
                "top", IPageLayout.TOP, NODE_LIST_RATIO, editorArea);
        top.addView(NodeListTableView.class.getName());
        top.addView(NodeMapView.class.getName());
    }
}
