/*
 * Created on 2003/07/21
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodewatchinfo;

import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;


/**
 * m[hĎ̂߂̃vpeBێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeWatchInfo {
    /** SNMPVXeMIB̎抮R[h */
    public static final String SYSTEM_MIB_OK = "OK";

    /** SNMPVXeMIB̎斢R[h */
    public static final String SYSTEM_MIB_PENDING = "Pending";

    /** SNMPC^tF[XMIB̎抮R[h */
    public static final String INTERFACE_MIB_OK = "OK";

    /** SNMPC^tF[XMIB̎斢R[h */
    public static final String INTERFACE_MIB_PENDING = "Pending";

    /** SNMPvMIB̎抮R[h */
    public static final String STATISTICS_MIB_OK = "OK";

    /** SNMPvMIB̎斢R[h */
    public static final String STATISTICS_MIB_PENDING = "Pending";

    /** SNMP Print MIB̎抮R[h */
    public static final String PRINT_MIB_OK = "OK";

    /** SNMP Print MIB̎斢R[h */
    public static final String PRINT_MIB_PENDING = "Pending";
    
    /* m[h */
    private String nodename;

    /* m[hO[v */
    private String group;

    /* m[hIPAhX */
    private String ipaddress;

    /* m[h */
    private String nodeKind;
    
    /* SNMPo[W */
    private int snmpVersion;

    /* PingĎݒl */
    private String pingPeriod;

    /* PingĎJEgl */
    private String countPingPeriod;

    /* PingĎ臒l */
    private String pingThreshold;

    /* SNMPĎݒl */
    private String snmpPeriod;

    /* SNMPĎJEgl */
    private String countSnmpPeriod;

    /* SNMPĎx */
    private String snmpLevel;

    /* SNMP ReadR~jeB */
    private String snmpROCommunity;

    /* SNMP WriteR~jeB */
    private String snmpRWCommunity;

    /* HTTPĎURL */
    private String httpUrl;

    /* HTTPĎݒl */
    private String httpPeriod;

    /* HTTPĎ^CAEgl */
    private String httpTimeout;

    /* HTTPĎJEgl */
    private String countHttpPeriod;

    /* Pop3Ďݒl */
    private String popPeriod;

    /* Pop3ĎJEgl */
    private String countPopPeriod;

    /* Pop3Ď[U */
    private String popUser;

    /* Pop3ĎpX[h */
    private String popPassword;

    /* Pop3Ď|[g */
    private String popPort;

    /* Pop3Ď^CAEgl */
    private String popTimeout;

    /* SMTPĎݒl */
    private String smtpPeriod;

    /* SMTPĎ|[g */
    private String smtpPort;

    /* SMTPĎ^CAEgl */
    private String smtpTimeout;

    /* SMTPĎJE^ */
    private String countSmtpPeriod;

    /* SMTPĎ`FbNpMAhX */
    private String smtpTestAddress;

    /* SMTPĎmFpPop3zXg */
    private String smtpCheckPop3Host;

    /* SMTPĎmFpPop3[U */
    private String smtpCheckPop3User;

    /* SMTPĎmFpPop3pX[h */
    private String smtpCheckPop3Password;

    /* SMTPĎmFpPop3|[g */
    private String smtpCheckPop3Port;

    /* SMTPĎmFpPop3ڑ^CAEgl */
    private String smtpCheckPop3Timeout;

    /* System MIBi[e[u
     * OK      : System MIB̎ς
     * Pending : System MIB̎
     */
    private String systemMIBStatus;

    /* Interface MIBi[e[u */
    private String interfaceMIBStatus;

    /* Print MIBi[e[u */
    private String printMIBStatus;
    
    /* vMIBi[e[u */
    private String statisticsMIBStatus;

    /* f[^x[XĎ */
    private DatabaseWatcherInfo databaseWatcherInfo;

    /**
     * m[hIPAhXԂ܂B
     *
     * @return ipaddress m[hIPAhX
     */
    public String getIpaddress() {
        return ipaddress;
    }

    /**
     * m[hԂ܂B
     *
     * @return nodename m[h
     */
    public String getNodename() {
        return nodename;
    }

    /**
     * PingĎԂ܂B
     *
     * @return pingPeriod PingĎ
     */
    public String getPingPeriod() {
        return pingPeriod;
    }

    /**
     * PingĎ臒lԂ܂B
     *
     * @return pingThreshold PingĎ臒l
     */
    public String getPingThreshold() {
        return pingThreshold;
    }

    /**
     * SNMPĎxԂ܂B
     *
     * @return snmpLevel SNMPĎx
     */
    public String getSnmpLevel() {
        return snmpLevel;
    }

    /**
     * SNMPĎԂ܂B
     *
     * @return snmpPeriod SNMPĎ
     */
    public String getSnmpPeriod() {
        return snmpPeriod;
    }

    /**
     * m[hIPAhXZbg܂B
     *
     * @param string m[hIPAhX
     */
    public void setIpaddress(final String string) {
        ipaddress = string;
    }

    /**
     * m[hZbg܂B
     *
     * @param string m[h
     */
    public void setNodename(final String string) {
        nodename = string;
    }

    /**
     * PingĎZbg܂B
     *
     * @param string PingĎ
     */
    public void setPingPeriod(final String string) {
        pingPeriod = string;
    }

    /**
     * PingĎ臒lZbg܂B
     *
     * @param string PingĎ臒l
     */
    public void setPingThreshold(final String string) {
        pingThreshold = string;
    }

    /**
     * SNMPĎxZbg܂B
     *
     * @param string SNMPĎx
     */
    public void setSnmpLevel(final String string) {
        snmpLevel = string;
    }

    /**
     * SNMPĎZbg܂B
     *
     * @param string SNMPĎ
     */
    public void setSnmpPeriod(final String string) {
        snmpPeriod = string;
    }

    /**
     * PingĎJE^Ԃ܂B
     *
     * @return countPingPeriod PingĎJE^
     */
    public String getCountPingPeriod() {
        return countPingPeriod;
    }

    /**
     * PingĎJE^Zbg܂B
     *
     * @param string PingĎJE^
     */
    public void setCountPingPeriod(final String string) {
        countPingPeriod = string;
    }

    /**
     * C^tF[XMIB̎ԂԂ܂B
     *
     * @return interfaceMIBStatus C^tF[XMIB̎
     */
    public String getInterfaceMIBStatus() {
        return interfaceMIBStatus;
    }

    /**
     * VXeMIB̎ԂԂ܂B
     *
     * @return systemMIBStatus VXeMIB̎
     */
    public String getSystemMIBStatus() {
        return systemMIBStatus;
    }

    /**
     * C^tF[XMIB̎ԂZbg܂B
     *
     * @param string C^tF[XMIB̎
     */
    public void setInterfaceMIBStatus(final String string) {
        interfaceMIBStatus = string;
    }

    /**
     * VXeMIB̎ԂZbg܂B
     *
     * @param string VXeMIB̎
     */
    public void setSystemMIBStatus(final String string) {
        systemMIBStatus = string;
    }

    /**
     * vMIB̎ԂԂ܂B
     *
     * @return statisticsMIBStatus vMIB̎
     */
    public String getStatisticsMIBStatus() {
        return statisticsMIBStatus;
    }

    /**
     * vMIB̎ԂZbg܂B
     *
     * @param string vMIB̎
     */
    public void setStatisticsMIBStatus(final String string) {
        statisticsMIBStatus = string;
    }

    /**
     * HTTPĎԂ܂B
     *
     * @return httpPeriod HTTPĎ
     */
    public String getHttpPeriod() {
        return httpPeriod;
    }

    /**
     * HTTPĎZbg܂B
     *
     * @return httpUrl HTTPĎ
     */
    public String getHttpUrl() {
        return httpUrl;
    }

    /**
     * Pop3ĎԂ܂B
     *
     * @return popPeriod Pop3Ď
     */
    public String getPopPeriod() {
        return popPeriod;
    }

    /**
     * SMTPĎԂ܂B
     *
     * @return smtpPeriod SMTPĎ
     */
    public String getSmtpPeriod() {
        return smtpPeriod;
    }

    /**
     * HTTPĎZbg܂B
     *
     * @param string HTTPĎ
     */
    public void setHttpPeriod(final String string) {
        httpPeriod = string;
    }

    /**
     * HTTPĎURLZbg܂B
     *
     * @param string HTTPĎURL
     */
    public void setHttpUrl(final String string) {
        httpUrl = string;
    }

    /**
     * Pop3ĎZbg܂B
     *
     * @param string Pop3Ď
     */
    public void setPopPeriod(final String string) {
        popPeriod = string;
    }

    /**
     * SMTPĎZbg܂B
     *
     * @param string SMTPĎ
     */
    public void setSmtpPeriod(final String string) {
        smtpPeriod = string;
    }

    /**
     * HTTPĎJE^Ԃ܂B
     *
     * @return countHttpPeriod HTTPĎJE^
     */
    public String getCountHttpPeriod() {
        return countHttpPeriod;
    }

    /**
     * Pop3ĎJE^Ԃ܂B
     *
     * @return countPopPeriod Pop3ĎJE^
     */
    public String getCountPopPeriod() {
        return countPopPeriod;
    }

    /**
     * SMTPĎJE^Ԃ܂B
     *
     * @return countSmtpPeriod SMTPĎJE^
     */
    public String getCountSmtpPeriod() {
        return countSmtpPeriod;
    }

    /**
     * HTTPĎJE^Zbg܂B
     *
     * @param string HTTPĎJE^
     */
    public void setCountHttpPeriod(final String string) {
        countHttpPeriod = string;
    }

    /**
     * Pop3ĎJE^Zbg܂B
     *
     * @param string Pop3ĎJE^
     */
    public void setCountPopPeriod(final String string) {
        countPopPeriod = string;
    }

    /**
     * SMTPĎJE^Zbg܂B
     *
     * @param string SMTPĎJE^
     */
    public void setCountSmtpPeriod(final String string) {
        countSmtpPeriod = string;
    }

    /**
     * SNMP ReadR~jeBԂ܂B
     *
     * @return snmpROCommunity SNMP ReadR~jeB
     */
    public String getSnmpROCommunity() {
        return snmpROCommunity;
    }

    /**
     * SNMP WriteR~jeBԂ܂B
     *
     * @return snmpRWCommunity SNMP WriteR~jeB
     */
    public String getSnmpRWCommunity() {
        return snmpRWCommunity;
    }

    /**
     * SNMPo[WԂ܂B
     *
     * @return snmpVersion SNMPo[W
     */
    public int getSnmpVersion() {
        return snmpVersion;
    }

    /**
     * SNMP ReadR~jeBZbg܂B
     *
     * @param string SNMP ReadR~jeB
     */
    public void setSnmpROCommunity(final String string) {
        snmpROCommunity = string;
    }

    /**
     * SNMP WriteR~jeBZbg܂B
     *
     * @param string SNMP WriteR~jeB
     */
    public void setSnmpRWCommunity(final String string) {
        snmpRWCommunity = string;
    }

    /**
     * SNMPo[WԂ܂B
     *
     * @param ver SNMPo[W
     */
    public void setSnmpVersion(final int ver) {
        snmpVersion = ver;
    }

    /**
     * SNMPĎJE^Ԃ܂B
     *
     * @return countSnmpPeriod  SNMPĎJE^
     */
    public String getCountSnmpPeriod() {
        return countSnmpPeriod;
    }

    /**
     * SNMPĎJE^Zbg܂B
     *
     * @param countSnmpPeriod SNMPĎJE^
     */
    public void setCountSnmpPeriod(final String countSnmpPeriod) {
        this.countSnmpPeriod = countSnmpPeriod;
    }

    /**
     * m[hO[vԂ܂B
     *
     * @return group m[hO[v
     */
    public String getGroup() {
        return group;
    }

    /**
     * m[hO[vZbg܂B
     *
     * @param group m[hO[v
     */
    public void setGroup(final String group) {
        this.group = group;
    }

    /**
     * Pop3ĎpX[hԂ܂B
     *
     * @return popPassword Pop3ĎpX[h
     */
    public String getPopPassword() {
        return popPassword;
    }

    /**
     * Pop3ĎpX[hZbg܂B
     *
     * @param popPassword Pop3ĎpX[h
     */
    public void setPopPassword(final String popPassword) {
        this.popPassword = popPassword;
    }

    /**
     * Pop3Ď[UԂ܂B
     *
     * @return popUser Pop3Ď[U
     */
    public String getPopUser() {
        return popUser;
    }

    /**
     * Pop3Ď[UZbg܂B
     *
     * @param popUser Pop3Ď[U
     */
    public void setPopUser(final String popUser) {
        this.popUser = popUser;
    }

    /**
     * SMTPmFpPop3zXgԂ܂B
     *
     * @return smtpCheckPop3Host SMTPmFpPop3zXg
     */
    public String getSmtpCheckPop3Host() {
        return smtpCheckPop3Host;
    }

    /**
     * SMTPmFpPop3zXgZbg܂B
     *
     * @param smtpCheckPop3Host SMTPmFpPop3zXg
     */
    public void setSmtpCheckPop3Host(final String smtpCheckPop3Host) {
        this.smtpCheckPop3Host = smtpCheckPop3Host;
    }

    /**
     * SMTPĎpX[hԂ܂B
     *
     * @return smtpCheckPop3Password SMTPĎpX[h
     */
    public String getSmtpCheckPop3Password() {
        return smtpCheckPop3Password;
    }

    /**
     * SMTPĎpX[hZbg܂B
     *
     * @param smtpCheckPop3Password SMTPĎpX[h
     */
    public void setSmtpCheckPop3Password(final String smtpCheckPop3Password) {
        this.smtpCheckPop3Password = smtpCheckPop3Password;
    }

    /**
     * SMTPĎ[UԂ܂B
     *
     * @return smtpCheckPop3User SMTPĎ[U
     */
    public String getSmtpCheckPop3User() {
        return smtpCheckPop3User;
    }

    /**
     * SMTPĎ[UZbg܂B
     *
     * @param smtpCheckPop3User SMTPĎ[U
     */
    public void setSmtpCheckPop3User(final String smtpCheckPop3User) {
        this.smtpCheckPop3User = smtpCheckPop3User;
    }

    /**
     * SMTPĎMAhXԂ܂B
     *
     * @return smtpTestAddress SMTPĎMAhX
     */
    public String getSmtpTestAddress() {
        return smtpTestAddress;
    }

    /**
     * SMTPĎMAhXZbg܂B
     *
     * @param smtpTestAddress SMTPĎMAhX
     */
    public void setSmtpTestAddress(final String smtpTestAddress) {
        this.smtpTestAddress = smtpTestAddress;
    }

    /**
     * Pop3Ď|[gԂ܂B
     *
     * @return popPort Pop3Ď|[g
     */
    public String getPopPort() {
        return popPort;
    }

    /**
     * Pop3Ď|[gZbg܂B
     *
     * @param popPort Pop3Ď|[g
     */
    public void setPopPort(final String popPort) {
        this.popPort = popPort;
    }

    /**
     * HTTPĎ^CAEglԂ܂B
     *
     * @return httpTimeout HTTPĎ^CAEgl
     */
    public String getHttpTimeout() {
        return httpTimeout;
    }

    /**
     * HTTPĎ^CAEglZbg܂B
     *
     * @param httpTimeout HTTPĎ^CAEgl
     */
    public void setHttpTimeout(final String httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    /**
     * Pop3Ď^CAEglԂ܂B
     *
     * @return popTimeout Pop3Ď^CAEgl
     */
    public String getPopTimeout() {
        return popTimeout;
    }

    /**
     * Pop3Ď^CAEglZbg܂B
     *
     * @param popTimeout Pop3Ď^CAEgl
     */
    public void setPopTimeout(final String popTimeout) {
        this.popTimeout = popTimeout;
    }

    /**
     * SMTPڑ|[gԂ܂B
     *
     * @return smtpPort SMTPڑ|[g
     */
    public String getSmtpPort() {
        return smtpPort;
    }

    /**
     * SMTPڑ|[gZbg܂B
     *
     * @param smtpPort SMTPڑ|[g
     */
    public void setSmtpPort(final String smtpPort) {
        this.smtpPort = smtpPort;
    }

    /**
     * SMTPڑ^CAEglԂ܂B
     *
     * @return smtpTimeout SMTPڑ^CAEgl
     */
    public String getSmtpTimeout() {
        return smtpTimeout;
    }

    /**
     * SMTPڑ^CAEglZbg܂B
     *
     * @param smtpTimeout SMTPڑ^CAEgl
     */
    public void setSmtpTimeout(final String smtpTimeout) {
        this.smtpTimeout = smtpTimeout;
    }

    /**
     * SMTPmFpPop3ڑ|[gԂ܂B
     *
     * @return smtpCheckPop3Port SMTPmFpPop3ڑ|[g
     */
    public String getSmtpCheckPop3Port() {
        return smtpCheckPop3Port;
    }

    /**
     * SMTPmFpPop3ڑ|[gZbg܂B
     *
     * @param smtpCheckPop3Port SMTPmFpPop3ڑ|[g
     */
    public void setSmtpCheckPop3Port(final String smtpCheckPop3Port) {
        this.smtpCheckPop3Port = smtpCheckPop3Port;
    }

    /**
     * SMTPmFpPop3Ď^CAEglԂ܂B
     *
     * @return smtpCheckPop3Timeout SMTPmFpPop3Ď^CAEgl
     */
    public String getSmtpCheckPop3Timeout() {
        return smtpCheckPop3Timeout;
    }

    /**
     * SMTPmFpPop3Ď^CAEglZbg܂B
     *
     * @param smtpCheckPop3Timeout  SMTPmFpPop3Ď^CAEgl
     */
    public void setSmtpCheckPop3Timeout(final String smtpCheckPop3Timeout) {
        this.smtpCheckPop3Timeout = smtpCheckPop3Timeout;
    }

	public String getNodeKind() {
		return nodeKind;
	}

	public void setNodeKind(String nodeKind) {
		this.nodeKind = nodeKind;
	}

	public String getPrintMIBStatus() {
		return printMIBStatus;
	}

	public void setPrintMIBStatus(String printMIBStatus) {
		this.printMIBStatus = printMIBStatus;
	}

	public DatabaseWatcherInfo getDatabaseWatcherInfo() {
		return databaseWatcherInfo;
	}

	public void setDatabaseWatcherInfo(DatabaseWatcherInfo databaseWatcherInfo) {
		this.databaseWatcherInfo = databaseWatcherInfo;
	}
}
