/*
 * Created on 2004/05/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodewatchinfo;

import java.util.HashMap;

import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;



/**
 * Ďm[hSNMPv̎ێNXłB
 * ̎悷OID̈ȉێ܂B
 * (1) G[WFgIPAhX
 * (2) R~jeB
 * (3) SNMPĎx
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class StatisticsMibInfo {
    /* m[hIPAhX */
    private String targetIpAddress;

    /* m[h */
    private String nodeName;

    /* SNMPo[W */
    private int version;

    /* R~jeB */
    private String community;

    /* SNMP̎惌x */
    private String snmpLevel;

    // OIDKeyƂāAMIB̎ێMap
    private HashMap oidList = new HashMap();

    /**
     * vMIB̎NXCX^X𐶐܂B
     *
     * @param targetIpAddress m[hIPAhX
     */
    private StatisticsMibInfo(String targetIpAddress) {
        this.targetIpAddress = targetIpAddress;
    }

    /**
     * wm[hIPAhXɑΉ铝vMIB̎NXCX^X
     * Ԃ܂B
     *
     * @param targetIpAddress m[hIPAhX
     * @return vMIB̎NXCX^X
     */
    public static StatisticsMibInfo getInstance(String targetIpAddress) {
        StatisticsMibInfo mibNode = null;
        mibNode =
            ListQueueStatisticsMibControl.getInstance().getStatisticsMibGetNode(
                targetIpAddress);

        if (mibNode == null) {
            mibNode = new StatisticsMibInfo(targetIpAddress);
        }

        return mibNode;
    }

    /**
     * vMIB̎Zbg܂B
     *
     * @param oid OID
     * @param oidInfo MIB̎
     */
    public void updateOid(String oid, OidGetInfo oidInfo) {
        oidList.put(oid, oidInfo);
    }

    /**
     * vMIB̎폜܂B
     *
     * @param oid OID
     */
    public void removeOid(String oid) {
        oidList.remove(oid);
    }

    /**
     * w̓vMIB̎Zbg܂B
     *
     * @param oid OID
     * @param getMibPeriod ̎
     * @param threshHold 臒l
     * @param type Ď^Cv
     */
    public void setOidList(
        String oid, String getMibPeriod, String threshHold, String type) {
        OidGetInfo oidInfo = new OidGetInfo();
        oidInfo.setTargetIpAddress(targetIpAddress);
        oidInfo.setVersion(version);
        oidInfo.setROCommunity(community);

        oidInfo.setTargetOid(oid);
        oidInfo.setGetMibPeriod(getMibPeriod);
        oidInfo.setCountGetMibPeriod(getMibPeriod);
        oidInfo.setThreshHold(threshHold);
        oidInfo.setThreshHoldType(type);

        // Xgɒǉ
        oidList.put(oid, oidInfo);
    }

    /**
     * w̓vOID̎XV܂B
     *
     * @param oid OID
     * @param getMibPeriod ̎
     * @param threshHold 臒l
     * @param type Ď^Cv
     */
    public void updateOidList(
        String oid, String getMibPeriod, String threshHold, String type) {
        OidGetInfo oidGetInfo = new OidGetInfo();
        oidGetInfo.setTargetIpAddress(targetIpAddress);
        oidGetInfo.setVersion(version);
        oidGetInfo.setROCommunity(community);

        oidGetInfo.setTargetOid(oid);
        oidGetInfo.setGetMibPeriod(getMibPeriod);
        oidGetInfo.setCountGetMibPeriod(getMibPeriod);
        oidGetInfo.setThreshHold(threshHold);
        oidGetInfo.setThreshHoldType(type);

        //
        oidList.put(oid, oidGetInfo);
    }

    /**
     * SNMPR~jeBԂ܂B
     *
     * @return community SNMPR~jeB
     */
    public String getCommunity() {
        return community;
    }

    /**
     * SNMP̎惌xԂ܂B
     *
     * @return snmpLevel SNMP̎惌x
     */
    public String getSnmpLevel() {
        return snmpLevel;
    }

    /**
     * m[hIPAhXԂ܂B
     *
     * @return targetIpAddress m[hIPAhX
     */
    public String getTargetIpAddress() {
        return targetIpAddress;
    }

    /**
     * SNMPR~jeBZbg܂B
     *
     * @param string SNMPR~jeB
     */
    public void setCommunity(final String string) {
        community = string;
    }

    /**
     * SNMP̎惌xZbg܂B
     *
     * @param string SNMP̎惌x
     */
    public void setSnmpLevel(final String string) {
        snmpLevel = string;
    }

    /**
     * SNMPv̎OID MapԂ܂B
     *
     * @return oidList SNMPv̎OID Map
     */
    public HashMap getOidList() {
        return oidList;
    }

    /**

    /**
     * SNMPv̎OID MapZbg܂B
     *
     * @param map SNMPv̎OID Map
     */
    public void setOidList(final HashMap map) {
        oidList = map;
    }

    /**
     * SNMPo[WԂ܂B
     *
     * @return SNMPo[W
     */
    public int getVersion() {
        return version;
    }

    /**
     * SNMPo[WZbg܂B
     *
     * @param ver SNMPo[W
     */
    public void setVersion(final int ver) {
        version = ver;
    }

    /**
     * m[hԂ܂B
     *
     * @return nodeName m[h
     */
    public String getNodeName() {
        return nodeName;
    }

    /**
     * m[hZbg܂B
     *
     * @param nodeName m[h
     */
    public void setNodeName(final String nodeName) {
        this.nodeName = nodeName;
    }
}
