/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;



/**
 * EnginevtFXy[Wp钊ۃNXłB
 * EnginevtFXy[WŎ郁\bh`܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
abstract public class AbstractEnginePreferancePage extends PreferencePage
    implements IWorkbenchPreferencePage {
    /* MO */
    private static Logger logger;

    /**
     * PreferencePagepNXŎׂ\bhłB
     *
     * @param parent Composite
     * @return Control
     */
    abstract protected Control createContents(Composite parent);

    /**
    *@wBufferedWriteryDocumentXML Fileɏo͂܂B
    *
    * @param bufWriter
    * @param dom
    */
    public void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        logger = Logger.getLogger(this.getClass().getName());

        /*
         * qGgeGg2wAGgԂ̉s
                * w͂ȂiXMLt@CŌXsĂ邽߁j
                */

        // XMLOutputter outputter = new XMLOutputter("  ", true);
        XMLOutputter outputter =
            XMLOutputterFormat.getInstance().getXMLOutputterFormat();

        // XMLOutputter outputter = new XMLOutputter();
        // outputter.setIndent("  ");
        FileWriter writer = null;

        try {
            outputter.output(dom, System.out);
            outputter.output(dom, bufWriter);
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    /**
     * \[Xt@Cɏ݂܂B
     *
     * @param info \[X
     */
    protected void saveResourceXMLInfo(ResourceInfo info) {
        // Document
        Document dom = null;

        // t@Co̓obt@
        BufferedWriter bufWriter = null;

        // SNMP\`XV
        dom = this.updateResource(info);
        bufWriter =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceFileWriter();

        // XMLt@Co
        this.outputXMLFile(bufWriter, dom);

        if (bufWriter != null) {
            try {
                bufWriter.close();
            } catch (IOException e) {
                logger.warning(
                    "Abort close BufferedWriter for snmp resource : "
                    + e.getMessage());
                e.printStackTrace();
            }
        }

        // FileɃCgɃCX^XXV
        SystemResourceConfig.getInstance().updateResourceset();
    }

    /**
     * \[XXV܂B
     *
     * @param info \[X
     * @return dom Document
     */
    protected Document updateResource(ResourceInfo info) {
        Document dom =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .updateDocument(info);

        return dom;
    }
}
