package netjfwatcher.engine.preferance;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.authentication.AuthenticationConfig;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;

public class AuthenticationPreferencePage extends AbstractEnginePreferancePage
		implements IWorkbenchPreferencePage {
	/* MO */
	private static Logger logger;

	/* eLXg */
	private static final int TEXT_WIDTH = 120;

	/* List widthhint */
	private static final int LIST_WIDTHHINT = 200;

	/* List verticalSpan */
	private static final int LIST_VERTIALSPAN = 7;

	/* List ItemHeight */
	private static final int LIST_ITEMHEIGHT = 8;

	/* zFColor` */
	private static Color whiteColor = new Color(null, 255, 255, 255);
	
	/* UserXg */
	private List userNameSelectList;

	/* Userǉ{^ */
	private Button addButton;

	/* UserҏW{^ */
	private Button editButton;

	/* User폜{^ */
	private Button deleteButton;

	/* User[NText */
	private Text userNameWorkText;

	/* pX[h[NText */
	private Text passwordWorkText;

	/* UserMap */
	private Map userNameMap;

	private Map userNamePreferenceMap;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
		logger = Logger.getLogger(this.getClass().getName());

		userNamePreferenceMap = AuthenticationConfig.getInstance()
				.getAuthInfo().getUserMap();

		userNameMap = Collections.synchronizedMap(new HashMap());

		// Initialize the preference store we wish to use
		// setPreferenceStore(RssrPlugin.getInstance().getPreferenceStore());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		Color textBackColor = whiteColor;

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout = new GridLayout(2, false);
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		Label label = new Label(composite, SWT.LEFT);
		label.setText("User Name List");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		userNameSelectList = new List(composite, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL);

		GridData data = new GridData();
		data.horizontalSpan = 2;
		data.verticalSpan = LIST_VERTIALSPAN;
		data.widthHint = LIST_WIDTHHINT;
		data.heightHint = userNameSelectList.getItemHeight() * LIST_ITEMHEIGHT;

		userNameSelectList.setLayoutData(data);

		addButton = new Button(composite, SWT.NONE);
		addButton.setText("Add");
		addButton.setLayoutData(new GridData());
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		label.setLayoutData(gridData);

		editButton = new Button(composite, SWT.NONE);
		editButton.setText("Edit");
		editButton.setLayoutData(new GridData());
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		label.setLayoutData(gridData);

		deleteButton = new Button(composite, SWT.NONE);
		deleteButton.setText("Delete");
		deleteButton.setLayoutData(new GridData());
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		label.setLayoutData(gridData);
		label = new Label(composite, SWT.NONE);
		label.setText("User Name");
		gridData = new GridData();
		label.setLayoutData(gridData);

		userNameWorkText = new Text(composite, SWT.BORDER);
		userNameWorkText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		userNameWorkText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Password");
		gridData = new GridData();
		label.setLayoutData(gridData);

		passwordWorkText = new Text(composite, SWT.BORDER | SWT.PASSWORD);
		passwordWorkText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		passwordWorkText.setLayoutData(gridData);

		initShowXMLSocketProp();

		setListener();

		return composite;
	}

	/*
	 * ListenerZbg܂B
	 * 
	 */
	private void setListener() {
		userNameSelectList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int index = userNameSelectList.getSelectionIndex();
				if (index < 0) {
					return;
				}

				userNameWorkText.setText(userNameSelectList.getItem(index));
				String password = (String) userNameMap.get(userNameWorkText
						.getText());
				if (password != null) {
					passwordWorkText.setText(password);
				}

			}
		});

		addButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (!userNameWorkText.getText().equals("")
						&& !passwordWorkText.getText().equals("")) {
					if (!userNameMap.containsKey(userNameWorkText.getText())) {
						userNameMap.put(userNameWorkText.getText(),
								passwordWorkText.getText());
						showXMLSocketProp();
					} else {
						MessageDialog.openError(getShell(), "Error",
								"Already User Name = "
										+ userNameWorkText.getText());

						return;
					}
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		editButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (!userNameWorkText.getText().equals("")
						&& !passwordWorkText.getText().equals("")) {
					if (userNameMap.containsKey(userNameWorkText.getText())) {

						for (Iterator it = userNameMap.entrySet().iterator(); it
								.hasNext();) {
							Map.Entry ent = (Map.Entry) it.next();
							String username = (String) ent.getKey();
							if (userNameWorkText.getText().equals(username)) {
								userNameMap.put(username, passwordWorkText
										.getText());
								break;
							}
						}

						showXMLSocketProp();
					} else {
						MessageDialog.openError(getShell(), "Error",
								"No Exit User Name = "
										+ userNameWorkText.getText());

						return;
					}
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		deleteButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (!userNameWorkText.getText().equals("")
						&& !passwordWorkText.getText().equals("")) {
					if (userNameMap.containsKey(userNameWorkText.getText())) {
						userNameMap.remove(userNameWorkText.getText());

						for (Iterator it = userNameMap.entrySet().iterator(); it
								.hasNext();) {
							Map.Entry ent = (Map.Entry) it.next();
							String userName = (String) ent.getKey();
							if (userNameWorkText.getText().equals(userName)) {
								userNameMap.remove(userName);
								break;
							}
						}

						showXMLSocketProp();
					} else {
						MessageDialog.openError(getShell(), "Error",
								"No Exit Engine Address = "
										+ userNameWorkText.getText());

						return;
					}
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	private void initShowXMLSocketProp() {
		userNameSelectList.removeAll();

		String userName = "";
		String password = "";
		userNameMap.clear();

		for (Iterator it = userNamePreferenceMap.entrySet().iterator(); it
				.hasNext();) {
			Map.Entry ent = (Map.Entry) it.next();

			userName = (String) ent.getKey();
			password = (String) userNamePreferenceMap.get(userName);

			userNameSelectList.add(userName);
			userNameMap.put(userName, password);
		}
		userNameWorkText.setText(userName);
		passwordWorkText.setText(password);

	}

	/*
	 * text\Zbg܂B
	 */
	private void showXMLSocketProp() {
		userNameSelectList.removeAll();

		String userName = "";
		String password = "";

		for (Iterator it = userNameMap.entrySet().iterator(); it.hasNext();) {
			Map.Entry ent = (Map.Entry) it.next();

			userName = (String) ent.getKey();
			password = (String) userNameMap.get(userName);

			userNameSelectList.add(userName);

		}
		userNameWorkText.setText(userName);
		passwordWorkText.setText(password);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults() {

		initShowXMLSocketProp();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	public boolean performOk() {

		saveAuthXMLInfo();

		return super.performOk();
	}

	private void saveAuthXMLInfo() {

		Document dom = AuthenticationConfig.getInstance().getAuthInfo()
				.updateDocument(userNameMap);
		BufferedWriter bufWriter = AuthenticationConfig.getInstance()
				.getAuthInfo().getResourceFileWriter();

		// XMLt@Co
		this.outputXMLFile(bufWriter, dom);

		if (bufWriter != null) {
			try {
				bufWriter.close();
			} catch (IOException e) {
				logger
						.warning("Abort close BufferedWriter : "
								+ e.getMessage());
				e.printStackTrace();
			}
		}

		// FileɃCgɃCX^XXV
		AuthenticationConfig.getInstance().updateAuthInfo();
	}
}
