/*
 * Created on 2007/02/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.view.canvas.CanvasViewConfigFileParse;
import netjfwatcher.engine.view.canvas.CanvasViewInfo;
import netjfwatcher.snmpmanager.preferences.AbstractSnmpPreferencePage;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;

public class CanvasPreferencePage extends AbstractSnmpPreferencePage {

	private static final int DEFAULT_CHART_WIDTH = 1400;

	private static final int DEFAULT_CHART_HEIGHT = 800;

	private static final int DEFAULT_CHART_X_SCALL = 1000;

	private static final int DEFAULT_CHART_Y_SCALL = 450;

	private static final int DEFAULT_NODE_MAP_WIDTH = 1900;

	private static final int DEFAULT_NODE_MAP_HEIGHT = 1700;

	private static final int TEXT_WIDTH = 200;

	private static final int HORIZONTAL_SPAN3 = 3;

	private Text chartWidthText;

	private Text chartHeightText;

	private Text chartXScallText;

	private Text chartYScallText;

	private Text nodeMapWidthText;

	private Text nodeMapHeightText;

	private int chart_width;

	private int chart_height;

	private int chart_x_scall;

	private int chart_y_scall;

	private int node_map_width;

	private int node_map_height;

	/* MO */
	private static Logger logger;

	public void init(IWorkbench workbench) {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * Rec𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 * @return Control
	 */
	protected Control createContents(Composite parent) {
		/* TextwiFZbg */
		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		Composite composite0 = new Composite(parent, SWT.NONE);

		/* ep[c3Ŕzu */
		GridLayout gridLayoutV3AgentProp = new GridLayout(HORIZONTAL_SPAN3, false);
		composite0.setLayout(gridLayoutV3AgentProp);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

		Label label = new Label(composite0, SWT.NONE);
		label.setText("Chart View Width");
		label.setLayoutData(new GridData());

		chartWidthText = new Text(composite0, SWT.BORDER);
		chartWidthText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		chartWidthText.setBackground(textBackColor);
		chartWidthText.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("Chart View Height");
		label.setLayoutData(new GridData());

		chartHeightText = new Text(composite0, SWT.BORDER);
		chartHeightText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		chartHeightText.setBackground(textBackColor);
		chartHeightText.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("Chart X Scall");
		label.setLayoutData(new GridData());

		chartXScallText = new Text(composite0, SWT.BORDER);
		chartXScallText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		chartXScallText.setBackground(textBackColor);
		chartXScallText.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("Chart Y Scall");
		label.setLayoutData(new GridData());

		chartYScallText = new Text(composite0, SWT.BORDER);
		chartYScallText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		chartYScallText.setBackground(textBackColor);
		chartYScallText.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("Node Map View Width");
		label.setLayoutData(new GridData());

		nodeMapWidthText = new Text(composite0, SWT.BORDER);
		nodeMapWidthText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		nodeMapWidthText.setBackground(textBackColor);
		nodeMapWidthText.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("Node Map View Height");
		label.setLayoutData(new GridData());

		nodeMapHeightText = new Text(composite0, SWT.BORDER);
		nodeMapHeightText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		nodeMapHeightText.setBackground(textBackColor);
		nodeMapHeightText.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		Composite entryTable = new Composite(parent, SWT.NULL);
		entryTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		setText();

		return entryTable;
	}

	private void setText() {

		chart_width = CanvasViewConfigFileParse.getInstance().getChartWidth();
		chart_height = CanvasViewConfigFileParse.getInstance().getChartHeight();
		chart_x_scall = CanvasViewConfigFileParse.getInstance()
				.getChartXScall();
		chart_y_scall = CanvasViewConfigFileParse.getInstance()
				.getChartYScall();

		node_map_width = CanvasViewConfigFileParse.getInstance()
				.getNodeMapWidth();
		node_map_height = CanvasViewConfigFileParse.getInstance()
				.getNodeMapHeight();

		chartWidthText.setText(Integer.toString(chart_width));
		chartHeightText.setText(Integer.toString(chart_height));
		chartXScallText.setText(Integer.toString(chart_x_scall));
		chartYScallText.setText(Integer.toString(chart_y_scall));

		nodeMapWidthText.setText(Integer.toString(node_map_width));
		nodeMapHeightText.setText(Integer.toString(node_map_height));
	}

	protected void performDefaults() {
		chartWidthText.setText(Integer.toString(DEFAULT_CHART_WIDTH));
		chartHeightText.setText(Integer.toString(DEFAULT_CHART_HEIGHT));
		chartXScallText.setText(Integer.toString(DEFAULT_CHART_X_SCALL));
		chartYScallText.setText(Integer.toString(DEFAULT_CHART_Y_SCALL));

		nodeMapWidthText.setText(Integer.toString(DEFAULT_NODE_MAP_WIDTH));
		nodeMapHeightText.setText(Integer.toString(DEFAULT_NODE_MAP_HEIGHT));
	}

	public boolean performOk() {

		CanvasViewInfo canvasViewInfo = new CanvasViewInfo();
		int value = checkText(chartWidthText);
		if (value > 0) {
			;
			canvasViewInfo.setChartWidth(value);
		} else {
			return false;
		}
		value = checkText(chartHeightText);
		if (value > 0) {
			;
			canvasViewInfo.setChartHeight(value);
		} else {
			return false;
		}
		value = checkText(chartXScallText);
		if (value > 0) {
			;
			canvasViewInfo.setChartXScall(value);
		} else {
			return false;
		}
		value = checkText(chartYScallText);
		if (value > 0) {
			;
			canvasViewInfo.setChartYScall(value);
		} else {
			return false;
		}
		value = checkText(nodeMapWidthText);
		if (value > 0) {
			;
			canvasViewInfo.setNodeMapWidth(value);
		} else {
			return false;
		}
		value = checkText(nodeMapHeightText);
		if (value > 0) {
			;
			canvasViewInfo.setNodeMapHeight(value);
		} else {
			return false;
		}
		saveCanvasInfo(canvasViewInfo);
		return super.performOk();
	}

	private int checkText(Text checkText) {
		int value = 0;
		try {
			value = Integer.parseInt(checkText.getText());
		} catch (Exception e) {
			MessageDialog.openError(getShell(), "Error", "Illegal data = "
					+ checkText.getText() + ".");
			checkText.setFocus();
		}
		return value;
	}

	private void saveCanvasInfo(CanvasViewInfo canvasViewInfo) {
		// Document
		Document dom = null;

		// t@Co̓obt@
		BufferedWriter bufWriter = null;

		dom = this.updateCanvasViewResource(canvasViewInfo);

		if (dom == null) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error",
					"Abort save Canvas View Info.");
			shell.dispose();

			return;
		}

		bufWriter = CanvasViewConfigFileParse.getInstance()
				.getResourceFileWriter();

		// XMLt@Co
		this.outputXMLFile(bufWriter, dom);

		if (bufWriter != null) {
			try {
				bufWriter.close();
			} catch (IOException e) {
				logger
						.warning("Abort close BufferedWriter for Alarm Trap resource : "
								+ e.getMessage());
				e.printStackTrace();
			}
		}

		// FileɃCgɃCX^XXV
		CanvasViewConfigFileParse.getInstance()
				.parseCanvasViewConfigFileParse();
	}

	private Document updateCanvasViewResource(CanvasViewInfo canvasViewInfo) {

		Document dom = CanvasViewConfigFileParse.getInstance().updateDocument(
				canvasViewInfo);

		return dom;
	}
}
