/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.common.view.TableListViewColor;

import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;



/**
 * ViewJ[vtFXy[WNXłB
 * View̕FAwiFȂǂǗ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ViewColorPreferancePage extends FieldEditorPreferencePage
    implements IWorkbenchPreferencePage {
    /** ViewJ[Preferancet@C */
    public static final String COLOR_PREFERENCE_FILE = "view_color.pref";

    /** A[G[xJ[ID */
    public static final String ALARM_ERROR_LEVEL_COLOR_NAME = "alarm_error";

    /** A[xxJ[ID */
    public static final String ALARM_WARNING_LEVEL_COLOR_NAME = "alarm_warning";

    /** A[񃌃xJ[ID */
    public static final String ALARM_INFO_LEVEL_COLOR_NAME = "alarm_info";

    /** m[hXgԍForgroundJ[ID */
    public static final String NODE_LIST_ODD_FORGROUND_COLOR_NAME =
        "node_list_odd_number_foreground";

    /** m[hXgԍBackgroundJ[ID */
    public static final String NODE_LIST_ODD_BACKGROUND_COLOR_NAME =
        "node_list_odd_number_background";

    /** m[hXgԍForgroundJ[ID */
    public static final String NODE_LIST_EVEN_FORGROUND_COLOR_NAME =
        "node_list_even_number_foreground";

    /** m[hXgԍBackgroundJ[ID */
    public static final String NODE_LIST_EVEN_BACKGROUND_COLOR_NAME =
        "node_list_even_number_background";

    /** m[hXgXe[^XJ[ID */
    public static final String NODE_LIST_STATUS_COLOR_NAME =
        "node_list_status_forground";

    /** ftHgA[G[xJ[ID */
    public static final String DEFAULT_ALARM_ERROR_LEVEL_COLOR = "255,0,0";

    /** ftHgA[xxJ[ID */
    public static final String DEFAULT_ALARM_WARNING_LEVEL_COLOR = "0,255,0";

    /** ftHgA[񃌃xJ[ID */
    public static final String DEFAULT_ALARM_INFO_LEVEL_COLOR = "0,0,0";

    /** ftHgm[hXgForgroundJ[ID */
    public static final String DEFAULT_NODE_LIST_ODD_FORGROUND_COLOR = "0,0,0";

    /** ftHgm[hXgBackgroundJ[ID */
    public static final String DEFAULT_NODE_LIST_ODD_BACKGROUND_COLOR =
        "255,255,255";

    /** ftHgm[hXgForgroundJ[ID */
    public static final String DEFAULT_NODE_LIST_EVEN_FORGROUND_COLOR = "0,0,0";

    /** ftHgm[hXgBackgroundJ[ID */
    public static final String DEFAULT_NODE_LIST_EVEN_BACKGROUND_COLOR =
        "128,255,255";

    /** ftHgm[hXgXe[^XJ[ID */
    public static final String DEFAULT_NODE_LIST_STATUS_COLOR = "255,128,64";

    /* MO */
    private static Logger logger;

    /** vt@XEXgA */
    private PreferenceStore prefStore;

    /** GfB^i[Xg */
    private final List editorsList = new ArrayList();

    /**
    *
    *
    */
    public ViewColorPreferancePage() {
        super(FieldEditorPreferencePage.FLAT);

        logger = Logger.getLogger(this.getClass().getName());
    }

    /*
     * @see IWorkbenchPreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        try {
            // vt@XXgA̍쐬
            this.prefStore = initPreferenceStore(COLOR_PREFERENCE_FILE);
        } catch (IOException e) {
            logger.warning(e.getMessage());
        }
    }

    /**
     * vt@XXgA𐶐E܂B
     *
     * @param filename t@C
     * @return vt@XXgA
     * @throws IOException t@CANZXɎsꍇ
     */
    private PreferenceStore initPreferenceStore(String filename)
        throws IOException {
        PreferenceStore localstore = new PreferenceStore(filename);

        // ftHglݒ
        localstore.setDefault(
            ALARM_ERROR_LEVEL_COLOR_NAME, DEFAULT_ALARM_ERROR_LEVEL_COLOR);
        localstore.setDefault(
            ALARM_WARNING_LEVEL_COLOR_NAME, DEFAULT_ALARM_WARNING_LEVEL_COLOR);
        localstore.setDefault(
            ALARM_INFO_LEVEL_COLOR_NAME, DEFAULT_ALARM_INFO_LEVEL_COLOR);

        localstore.setDefault(
            NODE_LIST_EVEN_FORGROUND_COLOR_NAME,
            DEFAULT_NODE_LIST_EVEN_FORGROUND_COLOR);
        localstore.setDefault(
            NODE_LIST_EVEN_BACKGROUND_COLOR_NAME,
            DEFAULT_NODE_LIST_EVEN_BACKGROUND_COLOR);
        localstore.setDefault(
            NODE_LIST_ODD_FORGROUND_COLOR_NAME,
            DEFAULT_NODE_LIST_ODD_FORGROUND_COLOR);
        localstore.setDefault(
            NODE_LIST_ODD_BACKGROUND_COLOR_NAME,
            DEFAULT_NODE_LIST_ODD_BACKGROUND_COLOR);
        localstore.setDefault(
            NODE_LIST_STATUS_COLOR_NAME, DEFAULT_NODE_LIST_STATUS_COLOR);

        // t@C̃[h
        File file = new File(filename);

        if (file.exists()) {
            localstore.load();
        }

        return localstore;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.preference.
     * FieldEditorPreferencePage#createFieldEditors()
     */
    protected void createFieldEditors() {
        // nothing
    }

    /*
     * y[WRec̐\bhI[o[Ch
     * @see org.eclipse.jface.preference.
     * PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
     */
    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        Group alarmListGroup = new Group(composite, SWT.NONE);
        alarmListGroup.setText("Alarm List Color");
        alarmListGroup.setLayout(new GridLayout(2, false));

        GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        alarmListGroup.setLayoutData(gridData);

        // FI
        registerEditor(
            new ColorFieldEditor(
                ALARM_ERROR_LEVEL_COLOR_NAME,
                "Alarm list error level select &Color", alarmListGroup));
        registerEditor(
            new ColorFieldEditor(
                ALARM_WARNING_LEVEL_COLOR_NAME,
                "Alarm list warning level select &Color", alarmListGroup));
        registerEditor(
            new ColorFieldEditor(
                ALARM_INFO_LEVEL_COLOR_NAME,
                "Alarm list infomation level select &Color", alarmListGroup));

        // dummy
        Label label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        Group nodeListGroup = new Group(composite, SWT.NONE);
        nodeListGroup.setText("Node List Color");
        nodeListGroup.setLayout(new GridLayout(2, false));
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        nodeListGroup.setLayoutData(gridData);

        registerEditor(
            new ColorFieldEditor(
                NODE_LIST_ODD_FORGROUND_COLOR_NAME,
                "Node list odd number foreground select &Color", nodeListGroup));
        registerEditor(
            new ColorFieldEditor(
                NODE_LIST_ODD_BACKGROUND_COLOR_NAME,
                "Node list odd number background select &Color", nodeListGroup));

        registerEditor(
            new ColorFieldEditor(
                NODE_LIST_EVEN_FORGROUND_COLOR_NAME,
                "Node list even number foreground select &Color", nodeListGroup));
        registerEditor(
            new ColorFieldEditor(
                NODE_LIST_EVEN_BACKGROUND_COLOR_NAME,
                "Node list even number background select &Color", nodeListGroup));

        registerEditor(
            new ColorFieldEditor(
                NODE_LIST_STATUS_COLOR_NAME,
                "Node list status forground select &Color", nodeListGroup));

        composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new FillLayout(SWT.HORIZONTAL));
        composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        return parent;
    }

    /* (non-Javadoc) override
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        for (int i = 0, n = editorsList.size(); i < n; i++) {
            FieldEditor ed = (FieldEditor) editorsList.get(i);

            if (ed.isValid()) {
                ed.loadDefault();
            }
        }

        super.performDefaults();
    }

    /*
     * OK{^͎̓I[o[Ch
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk() {
        storeAll();

        try {
            prefStore.save();

            TableListViewColor.getInstance().updateAlarmListColor();
            TableListViewColor.getInstance().updateNodeListColor();
        } catch (IOException e1) {
            e1.printStackTrace();
        }

        return true;
    }

    /**
     * VtB[hGfB^o^B
     *
     * @param ed GfB^
     */
    protected void registerEditor(FieldEditor ed) {
        editorsList.add(ed);
        ed.setPreferencePage(this);
        ed.setPreferenceStore(prefStore);
        ed.load();
    }

    /**
     * GfB^̕ύXXgAB
     * A͒lsȏꍇB
     */
    private void storeAll() {
        for (int i = 0, n = editorsList.size(); i < n; i++) {
            FieldEditor ed = (FieldEditor) editorsList.get(i);

            if (ed.isValid()) {
                ed.store();
            }
        }
    }
}
