/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * XML SocketɊւvtFXy[WNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class XMLSocketPreferancePage extends AbstractEnginePreferancePage
		implements IWorkbenchPreferencePage {

	private static final int TEXT_WIDTH = 200;

	private static Logger logger;

	private ResourceInfo resourceInfo;

	private Combo alertSoundCombo;

	private Text allowHostText;

	private Text xmlSocketPortText;

	private Text xmlSocketMaxConnectText;

	private Text alertSoundText;

	private Text refreshTimeText;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
		logger = Logger.getLogger(this.getClass().getName());

		// Initialize the preference store we wish to use
		setPreferenceStore(NetJFWatcherPlugin.getInstance()
				.getPreferenceStore());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		resourceInfo = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo();

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		/*
		 * Snmp V3 AgentAhXAOIDȂǂzuComposite
		 */
		GridLayout gridLayout = new GridLayout(2, false);
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		Label label = new Label(composite, SWT.NONE);
		label.setText("XML Socket allow-host");
		label.setLayoutData(new GridData());
		allowHostText = new Text(composite, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		allowHostText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("XML Socket port");
		gridData = new GridData();
		label.setLayoutData(gridData);

		xmlSocketPortText = new Text(composite, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		xmlSocketPortText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("XML Socket maxconnect");
		gridData = new GridData();
		label.setLayoutData(gridData);

		xmlSocketMaxConnectText = new Text(composite, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		xmlSocketMaxConnectText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Alert sound");
		label.setLayoutData(new GridData());
		alertSoundText = new Text(composite, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		alertSoundText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Refresh time(sec)");
		label.setLayoutData(new GridData());
		refreshTimeText = new Text(composite, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		refreshTimeText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Alert sound");
		label.setLayoutData(new GridData());
		alertSoundCombo = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);

		ArrayList soundList = MediaResource.getInstance().getSoundFileList();

		for (int i = 0; i < soundList.size(); i++) {
			String work = (String) soundList.get(i);
			int pathPoint = work.lastIndexOf("sound/");

			if (pathPoint >= 0) {
				alertSoundCombo.add(work.substring("sound/".length()));
			} else {
				alertSoundCombo.add(work);
			}
		}

		alertSoundCombo.select(0);

		showXMLSocketProp();

		/* Alert sound CombBoxI */
		alertSoundCombo.addSelectionListener(new SelectionAdapter() {
			/**
			 * 
			 */
			public void widgetSelected(SelectionEvent e) {
				alertSoundText.setText(alertSoundCombo.getText());
			}
		});

		return composite;
	}

	/*
	 * 
	 */
	private void showXMLSocketProp() {
		allowHostText.setText(resourceInfo.getXmlsocketAllowHost());
		xmlSocketPortText.setText(resourceInfo.getXmlSocketPort());
		xmlSocketMaxConnectText.setText(resourceInfo.getXmlSocketMaxConnect());
		alertSoundText.setText(resourceInfo.getAlertSound());
		refreshTimeText.setText(resourceInfo.getRefreshTime());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults() {
		resourceInfo = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo();
		showXMLSocketProp();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	public boolean performOk() {
		/*  */
		resourceInfo.setXmlsocketAllowHost(allowHostText.getText());
		resourceInfo.setXmlSocketPort(xmlSocketPortText.getText());
		resourceInfo.setXmlSocketMaxConnect(xmlSocketMaxConnectText.getText());
		resourceInfo.setAlertSound(alertSoundText.getText());
		resourceInfo.setRefreshTime(refreshTimeText.getText());

		/*  */
		saveResourceXMLInfo(resourceInfo);

		return super.performOk();
	}
}
