/*
 * Created on 2004/06/05
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.DatabasePropertyInfoList;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;



/**
 * ef[^x[XɑΉvpeBLqXMLt@C
 * 擾Af[^x[XʖɃXgƂĕێNXłB
 * if[^x[XeXgɐ܂j
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DatabasePropertyResource {

    /** f[^x[X^O */
    public static final String DATABASE = "database";

    /** f[^x[X^O */
    public static final String DATABASE_NAME = "database_name";

    /** hCo^O */
    public static final String DATABASE_DRIVER = "driver";

    /** URL^O */
    public static final String DATABASE_URL = "url";

    /** [U^O */
    public static final String DATABASE_USER = "user";

    /** pX[h^O */
    public static final String DATABASE_PASSWORD = "password";

    /* MO */
    private static Logger logger;

    /* f[^x[XʖvpeBXg */
    private DatabasePropertyInfoList databasepropList;

    /**
     * f[^x[XvpeBXgێNXCX^X
     * 𐶐܂B
     */
    private DatabasePropertyResource() {
        logger = Logger.getLogger(this.getClass().getName());

        Document doc = null;

        // jart@C邩fBNgwt@C擾邩
        // doc = getDocument(DATABASE_PROPERTY_XML_FILE);
        doc = getResourceFileDocumentPath(
                FilePreference.DATABASE_PROPERTY_XML_FILE);

        if (doc == null) {
            logger.severe("Resource File Doc null ");

            return;
        }

        try {
            // rootvfo
            Element root = doc.getRootElement();

            databasepropList = new DatabasePropertyInfoList();

            List mailList = root.getChildren(DATABASE);

            Iterator iterator = mailList.iterator();

            while (iterator.hasNext()) {
                DatabasePropertyInfo databaseProp = new DatabasePropertyInfo();
                Element mailListEl = (Element) iterator.next();

                databaseProp.setDatabaseName(
                    mailListEl.getChild(DATABASE_NAME).getAttributeValue(
                        "value"));
                databaseProp.setDatabaseDriver(
                    mailListEl.getChild(DATABASE_DRIVER).getAttributeValue(
                        "value"));
                databaseProp.setDatabaseUrl(
                    mailListEl.getChild(DATABASE_URL).getAttributeValue(
                        "value"));
                databaseProp.setDatabaseUser(
                    mailListEl.getChild(DATABASE_USER).getAttributeValue(
                        "value"));
                databaseProp.setDatabasePassword(
                    mailListEl.getChild(DATABASE_PASSWORD).getAttributeValue(
                        "value"));

                databasepropList.setDatabasePropList(databaseProp);
            }
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    /**
     * f[^x[XvpeB񃊃XgԂ܂B
     *
     * @return DatabasePropertyInfoList f[^x[XvpeB񃊃Xg
     */
    public DatabasePropertyInfoList getdatabasePropList() {
        return databasepropList;
    }

    /**
     * f[^x[XvpeBLq\[Xt@CpX擾܂B
     *
     * @return t@CpX
     */
    public String getDocumentPath() {
        /* 摜肷邽߂PluginResource bundle */
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = null;
        url = bundle.getEntry(FilePreference.DATABASE_PROPERTY_XML_FILE);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.severe(
                "URL Not Found : " + FilePreference.DATABASE_PROPERTY_XML_FILE);
            logger.severe("Database XML file url : " + url);

            return null;
        }

        return url.getPath();
    }

    /**
     * wfBNgXMLt@C͂DocumentԂ܂B
     * ijart@ČȂj
     *
     * @param file XMLt@C
     * @return doc Document
     */
    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;

        File f = new File(file);
        logger.info("Path : " + f.getAbsolutePath());

        if (f == null) {
            return null;
        }

        BufferedReader d = null;

        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();

            return null;
        }

        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(d);
        } catch (JDOMException e) {
            e.printStackTrace();
        } catch (NullPointerException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return doc;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static DatabasePropertyResource getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DatabasePropertyResource RESOURCE =
            new DatabasePropertyResource();
    }
}
