/*
 * Created on 2004/05/09
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * m[hIPAhXPing`FbNԂێNXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class BusyCheckForPing {
    /* m[hIPAhXL[ƂPop3Ď`FbNԂێMap */
    private static Map<String, Boolean> busyMap = Collections.synchronizedMap(new HashMap<String, Boolean>());

    /*
     * m[hIPAhXPing`FbNԂێNX
     * CX^X𐶐܂B
     */
    private BusyCheckForPing() {
    }

    /**
     * wm[hIPAhXBusy`FbN܂B
     * Busy̏ꍇfalseԂAbusyłȂꍇɂbusyZbgtrue
     * Ԃ܂B
     *
     * @param ipAddress m[hIPAhX
     * @return isBusy busytO
     */
    public synchronized boolean getArbitrationExec(final String ipAddress) {
        boolean isBusy = false;

        if (busyMap.containsKey(ipAddress)) {
            return isBusy;
        }

        isBusy = true;
        busyMap.put(ipAddress, null);

        return isBusy;
    }

    /**
     * wm[hIPAhXbusyԂ܂B
     *
     * @param ipAddress m[hIPAhX
     */
    public synchronized void release(final String ipAddress) {
        busyMap.remove(ipAddress);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static BusyCheckForPing getInstance() {
        return SingletonAboutMessage.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final BusyCheckForPing INSTANCE = new BusyCheckForPing();
    }
}
