/*
 * Created on 2004/05/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * IɃm[hiPingjĎ삷m[hĎ񃊃Xg
 * m[hIPAhXL[ƂĕێAPingĎsThread
 * 䂷邽߂̃XgێNXłB
 * ʃXbhł̃Xg̃JE^PbŃJEg_E0([)
 * ȂƎsL[Push܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ListQueuePingControl {
    /* IPAhXKeyƂPingĎێMap */
    private Map<String, NodeWatchInfo> pingHashMap;

    /*
     * IPAhXL[Ƃm[hĎێHashMap𐶐
     * ܂B
     */
    private ListQueuePingControl() {
        pingHashMap = Collections.synchronizedMap(new LinkedHashMap<String, NodeWatchInfo>());
    }

    /**
     * w肳ꂽIPAhXL[ƂāAm[hĎMapɊi[
     * ܂B
     * ̎APingĎJE^ɃZbg܂B
     *
     * @param ip m[hIPAhX
     * @param nodeInfo m[hĎ
     */
    public void setPingNode(String ip, NodeWatchInfo nodeInfo) {
        // PingJE^Zbg
        nodeInfo.setCountPingPeriod(nodeInfo.getPingPeriod());

        // Xgɒǉ
        pingHashMap.put(ip, nodeInfo);
    }

    /**
     * wm[hIPAhXPingĎԂ܂B
     *
     * @param ip m[hIPAhX
     * @return m[hĎ
     */
    public NodeWatchInfo getPingNode(String ip) {
        return (NodeWatchInfo) pingHashMap.get(ip);
    }

    /**
     * wm[hIPAhXPingĎ폜܂B
     *
     * @param ip m[hĎ
     */
    public void removePingNode(String ip) {
        pingHashMap.remove(ip);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ListQueuePingControl getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * m[hPingĎێMapԂ܂B
     *
     * @return m[hPingĎێMap
     */
    public Map getPingHashMap() {
        return pingHashMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final ListQueuePingControl DBPOOL = new ListQueuePingControl();
    }
}
