/*
 * Created on 2004/05/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * PingĎCxgL[ƂĊǗNXłB
 * PingĎCxg̃L[ɓo^APingĎThraed
 * ̂̈ThreadL[̃CxgǂݏoĎs܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class QueueForPing extends AbstractQueueForProtocolCheck {
    /*
     * PingĎCxgL[Ƃĕێ郊Xg
     */
    private List<NodeWatchInfo> list;

    /*
     * PingĎCxgL[ƂĊǗNXCX^X𐶐܂B
     *
     */
    private QueueForPing() {
        list = Collections.synchronizedList(new LinkedList<NodeWatchInfo>());
    }

    /**
     * m[hĎZbg܂B
     *
     * @param info m[hĎ
     */
    public synchronized void pushQue(NodeWatchInfo info) {
        if (!isPause) {
            checkQueueSize(list, info.getIpaddress());
            list.add(list.size(), info);
        }
    }

    /**
     * L[m[hĎPop܂B
     *
     * @return m[hĎ
     */
    public synchronized NodeWatchInfo popPingQueue() {
        NodeWatchInfo info = null;

        if (list.size() > 0) {
            if (!isPause) {
                info = (NodeWatchInfo) list.get(0);
            }

            list.remove(0);
        }

        return info;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static QueueForPing getInstance() {
        return SingletonAboutMessage.INSTANCE;
    }

    /**
     * PingĎCxgL[Ԃ܂B
     *
     * @return list PingĎCxgL[
     */
    public List getPingQueueList() {
        return list;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final QueueForPing INSTANCE = new QueueForPing();
    }
}
