/*
 * Created on 2004/05/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;


/**
 * Pop3ĎCxgL[ƂĊǗNXłB
 * Pop3ĎCxg̃L[ɓo^APop3ĎThraed
 * ̂̈ThreadL[̃CxgǂݏoĎs܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class QueueForPop3 extends AbstractQueueForProtocolCheck {
    /*
     * Pop3ĎCxgL[Ƃĕێ郊Xg
     */
    private List<NodeWatchInfo> list;

    /*
     * Pop3ĎCxgL[ƂĊǗNXCX^X𐶐܂B
     *
     */
    private QueueForPop3() {
        list = Collections.synchronizedList(new LinkedList<NodeWatchInfo>());
    }

    /**
     * m[hĎZbg܂B
     *
     * @param info m[hĎ
     */
    public synchronized void pushQue(NodeWatchInfo info) {
        if (!isPause) {
            checkQueueSize(list, info.getIpaddress());
            list.add(list.size(), info);
        }
    }

    /**
     * L[m[hĎPop܂B
     *
     * @return m[hĎ
     */
    public synchronized NodeWatchInfo popQueue() {
        NodeWatchInfo info = null;

        if (list.size() > 0) {
            if (!isPause) {
                info = (NodeWatchInfo) list.get(0);
            }

            list.remove(0);
        }

        return info;
    }

    /**
     * Pop3ĎCxgL[Ԃ܂B
     *
     * @return list Pop3ĎCxgL[
     */
    public List getPopQueueList() {
        return list;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static QueueForPop3 getInstance() {
        return SingletonAboutMessage.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final QueueForPop3 INSTANCE = new QueueForPop3();
    }

}
