/*
 * Created on 2004/05/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import netjfwatcher.engine.nodewatchinfo.OidGetInfo;



/**
 * SNMPvMIB̎悷CxgL[ƂĊǗNXłB
 * SNMPvMIB̎ɃCxg̃L[ɓo^ASNMPvMIB̎Thraed
 * ̂̈ThreadL[̃CxgǂݏoĎs܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class QueueForStatisticsMib extends AbstractQueueForProtocolCheck {
    /*
     * SNMPvMIB̎悷CxgL[Ƃĕێ郊Xg
     */
    private List<OidGetInfo> queueList;

    /*
     * SNMPvMIB̎悷CxgL[ƂĊǗNXCX^X
     * ܂B
     */
    private QueueForStatisticsMib() {
        queueList = Collections.synchronizedList(new LinkedList<OidGetInfo>());
    }

    /**
     * SNMPvMIB̎Zbg܂B
     *
     * @param info m[hĎ
     */
    public synchronized void pushQue(OidGetInfo info) {
        if (!isPause) {
            checkQueueSize(queueList, info.getTargetIpAddress());
            queueList.add(queueList.size(), info);
        }
    }

    /**
     * SNMPvMIB̎Ԃ܂B
     *
     * @return info SNMPvMIB̎
     */
    public synchronized OidGetInfo popQueue() {
        OidGetInfo info = null;

        if (queueList.size() > 0) {
            if (!isPause) {
                info = (OidGetInfo) queueList.get(0);
            }

            queueList.remove(0);
        }

        return info;
    }

    /**
     * SNMPvMIB̎悷CxgL[Ԃ܂B
     *
     * @return list SNMPvMIB̎悷CxgL[
     */
    public List getSnmpStatisticsList() {
        return queueList;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static QueueForStatisticsMib getInstance() {
        return SingletonAboutMessage.QUEUE_INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final QueueForStatisticsMib QUEUE_INSTANCE =
            new QueueForStatisticsMib();
    }
}
