/*
 * Created on 2006/12/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.database;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;

/**
 * URLɐANZXo邩`FbN郁\bhNX łB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ExecuteDatabaseWatch {

	/* MO */
	private static Logger logger = null;

	/**
	 * HTTPɂURL`FbNCX^X𐶐܂B
	 * 
	 */
	public ExecuteDatabaseWatch() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * wIPAhX̎wURL`FbN܂B
	 * 
	 * @param ipaddress
	 *            IPAhX
	 * @param nodeWatchInfo
	 *            m[hĎ
	 * 
	 */
	public void checkConnectDatabase(final String ipaddress,
			final NodeWatchInfo nodeWatchInfo) {

		DatabaseWatcherInfo databaseInfo = nodeWatchInfo
				.getDatabaseWatcherInfo();
		if (databaseInfo != null) {

			try {
				DatabaseCheck checkDatabase = new DatabaseCheck(ipaddress,
						databaseInfo.getDatabaseName());
				checkDatabase.checkDatabase(databaseInfo.getDatabaseDriver(),
						databaseInfo.getDatabaseUrl(), databaseInfo
								.getDatabaseUser(), databaseInfo
								.getDatabasePassword(), databaseInfo
								.getDatabaseSQL(), databaseInfo.isQuery(),
						false, false);
				/* Ďm[hŏI`FbNԍXV */
				LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate
						.getInstance();
				updateLastCheckTime.updateCheckTime(ipaddress);
			} catch (DatabaseConnectionException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			} catch (SQLException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			} catch (Exception e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}

		}

	}

}
