/*
 * Created on 2003/07/30
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.snmp;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;



/**
 * SNMP Interface MIB̎悵ăf[^x[XɊi[܂B
 *
 * 1.3.6.1.2.1.2.1     ifNumber
 * 1.3.6.1.2.1.2.2.1.1 ifIndex
 * 1.3.6.1.2.1.2.2.1.2 ifDescr
 * 1.3.6.1.2.1.2.2.1.3 ifType
 * 1.3.6.1.2.1.2.2.1.4 ifMtu
 * 1.3.6.1.2.1.2.2.1.5 ifSpeed
 * 1.3.6.1.2.1.2.2.1.6 ifPhysAddress
 * 1.3.6.1.2.1.2.2.1.7 ifAdminStatus
 * 1.3.6.1.2.1.2.2.1.8 ifOperStatus
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpInterfacesMibGet {
    /* MO */
    private static Logger logger;

    /*
     * C^tF[XMIB̎OID̔z
     */
    private static final String[] INTERFACE_OID_ARRAY =
        {
            "1.3.6.1.2.1.2.1", // ifNumber
            "1.3.6.1.2.1.2.2.1.1", // ifIndex
            "1.3.6.1.2.1.2.2.1.2", // ifDescr
            "1.3.6.1.2.1.2.2.1.3", // ifType
            "1.3.6.1.2.1.2.2.1.4", // ifMtu
            "1.3.6.1.2.1.2.2.1.5", // ifSpeed
            "1.3.6.1.2.1.2.2.1.6", // ifPhysAddress
            "1.3.6.1.2.1.2.2.1.7", // ifAdminStatus
            "1.3.6.1.2.1.2.2.1.8" // ifOperStatus
        };

    /* m[hIPAhX */
    private String targetIP;

    /* SNMPo[W */
    private int version;

    /* R~jeB */
    private String community;

    /* C^tF[XMIBe[uANZXCX^X */
    private final DBTableInterfaceMIB interfaceMibDBTable;

    /**
     * Snmp Interface MIB̎CX^X𐶐܂B
     *
     */
    public SnmpInterfacesMibGet() {
        logger = Logger.getLogger(this.getClass().getName());
        interfaceMibDBTable = DBTableInterfaceMIB.getInstance();
    }

    /**
     * Snmp Interface MIB̎ɂăp[^Zbg܂B
     *
     * @param targetIPAddress Target IP Address
     * @param version SNMPo[W
     * @param community R~jeB
     */
    public void setSnmpInterfacesMibGet(
        final String targetIPAddress, final int version, final String community) {
        this.targetIP = targetIPAddress;
        this.version = version;
        this.community = community;

        // this.snmptablename = snmptablename;
        // this.ValueObject = ValueObject;
        // mibget.setMibGetNext(targetip, version, community);
    }

    /**
     * m[hǉɃm[h̃C^tF[XMIB̎ŌĂ΂Am[h
     * C^tF[XMIB̎悵Af[^x[Xe[uɊi[܂B
     *
     * @throws UnknownHostException AgentAhXs̏ꍇ
     * @throws SocketException Socketsꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     */
    public void getInitialyzeInterfacesMIB()
        throws UnknownHostException, SocketException, SnmpMIBGetException {

        ArrayList[] initialyzeInterfacesList =
            new ArrayList[INTERFACE_OID_ARRAY.length];
        MibGetNextInfo mibGetInstance = null;

        try {
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        targetIP, Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetIP, "Initialyze Interfaces MIB", checkCount, version);
            }

            /* Snmp MIB̎̂߂̃p[^Zbg */
            mibGetInstance.setMibGetNext(targetIP, version, community);

            /* Interface MIB̎ */
            for (int i = 0; i < INTERFACE_OID_ARRAY.length; i++) {
                initialyzeInterfacesList[i] =
                    mibGetInstance.getNextMibValueList(INTERFACE_OID_ARRAY[i]);

                if (initialyzeInterfacesList[i] == null) {
                    return;
                }
            }

            /* ̎悵Interface MIBf[^x[XɊi[ */
            this.setInitialyzeDBInterfacesMIB(
                targetIP, initialyzeInterfacesList);
        } catch (SocketException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } catch (UnknownHostException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } catch (SnmpMIBGetException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } finally {
            /* MIB̎CX^XQueueɉ */
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetIP, Thread.currentThread().getName());
            }
        }
    }

    /**
     * m[h̃C^tF[XMIBĎ܂́Am[h̃C^
     * tF[XMIB̍ŐV̎掞ɌĂ΂Am[h̃C^tF[X
     * MIB̎sAf[^x[Xe[u̍XVs܂B
     *
     * @throws UnknownHostException AgentAhXs̏ꍇ
     * @throws SocketException Socketsꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     */
    public void getInterfacesMIB()
        throws UnknownHostException, SocketException, SnmpMIBGetException {

        ArrayList[] interfacesArrayList =
            new ArrayList[INTERFACE_OID_ARRAY.length];
        MibGetNextInfo mibGetInstance = null;

        try {
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        targetIP, Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetIP, "Interfaces MIB", checkCount, version);
            }

            mibGetInstance.setMibGetNext(targetIP, version, community);

            /* Interface MIB̎ */
            for (int i = 0; i < INTERFACE_OID_ARRAY.length; i++) {
                interfacesArrayList[i] =
                    mibGetInstance.getNextMibValueList(INTERFACE_OID_ARRAY[i]);

                if (interfacesArrayList[i] == null) {
                    logger.warning(
                        "Abort get Interface MIB = " + INTERFACE_OID_ARRAY[i]);

                    return;
                }
            }

            /* ̎悵Interface MIBf[^x[XɊi[ */
            if (interfacesArrayList != null) {
                this.setDBInterfacesMIB(targetIP, interfacesArrayList);
            }
        } catch (UnknownHostException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } catch (SocketException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } catch (SnmpMIBGetException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetIP, Thread.currentThread().getName());
            }
        }
    }

    /**
     * ̎悵Interface MIBlf[^x[XɊi[܂B
     *
     * @param targetip m[hIPAhX
     * @param interfacesList ̎悵Interface MIBli[Xgz
     */
    private void setInitialyzeDBInterfacesMIB(
        final String targetip, final ArrayList[] interfacesList) {
        try {
            /* e[uInterface MIBi[ */
            interfaceMibDBTable.putSNMPInterfaces(targetip, interfacesList);

            /*
             * Interface MIB̎悪̂ŁA
             * m[hSNMP\`Ď\ԂɃZbg
             */
            NodeWatchInfo nodeInfo =
                BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(targetip);
            nodeInfo.setInterfaceMIBStatus(NodeWatchInfo.INTERFACE_MIB_OK);
            BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodeInfo);
        } catch (SQLException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
        } catch (DatabaseConnectionException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
        }
    }

    /**
     * C^tF[XMIBf[^x[Xe[uXV܂B
     *
     * @param targetIPAddress m[hIPAhX
     * @param interfacesArrayList ̎悵Interface MIBli[Xgz
     */
    private void setDBInterfacesMIB(
        final String targetIPAddress, final ArrayList[] interfacesArrayList) {
        try {
            interfaceMibDBTable.updateSNMPInterfaces(
                targetIPAddress, interfacesArrayList);
        } catch (DatabaseConnectionException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIPAddress + " Version="
                + version + " Community=" + community);
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIPAddress + " Version="
                + version + " Community=" + community);
            e.printStackTrace();
        }
    }
}
