/*
 * Created on 2004/07/02
 *
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.taskschedule;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableTaskSchedule;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;


/**
 * ^XNXPW[ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class TaskScheduleControl {
    // MO
    private static Logger logger = null;

    /* ^XNXPW[ێ郊Xg */
    private Map<String, TaskScheduleInfo> taskScheduleList = Collections.synchronizedMap(new HashMap<String, TaskScheduleInfo>());

    // RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
    private TaskScheduleControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ^XNXPW[AԂɂĕێ郊XgɊi[܂B
     * ^XNXPW[ɂ́Aȉ̏ێĂ܂B
     *
     * E^XNID
     * E^XNX^[g
     * E^XNI
     * E^XN^C}[
     *
     * @param setStartDate ^XNJn
     * @param setEndDate ^XNI
     */
    public synchronized void setTaskSchedule(
        Date setStartDate, Date setEndDate) {
        Timer taskTimer = new Timer();

        /* wɎsiJnj^XNZbg */
        TimerTask threadStartTask = new TaskStart();
        taskTimer.schedule(threadStartTask, setStartDate);

        /* wɎsiIj^XNZbg */
        TimerTask threadStopTask = new TaskEnd();
        taskTimer.schedule(threadStopTask, setEndDate);

        /* ^XNXPW[𐶐āAXgɕێ */
        TaskScheduleInfo info = new TaskScheduleInfo();
        info.setTaskStartDate(setStartDate);
        info.setTaskEndDate(setEndDate);
        info.setTaskTimer(taskTimer);

        info.setId(info.hashCode());
        taskScheduleList.put(Integer.toString(info.hashCode()), info);
        logger.info("Task ID=" + info.hashCode());
        logger.info("Task Start date=" + info.getTaskStartDate());
        logger.info("Task End   date=" + info.getTaskEndDate());

        try {
            DBTableTaskSchedule taskScheduleTabel =
                DBTableTaskSchedule.getInstance();
            taskScheduleTabel.put(
                Integer.toString(info.hashCode()), info.getTaskStartDate(),
                info.getTaskEndDate());
        } catch (DatabaseConnectionException e) {
            logger.warning("DatabaseConnectionException " + e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning("SQLException " + e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * ^XNXPW[Zbg܂B
     *
     * @param info ^XNXPW[
     */
    public synchronized void setTaskSchedule(TaskScheduleInfo info) {
        Timer taskTimer = new Timer();

        /* wɎsiJnj^XNZbg */
        TimerTask threadStartTask = new TaskStart();
        taskTimer.schedule(threadStartTask, info.getTaskStartDate());

        /* wɎsiIj^XNZbg */
        TimerTask threadStopTask = new TaskEnd();
        taskTimer.schedule(threadStopTask, info.getTaskEndDate());

        /* ^XNXPW[𐶐āAXgɕێ */
        info.setTaskTimer(taskTimer);
        info.setId(Integer.parseInt(info.getTaskID()));
        taskScheduleList.put(info.getTaskID(), info);
        logger.info("Task ID=" + info.getId());
        logger.info("Task Start date=" + info.getTaskStartDate());
        logger.info("Task End   date=" + info.getTaskEndDate());
    }

    /**
     * ^XNXPW[LZ܂B
     *
     * @param info ^XNXPW[
     */
    public synchronized void cancelTaskSchedule(TaskScheduleInfo info) {
        logger.info("Cancel Task ID=" + info.getId());
        info.getTaskTimer().cancel();
        taskScheduleList.remove(info.getTaskID());

        try {
            DBTableTaskSchedule taskScheduleTabel =
                DBTableTaskSchedule.getInstance();
            taskScheduleTabel.deleteTaskSchedule(info.getTaskID());
        } catch (DatabaseConnectionException e) {
            logger.warning("DatabaseConnectionException " + e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning("SQLException " + e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * ^XNXPW[񃊃XgԂ܂B
     *
     *
     * @return taskScheduleList ^XNXPW[񃊃Xg
     */
    public synchronized Map getTaskSchedule() {
        return taskScheduleList;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static TaskScheduleControl getInstance() {
        return SingletonResource.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final TaskScheduleControl INSTANCE = new TaskScheduleControl();
    }
}
