/*
 * Created on 2003/08/11
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.xmlsocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.AbstractConnectClientCheck;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;


/**
 * NCAgXML\Pbgڑ҂XML Socket\Pbg
 * 𐶐A|[O[vɂăNCAg̐ڑ
 * ܂B<BR>
 *
 * NCAg̐ڑ󂯓ƁAT[oNC
 * Agւ̃CxgPUSHʒm̂
 * Xbh𐶐ANCAg-T[oڑԂێ܂B
 * <BR>
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class XMLSocketServer extends AbstractConnectClientCheck
    implements Runnable {
    // MO
    private static Logger logger = null;

    /* ServerSocket */
    private ServerSocket server;

    /*
     * ClientƂ̐ڑSocketXg(Client̐ڑ҂I
     * Socket closep)
     */
    private List<Socket> socketList = Collections.synchronizedList(new LinkedList<Socket>());

    /* XML Socketڑ҂Thread */
    private Thread xmlSocketServerThread;

    // \[X
    private SystemResourceFileParse resourceInfo;

    // ڑ҂|[g
    private int port;

    /* ڑzXg */
    private String allowHost;

    /*
     * RXgN^privateɂĕspӂɒڃRXgN^
     * Ăяoh~
     */
    private XMLSocketServer() {
        logger = Logger.getLogger(this.getClass().getName());

        /* \[XXMLSocketڑ|[gԍ𒊏o */
        resourceInfo =
            (SystemResourceConfig.getInstance()).getResourceFileParse();
        this.port =
            Integer.parseInt(resourceInfo.getResourceInfo().getXmlSocketPort());
        allowHost = resourceInfo.getResourceInfo().getXmlsocketAllowHost();
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static XMLSocketServer getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * NCAgXML\Pbgڑ҂XML Socket\Pbg
     * 𐶐A|[O[vɂăNCAg̐ڑ
     * XbhJn܂B<BR>
     *
     * @throws IOException ServerSocketɎsꍇ
     */
    public void startXMLSocketServerThread() throws IOException {
        /*
         * T[o[\Pbg𐶐ANCAgXML\Pbg
         * ڑ҂|[O[vɓ
         */
        server = new ServerSocket(port);
        logger.info("Create server socket : " + server.getLocalPort());

        xmlSocketServerThread = new Thread(SingletonResource.RESOURCE);
        xmlSocketServerThread.setDaemon(true);
        xmlSocketServerThread.start();
    }

    /**
     * XML SocketڑThread~܂B
     *
     */
    public void stopXMLSocketServerReceiving() {
        if (xmlSocketServerThread == null) {
            return;
        }

        // interrupt receive thread so it will die a natural death
        xmlSocketServerThread.interrupt();

        if (server != null) {
            try {
                server.close();
            } catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }

            /* Thread~܂Loop */
            while (
                (xmlSocketServerThread != null)
                    && xmlSocketServerThread.isAlive()) {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }

            server = null;
        }

        logger.info("XML Socket receive thread stop");
        xmlSocketServerThread = null;
    }

    /**
     * ServerSocket̃CX^X𐶐ANCAg̐ڑ
     * ҂[vɓB<BR>
     * NCAg̐ڑ󂯓ƁAT[oNCAg
     * ւ̃CxgPUSHʒm̂̃Xbh𐶐܂B<BR>
     *
     */
    public void run() {
        try {
            while (true) {
                //  ڑΎ󂯓
                Socket socket = server.accept();

                logger.info(
                    "Accept Address : "
                    + socket.getInetAddress().getHostAddress() + " : port :"
                    + socket.getLocalPort());
                logger.info("allowHost : " + allowHost);
                socket.setKeepAlive(true);

                // ڑIP Address
                String remoteIPAddress =
                    socket.getInetAddress().getHostAddress();
                logger.info("Connect remote IP Address : " + remoteIPAddress);

                /*
                 * ڑClientł邩`FbN
                 */
                boolean isAllowClient = checkHost(allowHost, remoteIPAddress);

                if (!isAllowClient) {
                    /* Client ڑ */
                    try {
                        socket.close();
                    } catch (IOException e) {
                        logger.warning(
                            "Reject socket close error" + e.getMessage());
                        e.printStackTrace();
                    }
                } else {
                    /* Clientڑ󂯓
                     * 󂯓ꂽڑpXbh𐶐EJn
                     * Local IP Addressy PORT
                     */
                    socketList.add(socket);

                    logger.info(
                        "Client address = " + socket.getLocalSocketAddress());
                    logger.info("Client port = " + socket.getLocalPort());

                    XMLSocketThread xmlthread = new XMLSocketThread(socket);
                    xmlthread.startXMLSocketThread(remoteIPAddress);
                }
            } // Client̐ڑ҂[v
        } catch (IOException ex) {
            /* Clientڑ҂Shutdown(퓮)yыN
             * ُȂǂُ̈̏ꍇ
             * (Client̐ؒfɂExceptionThreadőΉ)
             */
            if (server.isClosed()) {
                logger.info("Server socket closed " + ex.getMessage());
            } else {
                logger.warning(ex.getMessage());
            }
        } finally {
            for (int i = 0; i < socketList.size(); i++) {
                Socket test = (Socket) socketList.get(i);

                try {
                    logger.info("Closed socket = " + i);
                    test.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }

            socketList.clear();

            if (server != null) {
                try {
                    server.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * NCAgXML\Pbgڑ҂T[oThread
     * Ԃ܂B
     *
     * @return xmlSocketServerThread NCAgXML\Pbgڑ
     * ҂T[oThread
     */
    public Thread getXmlSocketServerThread() {
        return xmlSocketServerThread;
    }

    /**
     * ServerSocketN[Y܂B
     *
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (server != null) {
            server.close();
        }
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final XMLSocketServer RESOURCE = new XMLSocketServer();
    }
}
