/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * OIDL[ƂMibValueCX^XێNXłB
 * ́AOIDɑΉMibValueAgent̉OID͖
 * ɐVKɐ̂ł͂ȂAxς݂ł΁Agp
 * 邽߂̂̂łB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class MibValueQueue {
    /*
     * OIDL[ƂMibValueCX^XێMap
     */
    private static Map flyweightMap =
        Collections.synchronizedMap(new HashMap());

    /*
     * OIDL[ƂMibValueCX^XێNX
     * CX^X𐶐܂B
     */
    private MibValueQueue() {
        // nothing
    }

    /**
     * OIDɑΉMibValueCX^XԂ܂B
     *
     * @param oidKey OID
     * @return mibValue MibValueCX^X
     */
    public synchronized MibValue popMibValueQueue(String oidKey) {
        if (flyweightMap.containsKey(oidKey)) {
            /*
             * OIDɊYMibValueCX^X݂ꍇA
             * ԂB
             */
            return (MibValue) flyweightMap.get(oidKey);
        }

        /*
         * OIDɊYMibValueCX^X݂Ȃꍇɂ́A
         * ĕԂ
         */
        MibValue mibValue = new MibValue();
        flyweightMap.put(oidKey, mibValue);

        return mibValue;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static MibValueQueue getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final MibValueQueue DBPOOL = new MibValueQueue();
    }
}
